date
BINDIR=`dirname $0`

if [ -n "$BINDIR" ]
then
    JAS_HOME=`cd $BINDIR/.. > /dev/null 2>&1 && pwd`
    export JAS_HOME
fi

# Configuration file location
CONFIG_DIR=${JAS_HOME}/config

# We check for the apps server and load the necessary environment
# to make a run
APPSSERVER=`cat ${CONFIG_DIR}/appsserver`
echo "Apps server is ${APPSSERVER}"

ENVFILE=${CONFIG_DIR}/${APPSSERVER}.env

if [ ! -f ${ENVFILE} ] ; then
    echo "Cannot find config/${APPSSERVER}.env" >&2
    exit 1
fi

# Just get JAVA_HOME

# No awk on iSeries qsh -- just set JAVA_HOME explicitly
JAVA_HOME=/QIBM/ProdData/Java400/jdk13

# We check for JAVA_HOME. If not set, we do not
# continue processing.

CHECKPASSED=1
if [ -z "${JAVA_HOME}" ] ; then
    echo "JAVA_HOME not set" >&2
    exit 1
fi

# On X based systems, multiple environment variables are needed for
# the child process. So we just pass everything. This might not be
# needed for win32
shellProps() {
    for i in `env`
    do
	echo "-Denvironment.$i"
    done
}

${JAVA_HOME}/bin/java -classpath \
    ${JAS_HOME}/jars/launcher.jar:${J2EE_HOME}/lib/websphere.jar \
    -Djava.version=1.3 \
    -Xms256m \
    -Dspecjappserver.home=${JAS_HOME} \
    -Dnode.name=`uname -n` \
    `shellProps` \
  org.spec.jappserver.launcher.Script Driver $*
