import java.io.*;
import java.sql.*;
import org.spec.jappserver.load.DatabaseConnection;

public class CreateSPECDB {
    public static void main (String args[]) {
	CreateSPECDB me = new CreateSPECDB();
	try {
	    me.create(true);
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    private boolean verbose = true;
    private String JASHome;
    private String fs;

    public CreateSPECDB () {
	JASHome = System.getProperty ("specjappserver.home");
	if (JASHome == null) {
	    System.err.println ("System property specjappserver.home not set");
	    System.exit (1);
	}

	fs = System.getProperty ("file.separator");
    }


    public void create(boolean createCollection) throws Exception {
	// In a centralized environment, the schema_U.sql will be run once
	// for each of the domains -- dropping and recreating the table
	// each time.  Not terribly efficient, but it shouldn't be a big
	// deal...it's only one table and one index.  The alternatives would
	// be to add a flag indicating whether we are centralized or
	// distributed, or analyze the *db.properties files to determine
	// it from there.
	createDb ("corpdb.properties",
		new String[] {"schema_C.sql", "schema_U.sql"},
		createCollection);
	createDb ("mfgdb.properties",
		new String[] {"schema_M.sql", "schema_U.sql"},
		createCollection);
	createDb ("ordsdb.properties",
		new String[] {"schema_O.sql", "schema_U.sql"},
		createCollection);
	createDb ("suppdb.properties",
		new String[] {"schema_S.sql", "schema_U.sql"},
		createCollection);
    }

    // This method must throw Exception because
    // DatabaseConnection.getConnection throws Exception.  DatabaseConnection
    // should be changed to throw something more specific.
    private void createDb (String dbProps, String scripts[],
	    boolean createCollection) 
	    throws Exception {
	Connection c = null;
	Statement s = null;
	BufferedReader in = null;
	
	try {
	    c = DatabaseConnection.getConnection (dbProps);
	    s = c.createStatement();

	    if (createCollection) {
		try {
		    s.executeUpdate ("create collection spec");
		} catch (SQLException e) {
		    if (verbose) {
			System.err.println ("Create collection unsuccessful....continuing");
		    }
		}
	    }
		
	    for (int i = 0; i < scripts.length; i++) {
		String schema = JASHome + fs + "schema" + fs + "sql" + fs +
		    scripts[i];

		in = new BufferedReader (new FileReader (schema));

		String line = null;
		StringBuffer buf = new StringBuffer();
		while ((line = in.readLine()) != null) {
		    line = line.trim();
		    if (line.length() == 0) {
			continue;
		    }

		    // Ignore comments
		    if (line.startsWith ("--")) {
			continue;
		    }

		    if (line.endsWith (";")) {
			buf.append (' ');
			buf.append (line.substring (0, line.length() - 1));
			String stmt = buf.toString().trim();
			if (verbose) {
			    System.err.println ("Executing:  " + stmt);
			}
			if (stmt.length() >= 4 &&
				stmt.substring (0, 4).equalsIgnoreCase ("drop")) {
			    try {
				s.executeUpdate (stmt);
			    } catch (SQLException e) {
				if (verbose) {
				    System.err.println ("Drop unsuccessful...continuing");
				}
			    }
			} else {
			    s.executeUpdate (stmt);
			}
			buf.setLength (0);  // Reset the buffer
		    } else {
			buf.append (' ');
			buf.append (line);
		    }
		}
	    }
	} finally {
	    if (in != null) {
		try {
		    in.close();
		} catch (IOException e) {
		    // Ignore
		}
	    }

	    if (s != null) {
		try {
		    s.close();
		} catch (SQLException e) {
		    // Ignore
		}
	    }

	    if (c != null) {
		try {
		    c.close();
		} catch (SQLException e) {
		    // Ignore
		}
	    }
	}
    }
}

