/*
 * Decompiled with CFR 0.152.
 */
package org.spec.jappserver.load;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Properties;

public class DatabaseConnection {
    static final String DEFAULT_JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static int jdbcVersion = 1;
    private static String pipeDir = "/tmp";

    public static int getVersion() {
        return jdbcVersion;
    }

    public static String getPipeDir() {
        return pipeDir;
    }

    public static Connection getConnection(String propsFileName) throws Exception {
        String pipe;
        String version;
        String prefix = System.getProperty("specjappserver.home");
        if (prefix == null) {
            throw new Exception("System property specjappserver.home not set");
        }
        propsFileName = prefix + "/config/" + propsFileName;
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(propsFileName);
            props.load(in);
            in.close();
        }
        catch (Exception e) {
            throw new Exception("Cannot read properties file " + propsFileName + " . Make sure file exists\n" + e.toString());
        }
        String dbURL = props.getProperty("dbURL");
        if (dbURL == null) {
            throw new Exception("Property \"dbURL\" missing in properties file " + propsFileName);
        }
        String dbUser = props.getProperty("dbUser");
        if (dbUser == null) {
            throw new Exception("Property \"dbUser\" missing in properties file " + propsFileName);
        }
        String dbPassword = props.getProperty("dbPassword");
        if (dbPassword == null) {
            throw new Exception("Property \"dbPassword\" missing in properties file " + propsFileName);
        }
        String dbDriverClassName = props.getProperty("dbDriver");
        if (dbDriverClassName == null) {
            dbDriverClassName = DEFAULT_JDBC_DRIVER;
        }
        if ((version = props.getProperty("jdbcVersion")) != null) {
            try {
                jdbcVersion = Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                throw new Exception("Property \"jdbcVersion\" in file " + propsFileName + " is not an integer");
            }
        }
        if ((pipe = props.getProperty("pipeDir")) != null && new File(pipe).isDirectory()) {
            pipeDir = pipe;
        } else {
            System.out.println("WARNING : pipeDir not set or does not exist");
            System.out.println("WARNING : using default /tmp ");
        }
        Class<?> dbDriverClass = Class.forName(dbDriverClassName);
        Driver driver = (Driver)dbDriverClass.newInstance();
        DriverManager.registerDriver(driver);
        return DriverManager.getConnection(dbURL, dbUser, dbPassword);
    }
}

