/*
 * Decompiled with CFR 0.152.
 */
package org.spec.jappserver.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.StringTokenizer;
import org.spec.jappserver.load.DatabaseConnection;
import org.spec.jappserver.load.RandNum;

class LoadMfg {
    static int scale;
    static int jdbcVersion;
    static RandNum rand;
    static Connection dbConnection;
    static Connection utilDBConnection;
    static BufferedReader ipipe;
    int numAssemblies;
    static int OPEN;

    LoadMfg() {
        int n;
        rand = new RandNum();
        System.out.println("    --> Modified Mfg loader for XA Stuff");
        this.numAssemblies = n = (int)Math.ceil((double)scale / 100.0) * 100;
    }

    private static void usage() {
        System.err.println("Usage: java org.spec.jappserver.load.loadMfg <orders_injection_rate>");
        System.err.println("       11P parts, 11P boms, 11P workorders, 11P inventory");
        System.err.println("       where P is defined in Clause 4.2");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            LoadMfg.usage();
            return;
        }
        scale = Integer.parseInt(stringArray[0]);
        LoadMfg loadMfg = new LoadMfg();
        dbConnection = DatabaseConnection.getConnection("mfgdb.properties");
        utilDBConnection = DatabaseConnection.getConnection("utildb.properties");
        jdbcVersion = DatabaseConnection.getVersion();
        dbConnection.setAutoCommit(false);
        String string = DatabaseConnection.getPipeDir() + File.separator;
        ipipe = new BufferedReader(new FileReader(string + "mfgpipe"));
        loadMfg.cleanAll();
        loadMfg.loadAll();
    }

    private void cleanAll() throws IOException, SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = dbConnection.prepareStatement("truncate table M_parts");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table M_bom");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table M_workorder");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table M_largeorder");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table M_inventory");
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            preparedStatement = dbConnection.prepareStatement("delete from M_parts");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from M_bom");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from M_workorder");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from M_largeorder");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from M_inventory");
            preparedStatement.executeUpdate();
        }
        dbConnection.commit();
    }

    private void loadAll() throws IOException, SQLException {
        String[] stringArray = new String[100];
        String[] stringArray2 = new String[100];
        String[] stringArray3 = new String[100];
        String[] stringArray4 = new String[100];
        int[] nArray = new int[100];
        int[] nArray2 = new int[100];
        int[] nArray3 = new int[100];
        int[] nArray4 = new int[100];
        double[] dArray = new double[100];
        int[] nArray5 = new int[100];
        int[] nArray6 = new int[100];
        int[] nArray7 = new int[100];
        int[] nArray8 = new int[100];
        int n = 0;
        int n2 = 0;
        Bom bom = new Bom();
        WorkOrder workOrder = new WorkOrder();
        Inventory inventory = new Inventory();
        PreparedStatement preparedStatement = dbConnection.prepareStatement("insert into M_parts values(?,?,?,?,?,?,?,?,?)");
        try {
            try {
                String string;
                n2 = 0;
                while ((string = ipipe.readLine()) != null) {
                    ++n2;
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    stringArray[n] = stringTokenizer.nextToken();
                    stringArray2[n] = stringTokenizer.nextToken();
                    stringArray3[n] = stringTokenizer.nextToken();
                    stringArray4[n] = stringTokenizer.nextToken();
                    nArray3[n] = Integer.parseInt(stringTokenizer.nextToken());
                    nArray2[n] = Integer.parseInt(stringTokenizer.nextToken());
                    nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
                    nArray5[n] = Integer.parseInt(stringTokenizer.nextToken());
                    nArray8[n] = Integer.parseInt(stringTokenizer.nextToken());
                    nArray7[n] = nArray8[n] / 2;
                    preparedStatement.setString(1, stringArray[n]);
                    preparedStatement.setString(2, stringArray2[n]);
                    preparedStatement.setString(3, stringArray3[n]);
                    preparedStatement.setString(4, stringArray4[n]);
                    preparedStatement.setInt(5, nArray3[n]);
                    preparedStatement.setInt(6, nArray2[n]);
                    preparedStatement.setInt(7, nArray[n]);
                    preparedStatement.setInt(8, nArray7[n]);
                    preparedStatement.setInt(9, nArray8[n]);
                    if (jdbcVersion == 1) {
                        preparedStatement.executeUpdate();
                    } else {
                        preparedStatement.addBatch();
                    }
                    bom.loadBom(stringArray[n], nArray[n], nArray2[n]);
                    if (nArray2[n] != 0) {
                        workOrder.loadWorkOrder(stringArray[n], nArray[n], nArray2[n]);
                    }
                    inventory.loadInventory(stringArray[n], nArray[n], nArray2[n], nArray8[n], nArray7[n]);
                    if (++n != 100) continue;
                    n = 0;
                    if (jdbcVersion != 1) {
                        preparedStatement.executeBatch();
                    }
                    dbConnection.commit();
                }
                if (n != 0) {
                    if (jdbcVersion != 1) {
                        preparedStatement.executeBatch();
                    }
                    dbConnection.commit();
                }
                bom.loadRemainder();
                workOrder.loadRemainder();
                inventory.loadRemainder();
                this.loadSequence("workorder", this.numAssemblies + 1, 10000);
                this.loadSequence("largeorder", 1, 10000);
            }
            catch (IOException iOException) {
                System.err.println("Failed to read parts record " + n2 + " from mfgpipe");
                throw iOException;
            }
            Object var24_22 = null;
        }
        catch (Throwable throwable) {
            Object var24_23 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    private void loadSequence(String string, int n, int n2) throws SQLException {
        String string2;
        PreparedStatement preparedStatement = null;
        try {
            string2 = new String("DELETE FROM U_sequences WHERE S_ID = '" + string + "'");
            preparedStatement = utilDBConnection.prepareStatement(string2);
            preparedStatement.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string2 = new String("INSERT INTO U_sequences (s_id, s_nextnum, s_blocksize ) VALUES ( ?,?,? ) ");
        try {
            try {
                preparedStatement = utilDBConnection.prepareStatement(string2);
                int n3 = 1;
                preparedStatement.setString(n3++, string);
                preparedStatement.setInt(n3++, n);
                preparedStatement.setInt(n3++, n2);
                preparedStatement.executeUpdate();
                dbConnection.commit();
            }
            catch (SQLException sQLException) {
                System.err.println("Aborted Sequence Updation for " + string);
                throw sQLException;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    static {
        jdbcVersion = 1;
        OPEN = 1;
    }

    private static class Inventory {
        static PreparedStatement is;
        static String[] invPid;
        static int[] invQty;
        static int[] inAccCode;
        static String[] invLocation;
        static int i;
        static int j;
        static boolean first;
        java.sql.Date sqlDate = new java.sql.Date(new Date().getTime());

        private Inventory() {
        }

        private void loadInventory(String string, int n, int n2, int n3, int n4) throws SQLException {
            try {
                if (first) {
                    is = dbConnection.prepareStatement("insert into M_inventory values(?,?,?,?,0,?)");
                    first = false;
                }
                Inventory.invPid[Inventory.i] = string;
                Inventory.invQty[Inventory.i] = n3;
                Inventory.invLocation[Inventory.i] = rand.makeAString(20, 20);
                is.setString(1, invPid[i]);
                is.setInt(2, invQty[i]);
                is.setInt(3, 0);
                is.setString(4, invLocation[i]);
                is.setDate(5, this.sqlDate);
                if (jdbcVersion == 1) {
                    is.executeUpdate();
                } else {
                    is.addBatch();
                }
                if (++i == 100) {
                    i = 0;
                    if (jdbcVersion != 1) {
                        is.executeBatch();
                    }
                    dbConnection.commit();
                }
            }
            catch (SQLException sQLException) {
                System.err.println("Aborted Inventory load at record " + j);
                throw sQLException;
            }
        }

        void loadRemainder() throws SQLException {
            try {
                block5: {
                    try {
                        if (i == 0) break block5;
                        if (jdbcVersion != 1) {
                            is.executeBatch();
                        }
                        dbConnection.commit();
                    }
                    catch (SQLException sQLException) {
                        System.err.println("Aborted Inventory load at part " + invPid[0]);
                        throw sQLException;
                    }
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                is.close();
                throw throwable;
            }
            is.close();
        }

        static {
            invPid = new String[100];
            invQty = new int[100];
            inAccCode = new int[100];
            invLocation = new String[100];
            i = 0;
            j = 0;
            first = true;
        }
    }

    private static class WorkOrder {
        static PreparedStatement wos;
        static int[] woNumber;
        static int[] woOid;
        static int[] woOlid;
        static int[] woStatus;
        static int[] woOrigQty;
        static int[] woCompQty;
        static String[] woAssemblyId;
        static Timestamp[] woStartDate;
        static int i;
        static int j;
        static boolean first;
        Date curDate;

        private WorkOrder() {
        }

        private void loadWorkOrder(String string, int n, int n2) throws SQLException {
            try {
                if (first) {
                    wos = dbConnection.prepareStatement("insert into M_workorder values(?,?,?,?,?,?,?,NULL,?)");
                    first = false;
                }
                WorkOrder.woNumber[WorkOrder.i] = ++j;
                WorkOrder.woOlid[WorkOrder.i] = 0;
                WorkOrder.woOid[WorkOrder.i] = 0;
                WorkOrder.woOrigQty[WorkOrder.i] = rand.random(1, 1000);
                WorkOrder.woCompQty[WorkOrder.i] = rand.random(1, woOrigQty[i]);
                WorkOrder.woStatus[WorkOrder.i] = OPEN;
                WorkOrder.woAssemblyId[WorkOrder.i] = string;
                this.curDate = new Date();
                WorkOrder.woStartDate[WorkOrder.i] = new Timestamp(this.curDate.getTime());
                wos.setInt(1, woNumber[i]);
                wos.setInt(2, woOid[i]);
                wos.setInt(3, woOlid[i]);
                wos.setInt(4, woStatus[i]);
                wos.setString(5, woAssemblyId[i]);
                wos.setInt(6, woOrigQty[i]);
                wos.setInt(7, woCompQty[i]);
                wos.setTimestamp(8, woStartDate[i]);
                if (jdbcVersion == 1) {
                    wos.executeUpdate();
                } else {
                    wos.addBatch();
                }
                if (++i == 100) {
                    i = 0;
                    if (jdbcVersion != 1) {
                        wos.executeBatch();
                    }
                    dbConnection.commit();
                }
            }
            catch (SQLException sQLException) {
                System.err.println("Aborted Workorder at id " + woNumber[0]);
                throw sQLException;
            }
        }

        void loadRemainder() throws SQLException {
            try {
                block5: {
                    try {
                        if (i == 0) break block5;
                        if (jdbcVersion != 1) {
                            wos.executeBatch();
                        }
                        dbConnection.commit();
                    }
                    catch (SQLException sQLException) {
                        System.err.println("Aborted Workorder load at id " + woNumber[0]);
                        throw sQLException;
                    }
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                wos.close();
                throw throwable;
            }
            wos.close();
        }

        static {
            woNumber = new int[100];
            woOid = new int[100];
            woOlid = new int[100];
            woStatus = new int[100];
            woOrigQty = new int[100];
            woCompQty = new int[100];
            woAssemblyId = new String[100];
            woStartDate = new Timestamp[100];
            i = 0;
            j = 0;
            first = true;
        }
    }

    private static class Bom {
        PreparedStatement cs;
        String[] bCompId = new String[100];
        String[] bAssemblyId = new String[100];
        int[] bLineNum = new int[100];
        int[] bQty = new int[100];
        int[] bOps = new int[100];
        String[] bEngChange = new String[100];
        String[] bOpsDesc = new String[100];
        static int i = 0;
        static boolean first = true;
        static String lastAssembly;
        int lineno = 1;

        private Bom() {
        }

        void loadBom(String string, int n, int n2) throws SQLException {
            try {
                if (first) {
                    this.cs = dbConnection.prepareStatement("insert into M_bom values(?,?,?,?,?,?,?)");
                    first = false;
                }
                if (n2 == 0) {
                    this.bCompId[Bom.i] = string;
                    this.bAssemblyId[Bom.i] = lastAssembly;
                    ++this.lineno;
                    this.bQty[Bom.i] = rand.random(1, 20);
                    this.bOps[Bom.i] = rand.random(1, 20);
                    this.bEngChange[Bom.i] = "";
                    this.bOpsDesc[Bom.i] = rand.makeAString(50, 100);
                    this.cs.setString(1, this.bCompId[i]);
                    this.cs.setString(2, this.bAssemblyId[i]);
                    this.cs.setInt(3, this.bLineNum[i]);
                    this.cs.setInt(4, this.bQty[i]);
                    this.cs.setInt(5, this.bOps[i]);
                    this.cs.setString(6, this.bEngChange[i]);
                    this.cs.setString(7, this.bOpsDesc[i]);
                    if (jdbcVersion == 1) {
                        this.cs.executeUpdate();
                    } else {
                        this.cs.addBatch();
                    }
                    if (++i == 100) {
                        i = 0;
                        if (jdbcVersion != 1) {
                            this.cs.executeBatch();
                        }
                        dbConnection.commit();
                    }
                } else {
                    lastAssembly = string;
                    this.lineno = 1;
                }
            }
            catch (SQLException sQLException) {
                System.err.println("Aborted Bom load at Assembly " + this.bAssemblyId[0]);
                throw sQLException;
            }
        }

        void loadRemainder() throws SQLException {
            try {
                block5: {
                    try {
                        if (i == 0) break block5;
                        if (jdbcVersion != 1) {
                            this.cs.executeBatch();
                        }
                        dbConnection.commit();
                    }
                    catch (SQLException sQLException) {
                        System.err.println("Aborted Bom load at Assembly " + this.bAssemblyId[0]);
                        throw sQLException;
                    }
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.cs.close();
                throw throwable;
            }
            this.cs.close();
        }
    }
}

