/*
 * Decompiled with CFR 0.152.
 */
package org.spec.jappserver.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.spec.jappserver.load.DatabaseConnection;
import org.spec.jappserver.load.RandNum;
import org.spec.jappserver.load.RandPart;

class LoadOrds {
    static int scale;
    static int jdbcVersion;
    RandNum rand = new RandNum();
    static Connection dbConnection;
    static Connection corpDBConnection;
    static Connection utilDBConnection;
    static BufferedReader ipipe;
    int numItems = 0;

    LoadOrds() {
        System.out.println("    --> Modified Orders loader for XA Stuff");
    }

    private static void usage() {
        System.err.println("Usage: load <orders_injection_rate>");
        System.err.println("       75C customers, P items, 75C orders");
        System.err.println("       where C and P are defined in Clause 4.2");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            LoadOrds.usage();
            return;
        }
        scale = Integer.parseInt(stringArray[0]);
        LoadOrds loadOrds = new LoadOrds();
        dbConnection = DatabaseConnection.getConnection("ordsdb.properties");
        corpDBConnection = DatabaseConnection.getConnection("corpdb.properties");
        utilDBConnection = DatabaseConnection.getConnection("utildb.properties");
        jdbcVersion = DatabaseConnection.getVersion();
        dbConnection.setAutoCommit(false);
        String string = DatabaseConnection.getPipeDir() + File.separator;
        ipipe = new BufferedReader(new FileReader(string + "ordspipe"));
        loadOrds.cleanAll();
        loadOrds.loadAll();
    }

    private void cleanAll() throws IOException, SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = dbConnection.prepareStatement("truncate table O_customer");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table O_item");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table O_orders");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table O_orderline");
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            preparedStatement = dbConnection.prepareStatement("delete from O_customer");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from O_item");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from O_orders");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from O_orderline");
            preparedStatement.executeUpdate();
        }
        dbConnection.commit();
    }

    private void loadAll() throws IOException, SQLException {
        int n = (int)Math.ceil((double)scale / 10.0) * 10;
        int n2 = (int)Math.ceil((double)scale / 100.0) * 100;
        int n3 = 75 * n;
        int n4 = n2;
        int n5 = 75 * n;
        this.loadCustomer(n3);
        this.loadSequence("customer", n3 + 1, 10000);
        this.loadItem(n4);
        this.loadOrders(n3, n4, n5);
        this.loadSequence("order", n5 + 1, 10000);
    }

    private void loadSequence(String string, int n, int n2) throws SQLException {
        String string2;
        PreparedStatement preparedStatement = null;
        try {
            string2 = new String("DELETE FROM U_sequences WHERE S_ID = '" + string + "'");
            preparedStatement = utilDBConnection.prepareStatement(string2);
            preparedStatement.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string2 = new String("INSERT INTO U_sequences (s_id, s_nextnum, s_blocksize ) VALUES ( ?,?,? ) ");
        try {
            try {
                preparedStatement = utilDBConnection.prepareStatement(string2);
                int n3 = 1;
                preparedStatement.setString(n3++, string);
                preparedStatement.setInt(n3++, n);
                preparedStatement.setInt(n3++, n2);
                preparedStatement.executeUpdate();
                dbConnection.commit();
            }
            catch (SQLException sQLException) {
                System.err.println("     SQL State: " + sQLException.getSQLState());
                System.err.println("SQL Error Code: " + sQLException.getErrorCode());
                System.err.println("   SQL Message: " + sQLException.getMessage());
                System.err.println("Aborted Sequence Updation for " + string);
                throw sQLException;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    private void loadCustomer(int n) throws IOException, SQLException {
        PreparedStatement preparedStatement = null;
        int[] nArray = new int[100];
        String[] stringArray = new String[100];
        String[] stringArray2 = new String[100];
        String[] stringArray3 = new String[100];
        String[] stringArray4 = new String[100];
        String[] stringArray5 = new String[100];
        String[] stringArray6 = new String[100];
        String[] stringArray7 = new String[100];
        String[] stringArray8 = new String[100];
        String[] stringArray9 = new String[100];
        String[] stringArray10 = new String[100];
        Date[] dateArray = new Date[100];
        try {
            block11: {
                try {
                    preparedStatement = dbConnection.prepareStatement("insert into O_customer values(?,?,?,?,?,?,?,?,?,?,?,?)");
                    int n2 = 0;
                    int n3 = 1;
                    while (n3 <= n) {
                        String string = ipipe.readLine();
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                        stringArray[n2] = stringTokenizer.nextToken();
                        stringArray2[n2] = stringTokenizer.nextToken();
                        stringArray5[n2] = stringTokenizer.nextToken();
                        stringArray6[n2] = stringTokenizer.nextToken();
                        stringArray7[n2] = stringTokenizer.nextToken();
                        stringArray8[n2] = stringTokenizer.nextToken();
                        stringArray9[n2] = stringTokenizer.nextToken();
                        stringArray10[n2] = stringTokenizer.nextToken();
                        stringArray3[n2] = stringTokenizer.nextToken();
                        stringArray4[n2] = stringTokenizer.nextToken();
                        dateArray[n2] = Date.valueOf(stringTokenizer.nextToken());
                        preparedStatement.setInt(1, n3);
                        preparedStatement.setString(2, stringArray[n2]);
                        preparedStatement.setString(3, stringArray2[n2]);
                        preparedStatement.setString(4, stringArray5[n2]);
                        preparedStatement.setString(5, stringArray6[n2]);
                        preparedStatement.setString(6, stringArray7[n2]);
                        preparedStatement.setString(7, stringArray8[n2]);
                        preparedStatement.setString(8, stringArray9[n2]);
                        preparedStatement.setString(9, stringArray10[n2]);
                        preparedStatement.setString(10, stringArray3[n2]);
                        preparedStatement.setString(11, stringArray4[n2]);
                        preparedStatement.setDate(12, dateArray[n2]);
                        if (jdbcVersion == 1) {
                            preparedStatement.executeUpdate();
                        } else {
                            preparedStatement.addBatch();
                        }
                        if (++n2 == 100) {
                            n2 = 0;
                            if (jdbcVersion != 1) {
                                preparedStatement.executeBatch();
                            }
                            dbConnection.commit();
                        }
                        ++n3;
                    }
                    if (n2 == 0) break block11;
                    if (jdbcVersion != 1) {
                        preparedStatement.executeBatch();
                    }
                    dbConnection.commit();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to read customer from ordspipe at scale " + scale + " cId " + nArray[0]);
                    throw iOException;
                }
                catch (SQLException sQLException) {
                    System.err.println("Aborted customer at cId " + nArray[0]);
                    throw sQLException;
                }
            }
            Object var22_20 = null;
        }
        catch (Throwable throwable) {
            Object var22_21 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    private void loadItem(int n) throws IOException, SQLException {
        PreparedStatement preparedStatement = null;
        String[] stringArray = new String[100];
        String[] stringArray2 = new String[100];
        String[] stringArray3 = new String[100];
        double[] dArray = new double[100];
        float[] fArray = new float[100];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            block11: {
                try {
                    String string;
                    preparedStatement = dbConnection.prepareStatement("insert into O_item values(?,?,?,?,?)");
                    while ((string = ipipe.readLine()) != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        stringArray[n2] = stringTokenizer.nextToken();
                        ++n4;
                        stringArray2[n2] = stringTokenizer.nextToken();
                        stringArray3[n2] = stringTokenizer.nextToken();
                        dArray[n2] = Double.valueOf(stringTokenizer.nextToken());
                        fArray[n2] = (float)this.rand.drandom(0.0, 0.7);
                        preparedStatement.setString(1, stringArray[n2]);
                        preparedStatement.setString(2, stringArray2[n2]);
                        preparedStatement.setString(3, stringArray3[n2]);
                        preparedStatement.setDouble(4, dArray[n2]);
                        preparedStatement.setFloat(5, fArray[n2]);
                        if (jdbcVersion == 1) {
                            preparedStatement.executeUpdate();
                        } else {
                            preparedStatement.addBatch();
                        }
                        if (++n2 != 100) continue;
                        n2 = 0;
                        if (jdbcVersion != 1) {
                            preparedStatement.executeBatch();
                        }
                        dbConnection.commit();
                    }
                    if (n2 == 0) break block11;
                    if (jdbcVersion != 1) {
                        preparedStatement.executeBatch();
                    }
                    dbConnection.commit();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to read item record " + n3 + " from ordspipe");
                    throw iOException;
                }
                catch (SQLException sQLException) {
                    System.err.println("Aborted item at iId " + stringArray[0]);
                    throw sQLException;
                }
            }
            Object var16_13 = null;
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
        if (n4 != n) {
            System.err.println("Internal error. Expected " + n + " rows from ordspipe. Got " + n4);
        }
    }

    private void loadOrders(int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        Statement statement = dbConnection.createStatement();
        int[] nArray = new int[100];
        int[] nArray2 = new int[100];
        int[] nArray3 = new int[100];
        int[] nArray4 = new int[100];
        double[] dArray = new double[100];
        double[] dArray2 = new double[100];
        int[] nArray5 = new int[100];
        int[] nArray6 = new int[100];
        int[] nArray7 = new int[100];
        int[] nArray8 = new int[100];
        Object[] objectArray = new String[100];
        Timestamp timestamp = new Timestamp(new java.util.Date().getTime());
        int n4 = 0;
        RandPart randPart = new RandPart(scale);
        try {
            block20: {
                try {
                    preparedStatement = dbConnection.prepareStatement("insert into O_orders values(?,?,?,?,?,?,?, NULL)");
                    preparedStatement2 = dbConnection.prepareStatement("insert into O_orderline values(?,?,?,?,?, NULL)");
                    preparedStatement3 = corpDBConnection.prepareStatement("select c_credit from C_customer where c_id = ?");
                    int n5 = 0;
                    boolean bl = true;
                    n4 = 1;
                    while (n4 <= n3) {
                        int n6;
                        bl = true;
                        int n7 = 0;
                        while (bl) {
                            n7 = this.rand.random(1, n);
                            preparedStatement3.setInt(1, n7);
                            ResultSet resultSet = preparedStatement3.executeQuery();
                            if (!resultSet.next()) {
                                System.out.println("Unable to locate customer " + n7);
                                System.exit(16);
                            }
                            if (!resultSet.getString(1).equals("BC")) {
                                bl = false;
                            }
                            resultSet.close();
                        }
                        nArray2[n5] = n7;
                        nArray3[n5] = this.rand.random(1, 5);
                        nArray[n5] = n4;
                        dArray2[n5] = this.rand.drandom(1000.0, 10000.0);
                        nArray4[n5] = this.rand.random(1, 3);
                        int n8 = 0;
                        while (n8 < nArray3[n5]) {
                            int n9;
                            nArray6[n8] = n8 + 1;
                            nArray5[n8] = nArray[n5];
                            n6 = 0;
                            while (n6 == 0) {
                                objectArray[n8] = randPart.getPart(n2);
                                n9 = 0;
                                while (n9 < n8) {
                                    if (((String)objectArray[n8]).equals(objectArray[n9])) break;
                                    ++n9;
                                }
                                if (n9 != n8) continue;
                                n6 = 1;
                            }
                            nArray8[n8] = nArray4[n5];
                            n9 = this.rand.random(1, 100);
                            nArray7[n8] = n9 <= 10 ? this.rand.random(1, 99) : this.rand.random(1, 9);
                            ++n8;
                        }
                        Arrays.sort(objectArray, 0, nArray3[n5]);
                        n6 = 0;
                        while (n6 < nArray3[n5]) {
                            preparedStatement2.setInt(1, nArray6[n6]);
                            preparedStatement2.setInt(2, nArray[n5]);
                            preparedStatement2.setString(3, (String)objectArray[n6]);
                            preparedStatement2.setInt(4, nArray7[n6]);
                            preparedStatement2.setInt(5, nArray8[n6]);
                            if (jdbcVersion == 1) {
                                preparedStatement2.executeUpdate();
                            } else {
                                preparedStatement2.addBatch();
                            }
                            ++n6;
                        }
                        if (jdbcVersion != 1) {
                            preparedStatement2.executeBatch();
                        }
                        preparedStatement.setInt(1, nArray[n5]);
                        preparedStatement.setInt(2, nArray2[n5]);
                        preparedStatement.setInt(3, nArray3[n5]);
                        preparedStatement.setDouble(4, dArray[n5]);
                        preparedStatement.setDouble(5, dArray2[n5]);
                        preparedStatement.setInt(6, nArray4[n5]);
                        preparedStatement.setTimestamp(7, timestamp);
                        if (jdbcVersion == 1) {
                            preparedStatement.executeUpdate();
                        } else {
                            preparedStatement.addBatch();
                        }
                        if (++n5 == 100) {
                            n5 = 0;
                            if (jdbcVersion != 1) {
                                preparedStatement.executeBatch();
                            }
                            dbConnection.commit();
                        }
                        ++n4;
                    }
                    if (n5 == 0) break block20;
                    if (jdbcVersion != 1) {
                        preparedStatement.executeBatch();
                    }
                    dbConnection.commit();
                }
                catch (SQLException sQLException) {
                    System.err.println("Aborted orders at record " + n4);
                    throw sQLException;
                }
            }
            Object var29_30 = null;
        }
        catch (Throwable throwable) {
            Object var29_31 = null;
            preparedStatement.close();
            preparedStatement2.close();
            throw throwable;
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    static {
        jdbcVersion = 1;
    }
}

