/*
 * Decompiled with CFR 0.152.
 */
package org.spec.jappserver.load;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.spec.jappserver.load.DatabaseConnection;

class LoadRules {
    static String ruleName;
    static String ruleFile;
    static int scale;
    static int jdbcVersion;
    static Connection dbConnection;
    static BufferedReader ipipe;
    int numItems = 0;

    LoadRules() {
    }

    private static void usage() {
        System.err.println("Usage: java Loadrules <rulename> <rulefile>");
        System.err.println("rulename: name for the rule to load");
        System.err.println("rulefile: file to load for rule");
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            LoadRules.usage();
            return;
        }
        ruleName = argv[0];
        ruleFile = argv[1];
        LoadRules l = new LoadRules();
        dbConnection = DatabaseConnection.getConnection("corpdb.properties");
        jdbcVersion = DatabaseConnection.getVersion();
        dbConnection.setAutoCommit(false);
        ipipe = new BufferedReader(new FileReader(ruleFile));
        l.loadAll();
    }

    private void loadAll() throws IOException, SQLException {
        this.loadRules();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadRules() throws IOException, SQLException {
        PreparedStatement cs = null;
        try {
            try {
                cs = dbConnection.prepareStatement("insert into C_rule (r_id, r_text) values (?, ?)");
                cs.setString(1, ruleName);
                StringBuffer ruleText = new StringBuffer();
                String tempString = null;
                while (true) {
                    if ((tempString = ipipe.readLine()) == null) {
                        cs.setString(2, ruleText.toString());
                        if (cs.executeUpdate() < 1) {
                            System.err.println("LoadRules: Error loading rule.  Insert failed");
                        }
                        dbConnection.commit();
                        break;
                    }
                    ruleText.append(tempString + "\n");
                }
            }
            catch (IOException ie) {
                System.err.println("Failed to read input rule file: " + ie.getMessage());
                Object var5_7 = null;
                ipipe.close();
                return;
            }
            catch (SQLException se) {
                System.err.println("Error inserting into database: " + se.getMessage());
                Object var5_8 = null;
                ipipe.close();
                return;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            ipipe.close();
            throw throwable;
        }
        ipipe.close();
    }

    static {
        jdbcVersion = 1;
    }
}

