/*
 * Decompiled with CFR 0.152.
 */
package org.spec.jappserver.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.StringTokenizer;
import org.spec.jappserver.load.DatabaseConnection;
import org.spec.jappserver.load.RandNum;

class LoadSupp {
    static int scale;
    static int jdbcVersion;
    static RandNum rand;
    int numSuppliers;
    int numSites;
    int numAssemblies;
    static BufferedReader ipipe;
    static Connection dbConnection;
    static Connection utilDBConnection;

    LoadSupp() {
        rand = new RandNum();
        System.out.println("    --> Modified Supplier loader for XA Stuff");
    }

    private static void usage() {
        System.err.println("Usage: java sun.com.specjappserver.load.LoadSupp <orders_injection_rate>");
        System.err.println("       1 site, 10 suppliers, 10P components, 25P purchaseorders");
        System.err.println("       where C and P are defined in Clause 4.2");
    }

    public static void main(String[] stringArray) throws Exception {
        LoadSupp loadSupp = new LoadSupp();
        if (stringArray.length != 1) {
            LoadSupp.usage();
            return;
        }
        scale = Integer.parseInt(stringArray[0]);
        dbConnection = DatabaseConnection.getConnection("suppdb.properties");
        utilDBConnection = DatabaseConnection.getConnection("utildb.properties");
        jdbcVersion = DatabaseConnection.getVersion();
        dbConnection.setAutoCommit(false);
        String string = DatabaseConnection.getPipeDir() + File.separator;
        ipipe = new BufferedReader(new FileReader(string + "supppipe"));
        loadSupp.cleanAll();
        loadSupp.loadAll();
        dbConnection.close();
    }

    private void cleanAll() throws IOException, SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = dbConnection.prepareStatement("truncate table S_site");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table S_supplier");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table S_component");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table S_supp_component");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table S_purchase_order");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("truncate table S_purchase_orderline");
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            preparedStatement = dbConnection.prepareStatement("delete from S_site");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from S_supplier");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from S_component");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from S_supp_component");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from S_purchase_order");
            preparedStatement.executeUpdate();
            preparedStatement = dbConnection.prepareStatement("delete from S_purchase_orderline");
            preparedStatement.executeUpdate();
        }
        dbConnection.commit();
    }

    private void loadAll() throws IOException, SQLException {
        int n;
        this.numSites = 1;
        this.numSuppliers = 10;
        int n2 = (int)Math.ceil((double)scale / 10.0) * 10;
        int n3 = n = (int)Math.ceil((double)scale / 100.0) * 100;
        this.loadSites();
        this.loadSuppliers();
        this.loadComponents();
    }

    private void loadSequence(String string, int n, int n2) throws SQLException {
        String string2;
        PreparedStatement preparedStatement = null;
        try {
            string2 = new String("DELETE FROM U_sequences WHERE S_ID = '" + string + "'");
            preparedStatement = utilDBConnection.prepareStatement(string2);
            preparedStatement.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string2 = new String("INSERT INTO U_sequences (s_id, s_nextnum, s_blocksize ) VALUES ( ?,?,? ) ");
        try {
            try {
                preparedStatement = utilDBConnection.prepareStatement(string2);
                int n3 = 1;
                preparedStatement.setString(n3++, string);
                preparedStatement.setInt(n3++, n);
                preparedStatement.setInt(n3++, n2);
                preparedStatement.executeUpdate();
                dbConnection.commit();
            }
            catch (SQLException sQLException) {
                System.err.println("Aborted Sequence Updation for " + string);
                throw sQLException;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    private void loadComponents() throws IOException, SQLException {
        PreparedStatement preparedStatement = null;
        String[] stringArray = new String[100];
        String[] stringArray2 = new String[100];
        String[] stringArray3 = new String[100];
        String[] stringArray4 = new String[100];
        double[] dArray = new double[100];
        int n = 0;
        int n2 = 0;
        PurchaseOrder purchaseOrder = new PurchaseOrder(this.numSites, this.numSuppliers);
        try {
            try {
                String string;
                preparedStatement = dbConnection.prepareStatement("insert into S_component values(?,?,?,?,?,?,?,?,?)");
                while ((string = ipipe.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    stringArray[n2] = stringTokenizer.nextToken();
                    stringArray2[n2] = stringTokenizer.nextToken();
                    stringArray3[n2] = stringTokenizer.nextToken();
                    stringArray4[n2] = stringTokenizer.nextToken();
                    dArray[n2] = Double.valueOf(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    preparedStatement.setString(1, stringArray[n2]);
                    preparedStatement.setString(2, stringArray2[n2]);
                    preparedStatement.setString(3, stringArray3[n2]);
                    preparedStatement.setString(4, stringArray4[n2]);
                    preparedStatement.setDouble(5, dArray[n2]);
                    preparedStatement.setInt(6, 0);
                    preparedStatement.setInt(7, 0);
                    preparedStatement.setInt(8, n3);
                    preparedStatement.setInt(9, n4);
                    if (jdbcVersion == 1) {
                        preparedStatement.executeUpdate();
                    } else {
                        preparedStatement.addBatch();
                    }
                    ++n;
                    this.loadSupplierComponents(stringArray[n2], dArray[n2], n3);
                    purchaseOrder.load(stringArray[n2]);
                    if (++n2 != 100) continue;
                    n2 = 0;
                    if (jdbcVersion != 1) {
                        preparedStatement.executeBatch();
                    }
                    dbConnection.commit();
                }
                if (n2 != 0) {
                    if (jdbcVersion != 1) {
                        preparedStatement.executeBatch();
                    }
                    dbConnection.commit();
                }
                this.loadSequence("purchaseorder", purchaseOrder.getNumberOfPO() + 1, 10000);
            }
            catch (IOException iOException) {
                System.err.println("Failed to read Parts from supppipe at pId " + stringArray[0]);
                throw iOException;
            }
            catch (SQLException sQLException) {
                System.err.println("Aborted component at scale " + scale + " component " + n);
                throw sQLException;
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    private void loadSites() throws IOException, SQLException {
        PreparedStatement preparedStatement = null;
        int[] nArray = new int[10];
        String[] stringArray = new String[10];
        String[] stringArray2 = new String[10];
        String[] stringArray3 = new String[10];
        String[] stringArray4 = new String[10];
        String[] stringArray5 = new String[10];
        String[] stringArray6 = new String[10];
        String[] stringArray7 = new String[10];
        int n = 0;
        try {
            try {
                preparedStatement = dbConnection.prepareStatement("insert into S_site values(?,?,?,?,?,?,?,?)");
                int n2 = 0;
                n = 0;
                while (n < this.numSites) {
                    String string = ipipe.readLine();
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                    stringArray[n2] = stringTokenizer.nextToken();
                    stringArray2[n2] = stringTokenizer.nextToken();
                    stringArray3[n2] = stringTokenizer.nextToken();
                    stringArray4[n2] = stringTokenizer.nextToken();
                    stringArray5[n2] = stringTokenizer.nextToken();
                    stringArray6[n2] = stringTokenizer.nextToken();
                    stringArray7[n2] = stringTokenizer.nextToken();
                    preparedStatement.setInt(1, nArray[n2]);
                    preparedStatement.setString(2, stringArray[n2]);
                    preparedStatement.setString(3, stringArray2[n2]);
                    preparedStatement.setString(4, stringArray3[n2]);
                    preparedStatement.setString(5, stringArray4[n2]);
                    preparedStatement.setString(6, stringArray5[n2]);
                    preparedStatement.setString(7, stringArray6[n2]);
                    preparedStatement.setString(8, stringArray7[n2]);
                    if (jdbcVersion == 1) {
                        preparedStatement.executeUpdate();
                    } else {
                        preparedStatement.addBatch();
                    }
                    if (++n2 == 1) {
                        n2 = 0;
                        if (jdbcVersion != 1) {
                            preparedStatement.executeBatch();
                        }
                        dbConnection.commit();
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                System.err.println("Failed to read Site from supppipe at record " + n);
                throw iOException;
            }
            catch (SQLException sQLException) {
                System.err.println("Aborted site load site " + n);
                throw sQLException;
            }
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    private void loadSuppliers() throws IOException, SQLException {
        PreparedStatement preparedStatement = null;
        int[] nArray = new int[10];
        String[] stringArray = new String[10];
        String[] stringArray2 = new String[10];
        String[] stringArray3 = new String[10];
        String[] stringArray4 = new String[10];
        String[] stringArray5 = new String[10];
        String[] stringArray6 = new String[10];
        String[] stringArray7 = new String[10];
        String[] stringArray8 = new String[10];
        String[] stringArray9 = new String[10];
        int n = 0;
        try {
            block11: {
                try {
                    preparedStatement = dbConnection.prepareStatement("insert into S_supplier values(?,?,?,?,?,?,?,?,?,?)");
                    int n2 = 0;
                    n = 0;
                    while (n < this.numSuppliers) {
                        String string = ipipe.readLine();
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                        stringArray[n2] = stringTokenizer.nextToken();
                        stringArray4[n2] = stringTokenizer.nextToken();
                        stringArray5[n2] = stringTokenizer.nextToken();
                        stringArray6[n2] = stringTokenizer.nextToken();
                        stringArray7[n2] = stringTokenizer.nextToken();
                        stringArray8[n2] = stringTokenizer.nextToken();
                        stringArray9[n2] = stringTokenizer.nextToken();
                        stringArray2[n2] = stringTokenizer.nextToken();
                        stringArray3[n2] = stringTokenizer.nextToken();
                        preparedStatement.setInt(1, nArray[n2]);
                        preparedStatement.setString(2, stringArray[n2]);
                        preparedStatement.setString(3, stringArray4[n2]);
                        preparedStatement.setString(4, stringArray5[n2]);
                        preparedStatement.setString(5, stringArray6[n2]);
                        preparedStatement.setString(6, stringArray7[n2]);
                        preparedStatement.setString(7, stringArray8[n2]);
                        preparedStatement.setString(8, stringArray9[n2]);
                        preparedStatement.setString(9, stringArray2[n2]);
                        preparedStatement.setString(10, stringArray3[n2]);
                        if (jdbcVersion == 1) {
                            preparedStatement.executeUpdate();
                        } else {
                            preparedStatement.addBatch();
                        }
                        if (++n2 == 10) {
                            n2 = 0;
                            if (jdbcVersion != 1) {
                                preparedStatement.executeBatch();
                            }
                            dbConnection.commit();
                        }
                        ++n;
                    }
                    if (n2 == 0) break block11;
                    if (jdbcVersion != 1) {
                        preparedStatement.executeBatch();
                    }
                    dbConnection.commit();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to read Supplier from supppipe at record " + n);
                    throw iOException;
                }
                catch (SQLException sQLException) {
                    System.err.println("Aborted supplier load at supplier " + n);
                    throw sQLException;
                }
            }
            Object var18_17 = null;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    private void loadSupplierComponents(String string, double d, int n) throws SQLException {
        String string2 = string;
        int[] nArray = new int[10];
        double[] dArray = new double[10];
        int[] nArray2 = new int[10];
        double[] dArray2 = new double[10];
        int[] nArray3 = new int[10];
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = true;
        PreparedStatement preparedStatement = null;
        try {
            try {
                if (bl) {
                    preparedStatement = dbConnection.prepareStatement("insert into S_supp_component values(?,?,?,?,?,?)");
                    bl = false;
                }
                int n3 = this.numSuppliers;
                int n4 = 0;
                while (n4 < n3) {
                    bl2 = true;
                    block5: while (bl2) {
                        nArray[n4] = rand.random(1, this.numSuppliers);
                        bl2 = false;
                        n2 = 0;
                        while (n2 < n4) {
                            if (nArray[n2] == nArray[n4]) {
                                bl2 = true;
                                continue block5;
                            }
                            ++n2;
                        }
                    }
                    dArray[n4] = d;
                    nArray2[n4] = rand.random(10, 20);
                    dArray2[n4] = rand.drandom(0.0, 0.5);
                    nArray3[n4] = rand.random(1, n);
                    preparedStatement.setString(1, string2);
                    preparedStatement.setInt(2, nArray[n4]);
                    preparedStatement.setDouble(3, dArray[n4]);
                    preparedStatement.setInt(4, nArray2[n4]);
                    preparedStatement.setDouble(5, dArray2[n4]);
                    preparedStatement.setInt(6, nArray3[n4]);
                    if (jdbcVersion == 1) {
                        preparedStatement.executeUpdate();
                    } else {
                        preparedStatement.addBatch();
                    }
                    ++n4;
                }
                if (jdbcVersion != 1) {
                    preparedStatement.executeBatch();
                }
                dbConnection.commit();
            }
            catch (SQLException sQLException) {
                System.err.println("Aborted SupplierComponent load for component " + string2);
                throw sQLException;
            }
            Object var18_17 = null;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    static {
        jdbcVersion = 1;
    }

    private static class PurchaseOrder {
        int numSites;
        int numSuppliers;
        PreparedStatement ps;
        PreparedStatement pos;
        int poNumber;
        int poSuppId;
        int poSiteId;
        static int polcnt;
        int[] polNumber = new int[10];
        int[] polPoId = new int[10];
        int[] polQty = new int[10];
        String[] polPId = new String[10];
        String[] polMessage = new String[10];
        double[] polBalance = new double[10];
        static int i;
        static int j;
        static boolean first;
        static boolean newpo;
        Date curDate;
        java.sql.Date[] polDelDate = new java.sql.Date[10];

        public PurchaseOrder(int n, int n2) {
            this.numSites = n;
            this.numSuppliers = n2;
        }

        public int getNumberOfPO() {
            return this.poNumber;
        }

        private void load(String string) throws SQLException {
            try {
                int n;
                if (first) {
                    this.ps = dbConnection.prepareStatement("insert into S_purchase_order values(?,?,?)");
                    this.pos = dbConnection.prepareStatement("insert into S_purchase_orderline values(?,?,?,?,?,?,?)");
                    first = false;
                }
                if ((n = rand.random(1, 100)) > 10) {
                    return;
                }
                if (newpo) {
                    this.poNumber = ++j;
                    this.poSiteId = rand.random(1, this.numSites);
                    this.poSuppId = rand.random(1, this.numSuppliers);
                    this.ps.setInt(1, this.poNumber);
                    this.ps.setInt(2, this.poSuppId);
                    this.ps.setInt(3, this.poSiteId);
                    this.ps.executeUpdate();
                    polcnt = rand.random(1, 9);
                    i = 0;
                    newpo = false;
                }
                this.polNumber[PurchaseOrder.i] = i + 1;
                this.polPoId[PurchaseOrder.i] = this.poNumber;
                this.polPId[PurchaseOrder.i] = string;
                this.polQty[PurchaseOrder.i] = rand.random(1, 10000);
                this.polBalance[PurchaseOrder.i] = 0.0;
                this.polMessage[PurchaseOrder.i] = rand.makeAString(25, 100);
                this.curDate = new Date();
                this.polDelDate[PurchaseOrder.i] = new java.sql.Date(this.curDate.getTime() + -813934592L);
                this.pos.setInt(1, this.polNumber[i]);
                this.pos.setInt(2, this.polPoId[i]);
                this.pos.setString(3, this.polPId[i]);
                this.pos.setInt(4, this.polQty[i]);
                this.pos.setDouble(5, this.polBalance[i]);
                this.pos.setDate(6, this.polDelDate[i]);
                this.pos.setString(7, this.polMessage[i]);
                if (jdbcVersion == 1) {
                    this.pos.executeUpdate();
                } else {
                    this.pos.addBatch();
                }
                if (++i == polcnt) {
                    if (jdbcVersion != 1) {
                        this.ps.executeBatch();
                        this.pos.executeBatch();
                    }
                    dbConnection.commit();
                    newpo = true;
                }
            }
            catch (SQLException sQLException) {
                System.err.println("Aborted Purchase Order load at record " + j);
                throw sQLException;
            }
        }

        static {
            i = 0;
            j = 0;
            first = true;
            newpo = true;
        }
    }
}

