#!/bin/sh
#
# Copyright (c) 1998 by Sun Microsystems, Inc.
#
# $Id: createdb.sh 
#
# Script to create oracle database
#####################################################

##################
# check Parameters
##################
if [ $# -ne 2 ]
then
	echo "Usage: createdb.sh <database_name> <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi


####################
# Set the database and database directory vars
#####################
DB=$1
DB_DIR=$2
ORACLE_SID=$DB
export ORACLE_SID

###################################################
# If the database already exists warn that we will 
# destroy it.
####################################################
if [ -f "$ORACLE_HOME"/dbs/init${DB}.ora  ]
then
	echo  "$ORACLE_HOME"/dbs/init${DB}.ora
	/usr/bin/echo "Database already exists. Ok to destroy y/n ? \c"
	read junk
	if [ "$junk" != 'y' -a "$junk" != 'Y' ]
	then
		echo  "database create cancelled"
		exit 1
	fi
fi
####################################
# Check to see that the target database directory
# exists and has write permission.
####################################
if [ ! -d "$DB_DIR" ] 
then
	echo "$DB_DIR does not exist. Please create it first."
	exit 1
fi


########################################################
# Go and run the create_init.sh script
# to build the correct pfiles and .ora files for Oracle 
########################################################
echo "Creating the \$ORACLE_HOME/dbs .ora files ..."
create_init.sh $DB

####################################
# Environment vars an params look ok
# so go build the database
####################################

SYS=${DB_DIR}/sys_${DB}
LOG1=/dev/rdsk/c4t1d1s3
LOG2=/dev/rdsk/c4t1d1s4
ROLL=${DB_DIR}/roll_${DB}
#ROLL=/dev/rdsk/c1t5d2s3
TEMP=${DB_DIR}/temp_${DB}

rm -f $SYS $TEMP

# Create database
sqlplus /nolog <<EOT
CONNECT / as sysdba
shutdown abort
startup pfile=${ORACLE_HOME}/dbs/p_create_$DB.ora nomount

create database $DB	
controlfile reuse
	datafile '${SYS}' size 300M reuse
	logfile '${LOG1}' size 40000M reuse, 
		'${LOG2}' size 40000M reuse
	maxdatafiles 100;
exit
EOT

sqlplus /nolog <<EOT
CONNECT system/manager
CREATE UNDO TABLESPACE roll_space datafile '${ROLL}' size 250M reuse;
exit
EOT

################
# BEGIN COMMON
################

sqlplus /nolog <<EOT
CONNECT / as sysdba
shutdown
startup pfile=${ORACLE_HOME}/dbs/p_build_$DB.ora
exit
EOT

echo "Running catalog scripts ..."
sqlplus /nolog<<EOT >/dev/null 2>&1
CONNECT / as sysdba
@?/rdbms/admin/catalog.sql;
@?/rdbms/admin/catexp.sql
@?/rdbms/admin/catldr.sql
@?/rdbms/admin/catproc.sql
DISCONNECT;

CONNECT / as sysdba;
@?/rdbms/admin/utlmontr;
DISCONNECT;
EXIT
EOT


sqlplus /nolog<<EOT
connect / as sysdba
CREATE USER spec IDENTIFIED BY spec;
GRANT CONNECT, RESOURCE TO spec;
GRANT ALL PRIVILEGES TO spec IDENTIFIED BY spec;
EXIT
EOT


#############################
# Create the TEMP space
#############################
sqlplus /nolog<<EOT  &
CONNECT / as sysdba
CREATE TEMPORARY TABLESPACE temp_space
	TEMPFILE '${TEMP}' SIZE 9M;
EXIT
EOT

wait 

sqlplus /nolog<<EOT
CONNECT / as sysdba
ALTER USER spec
	TEMPORARY TABLESPACE temp_space;
EXIT
EOT

########################
# END OF DATABASE BUILD
########################
