#!/bin/sh
#
# Copyright (c) 1998 by Sun Microsystems, Inc.
#
# $Id: schema_S.sh,v 1.3 2001/04/28 00:21:45 ramesh Exp $
#
# Script to create supp database

# Create init.ora tables for SUPP database


# Tom Daly Jan 2000 
#     modify script to build Supplier specific 
#     tables and tablespaces against an existing database
#     This is to allow all of ECperf to run on one database
#     which will allow for easier testing and installation.
#     schema_S.sh now takes database name and database directory 
#     parameters.
#     Note: The database must now exist, refer to the createdb.sh script
#     to build the database prior to running this script.
#                     


if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ $# -ne 2 ]
then
	echo "Usage: schema_S.sh <database_name> <database dir>"
	exit 1
fi

DB=$1
DB_DIR=$2
ORACLE_SID=$DB
export ORACLE_SID


######  datafiles #####
COMP=${DB_DIR}/S_comp
SC=${DB_DIR}/S_suppcomp
SITE=${DB_DIR}/S_site
SUPP=${DB_DIR}/S_supp
PO=${DB_DIR}/S_po

sqlplus "/as sysdba" <<EOT  
shutdown
startup pfile=${ORACLE_HOME}/dbs/p_build_${DB}.ora
EOT

##############################################
#  clean up datafiles from  earlier attempts
##############################################
echo "Cleaning up old tables spaces"
sqlplus  /nolog <<EOT 
CONNECT system/manager 
DROP TABLESPACE S_comp_space INCLUDING CONTENTS;
DROP TABLESPACE S_sc_space INCLUDING CONTENTS;
DROP TABLESPACE S_po_space INCLUDING CONTENTS;
DROP TABLESPACE S_site_space INCLUDING CONTENTS;
DROP TABLESPACE S_supp_space INCLUDING CONTENTS;
EOT

echo "Removing Datafiles"
rm -f $COMP $SC $SITE $SUPP $PO $BIDS

##############################################
# Create the required tablespaces
##############################################

sqlplus  /nolog <<EOT  &
CONNECT system/manager
CREATE TABLESPACE S_comp_space
	DATAFILE '${COMP}' SIZE 18M
	EXTENT MANAGEMENT LOCAL  UNIFORM SIZE 1M;
EXIT
EOT

sqlplus  /nolog <<EOT  &
CONNECT system/manager
CREATE TABLESPACE S_sc_space
	DATAFILE '${SC}' SIZE 64M
	EXTENT MANAGEMENT LOCAL  UNIFORM SIZE 1M;
EXIT
EOT

sqlplus  /nolog <<EOT  &
CONNECT system/manager
CREATE TABLESPACE S_po_space
	DATAFILE '${PO}' SIZE 32M
	EXTENT MANAGEMENT LOCAL  UNIFORM SIZE 1M;
EXIT
EOT

sqlplus  /nolog <<EOT  &
CONNECT system/manager
CREATE TABLESPACE S_site_space
	DATAFILE '${SITE}' SIZE 2M
	EXTENT MANAGEMENT LOCAL  UNIFORM SIZE 100K;
EXIT
EOT

sqlplus  /nolog <<EOT  &
CONNECT system/manager
CREATE TABLESPACE S_supp_space
	DATAFILE '${SUPP}' SIZE 2M
	EXTENT MANAGEMENT LOCAL  UNIFORM SIZE 100K;
EXIT
EOT

wait

##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus /nolog <<EOT
CONNECT spec/spec
@sql/schema_S
EOT
