#!/bin/sh
#

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

######  datafiles #####
CUST=${DB_DIR}/O_cust
ORDS=${DB_DIR}/O_ords
ITEM=${DB_DIR}/O_item
ORDL=${DB_DIR}/O_ordl

#sqlplus '/ as sysdba' <<EOT  
#startup 
#EOT

sqlplus '/ as sysdba'  <<EOT 

DROP TABLESPACE O_cust_space INCLUDING CONTENTS;
DROP TABLESPACE O_ords_space INCLUDING CONTENTS;
DROP TABLESPACE O_ordl_space INCLUDING CONTENTS;
DROP TABLESPACE O_item_space INCLUDING CONTENTS;

CREATE TABLESPACE O_cust_space
	DATAFILE '${CUST}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE O_ords_space
	DATAFILE '${ORDS}' SIZE 5990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE O_ordl_space
	DATAFILE '${ORDL}' SIZE 5990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE O_item_space
	DATAFILE '${ITEM}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT


wait


##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec/spec <<EOT
@sql/schema_O
EOT
