#!/bin/sh
#
# Script to create oracle database

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "+ASM1" ]
then
        echo "$ORACLE_SID"
        echo "ORACLE_SID is set to ASM instance. Exiting!"
        exit 1
fi


####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1
LOGDB_DIR=$1

###################################################
# If the database already exists warn that we will 
# destroy it.
####################################################
#if [ -f "$ORACLE_HOME"/dbs/init${DB}.ora  ]
#then
#	echo  "$ORACLE_HOME"/dbs/init${DB}.ora
#	echo "Database already exists. Ok to destroy y/n ? \c"
#	read junk
#	if [ "$junk" != 'y' -a "$junk" != 'Y' ]
#	then
#	    echo  "database create cancelled"
#	    exit 1
#	fi
#else
########################################################
# Go and run the create_init.sh script
# to build the correct pfiles and .ora files for Oracle 
########################################################
#	echo "Creating the \$ORACLE_HOME/dbs .ora files ..."
#	./create_init.sh $DB $DB_DIR
#fi

####################################
# Check to see that the target database directory
# exists and has write permission.
####################################
#if [ ! -d "$DB_DIR" ] 
#then
#	echo "$DB_DIR does not exist. Please create it first."
#	exit 1
#fi

SYS=${DB_DIR}/sys_${DB}
SYS_AUX=${DB_DIR}/sysaux_${DB}

LOG1=${LOGDB_DIR}/log11_${DB}
LOG2=${LOGDB_DIR}/log12_${DB}
LOGSZ="150000M"

TEMP=${DB_DIR}/temp_ts1
STATS=${DB_DIR}/stats_${DB}
UNDO=${DB_DIR}/undo_${DB}


# Create database
sqlplus "/as sysdba" <<EOT
shutdown abort;
startup nomount

CREATE DATABASE $DB
CONTROLFILE REUSE
LOGFILE GROUP 11 '${LOG1}' SIZE ${LOGSZ} REUSE,
        GROUP 12 '${LOG2}' SIZE ${LOGSZ} REUSE
MAXDATAFILES 200
DATAFILE '${SYS}' size 4000M REUSE
SYSAUX DATAFILE '${SYS_AUX}' size 8000M REUSE
BIGFILE DEFAULT TEMPORARY TABLESPACE temp_ts
    TEMPFILE '${TEMP}' SIZE 8000M REUSE
BIGFILE UNDO TABLESPACE undo_ts DATAFILE '${UNDO}'  SIZE 100000M REUSE
    BLOCKSIZE 8k;
exit
EOT


echo "Running catalog scripts ..."
sqlplus <<EOT
CONNECT / as sysdba
@?/rdbms/admin/catalog;
@?/rdbms/admin/catexp.sql
@?/rdbms/admin/catldr.sql
@?/rdbms/admin/catproc.sql
@?/rdbms/admin/catparr.sql
@?/rdbms/admin/utlmontr;
EXIT
EOT

echo "Catalog done."

sqlplus <<EOT
CONNECT / as sysdba
drop user spec;
CREATE USER spec IDENTIFIED BY spec;
GRANT CONNECT, RESOURCE TO spec;
GRANT ALL PRIVILEGES TO spec IDENTIFIED BY spec;

-- CREATE TABLESPACE stats_ts
--        DATAFILE '${STATS}' SIZE 10000M REUSE
--        EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;

ALTER USER spec
	TEMPORARY TABLESPACE temp_ts;
EXIT
EOT

sqlplus "/as sysdba" <<EOT
ALTER TABLESPACE temp_ts ADD TEMPFILE '/u01/app/oracle/product/11.1.0/db_1/dbs/temp_ts2' SIZE 8000M;

create BIGFILE undo tablespace undo_ts2 datafile '${ORACLE_HOME}/dbs/undo_spec2' size 50000M REUSE BLOCKSIZE 8k;
alter database add logfile thread 2 group 21 '${ORACLE_HOME}/dbs/log21_spec2' size 150000M;
alter database add logfile thread 2 group 22 '${ORACLE_HOME}/dbs/log22_spec2' size 150000M;
alter database enable thread 2;

exit
EOT

