-- This CLP file was created using DB2LOOK Version "9.7" 
-- Timestamp: Mon 30 Nov 2009 09:31:10 PM CST
-- Database Name: SPECDB         
-- Database Manager Version: DB2/LINUXX8664 Version 9.7.0  
-- Database Codepage: 1208
-- Database Collating Sequence is: IDENTITY


CONNECT TO SPECDB;

------------------------------------------------
-- DDL Statements for Schemas
------------------------------------------------


CREATE SCHEMA "NEHALEM1NODE20" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM1NODE19" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM8NODE14" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM8NODE13" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM7NODE14" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM7NODE13" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM2NODE15" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM2NODE16" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM3NODE16" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM3NODE15" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM4NODE17" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM4NODE16" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM5NODE16" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM5NODE15" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM9NODE14" AUTHORIZATION "DB2INST3";

CREATE SCHEMA "NEHALEM9NODE13" AUTHORIZATION "DB2INST3";



------------------------------------------------
-- DDL Statements for table "DB2INST3"."M_BOM"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."M_BOM"  (
		  "B_COMP_ID" CHAR(20) NOT NULL , 
		  "B_ASSEMBLY_ID" CHAR(20) NOT NULL , 
		  "B_LINE_NO" INTEGER , 
		  "B_QTY" INTEGER , 
		  "B_OPS" INTEGER , 
		  "B_ENG_CHANGE" CHAR(10) , 
		  "B_OPS_DESC" VARCHAR(100) , 
		  "B_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."M_BOM"

CREATE UNIQUE INDEX "DB2INST3"."M_BOM_IDX" ON "DB2INST3"."M_BOM" 
		("B_ASSEMBLY_ID" ASC,
		 "B_COMP_ID" ASC,
		 "B_LINE_NO" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."M_WORKORDER"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."M_WORKORDER"  (
		  "WO_NUMBER" INTEGER NOT NULL , 
		  "WO_LOCATION" INTEGER NOT NULL , 
		  "WO_O_ID" INTEGER , 
		  "WO_OL_ID" INTEGER , 
		  "WO_STATUS" INTEGER , 
		  "WO_ASSEMBLY_ID" CHAR(20) , 
		  "WO_ORIG_QTY" INTEGER , 
		  "WO_COMP_QTY" INTEGER , 
		  "WO_DUE_DATE" TIMESTAMP , 
		  "WO_START_DATE" TIMESTAMP , 
		  "WO_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 

ALTER TABLE "DB2INST3"."M_WORKORDER" APPEND ON;

ALTER TABLE "DB2INST3"."M_WORKORDER" VOLATILE CARDINALITY;






-- DDL Statements for indexes on Table "DB2INST3"."M_WORKORDER"

CREATE UNIQUE INDEX "DB2INST3"."M_WO_IDX" ON "DB2INST3"."M_WORKORDER" 
		("WO_LOCATION" ASC,
		 "WO_NUMBER" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST3"."M_WORKORDER"

CREATE INDEX "DB2INST3"."M_WO_OOL_IDX" ON "DB2INST3"."M_WORKORDER" 
		("WO_LOCATION" ASC,
		 "WO_O_ID" ASC,
		 "WO_OL_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."O_CUSTINVENTORY"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."O_CUSTINVENTORY"  (
		  "CI_ID" INTEGER NOT NULL , 
		  "CI_CUSTOMERID" INTEGER NOT NULL , 
		  "CI_ITEMID" CHAR(20) , 
		  "CI_QUANTITY" INTEGER , 
		  "CI_VALUE" DECIMAL(12,2) , 
		  "CI_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 

ALTER TABLE "DB2INST3"."O_CUSTINVENTORY" PCTFREE 99;

ALTER TABLE "DB2INST3"."O_CUSTINVENTORY" APPEND ON;






-- DDL Statements for indexes on Table "DB2INST3"."O_CUSTINVENTORY"

CREATE UNIQUE INDEX "DB2INST3"."O_CI_IDX" ON "DB2INST3"."O_CUSTINVENTORY" 
		("CI_CUSTOMERID" ASC,
		 "CI_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."O_CUSTOMER"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."O_CUSTOMER"  (
		  "C_ID" INTEGER NOT NULL , 
		  "C_FIRST" CHAR(16) , 
		  "C_LAST" CHAR(16) , 
		  "C_STREET1" CHAR(20) , 
		  "C_STREET2" CHAR(20) , 
		  "C_CITY" CHAR(20) , 
		  "C_STATE" CHAR(2) , 
		  "C_COUNTRY" CHAR(10) , 
		  "C_ZIP" CHAR(9) , 
		  "C_PHONE" CHAR(16) , 
		  "C_CONTACT" CHAR(25) , 
		  "C_SINCE" DATE , 
		  "C_BALANCE" DECIMAL(12,2) , 
		  "C_CREDIT" CHAR(2) , 
		  "C_CREDIT_LIMIT" DECIMAL(12,2) , 
		  "C_YTD_PAYMENT" DECIMAL(12,2) , 
		  "C_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."O_CUSTOMER"

CREATE UNIQUE INDEX "DB2INST3"."O_C_IDX" ON "DB2INST3"."O_CUSTOMER" 
		("C_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."O_ORDERS"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."O_ORDERS"  (
		  "O_ID" INTEGER NOT NULL , 
		  "O_C_ID" INTEGER , 
		  "O_OL_CNT" INTEGER , 
		  "O_DISCOUNT" DECIMAL(4,2) , 
		  "O_TOTAL" DECIMAL(12,2) , 
		  "O_STATUS" INTEGER , 
		  "O_ENTRY_DATE" TIMESTAMP , 
		  "O_SHIP_DATE" DATE , 
		  "O_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 

ALTER TABLE "DB2INST3"."O_ORDERS" PCTFREE 99;

ALTER TABLE "DB2INST3"."O_ORDERS" APPEND ON;






-- DDL Statements for indexes on Table "DB2INST3"."O_ORDERS"

CREATE INDEX "DB2INST3"."O_OC_IDX" ON "DB2INST3"."O_ORDERS" 
		("O_C_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST3"."O_ORDERS"

CREATE UNIQUE INDEX "DB2INST3"."O_ORDS_IDX" ON "DB2INST3"."O_ORDERS" 
		("O_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."O_ORDERLINE"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."O_ORDERLINE"  (
		  "OL_ID" INTEGER NOT NULL , 
		  "OL_O_ID" INTEGER NOT NULL , 
		  "OL_I_ID" CHAR(20) , 
		  "OL_QTY" INTEGER , 
		  "OL_TOTAL_VALUE" DECIMAL(12,2) , 
		  "OL_MSRP" DECIMAL(12,2) , 
		  "OL_STATUS" INTEGER , 
		  "OL_SHIP_DATE" TIMESTAMP , 
		  "OL_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 

ALTER TABLE "DB2INST3"."O_ORDERLINE" PCTFREE 99;

ALTER TABLE "DB2INST3"."O_ORDERLINE" APPEND ON;






-- DDL Statements for indexes on Table "DB2INST3"."O_ORDERLINE"

CREATE UNIQUE INDEX "DB2INST3"."O_ORDL_IDX" ON "DB2INST3"."O_ORDERLINE" 
		("OL_O_ID" ASC,
		 "OL_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."O_ITEM"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."O_ITEM"  (
		  "I_ID" CHAR(20) NOT NULL , 
		  "I_NAME" CHAR(35) , 
		  "I_DESC" VARCHAR(100) , 
		  "I_PRICE" DECIMAL(12,2) , 
		  "I_DISCOUNT" DECIMAL(6,4) , 
		  "I_CATEGORY" INTEGER NOT NULL , 
		  "I_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 

ALTER TABLE "DB2INST3"."O_ITEM" VOLATILE CARDINALITY;






-- DDL Statements for indexes on Table "DB2INST3"."O_ITEM"

CREATE INDEX "DB2INST3"."O_ICAT_IDX" ON "DB2INST3"."O_ITEM" 
		("I_CATEGORY" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST3"."O_ITEM"

CREATE UNIQUE INDEX "DB2INST3"."O_I_IDX" ON "DB2INST3"."O_ITEM" 
		("I_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."S_COMPONENT"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."S_COMPONENT"  (
		  "COMP_ID" CHAR(20) NOT NULL , 
		  "COMP_SITE_ID" INTEGER NOT NULL , 
		  "COMP_NAME" CHAR(10) , 
		  "COMP_DESC" VARCHAR(100) , 
		  "COMP_UNIT" CHAR(10) , 
		  "COMP_COST" DECIMAL(12,2) , 
		  "QTY_ON_ORDER" INTEGER , 
		  "QTY_DEMANDED" INTEGER , 
		  "LEAD_TIME" INTEGER , 
		  "CONTAINER_SIZE" INTEGER , 
		  "COMP_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."S_COMPONENT"

CREATE UNIQUE INDEX "DB2INST3"."S_COMP_IDX" ON "DB2INST3"."S_COMPONENT" 
		("COMP_SITE_ID" ASC,
		 "COMP_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."S_SUPP_COMPONENT"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."S_SUPP_COMPONENT"  (
		  "SC_P_ID" CHAR(20) NOT NULL , 
		  "SC_SUPP_ID" INTEGER NOT NULL , 
		  "SC_PRICE" DECIMAL(12,2) , 
		  "SC_QTY" INTEGER , 
		  "SC_DISCOUNT" DECIMAL(6,4) , 
		  "SC_DEL_DATE" INTEGER , 
		  "SC_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."S_SUPP_COMPONENT"

CREATE UNIQUE INDEX "DB2INST3"."S_SC_IDX" ON "DB2INST3"."S_SUPP_COMPONENT" 
		("SC_P_ID" ASC,
		 "SC_SUPP_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."S_SUPPLIER"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."S_SUPPLIER"  (
		  "SUPP_ID" INTEGER NOT NULL , 
		  "SUPP_NAME" CHAR(16) , 
		  "SUPP_STREET1" CHAR(20) , 
		  "SUPP_STREET2" CHAR(20) , 
		  "SUPP_CITY" CHAR(20) , 
		  "SUPP_STATE" CHAR(2) , 
		  "SUPP_COUNTRY" CHAR(10) , 
		  "SUPP_ZIP" CHAR(9) , 
		  "SUPP_PHONE" CHAR(16) , 
		  "SUPP_CONTACT" CHAR(25) , 
		  "SUPP_WS_URL" VARCHAR(128) , 
		  "SUPP_REPLY_URL" VARCHAR(128) , 
		  "SUPP_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."S_SUPPLIER"

CREATE UNIQUE INDEX "DB2INST3"."S_SUPP_IDX" ON "DB2INST3"."S_SUPPLIER" 
		("SUPP_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."S_PURCH_ORDER"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."S_PURCH_ORDER"  (
		  "PO_NUMBER" INTEGER NOT NULL , 
		  "PO_SITE_ID" INTEGER NOT NULL , 
		  "PO_SUPP_ID" INTEGER , 
		  "PO_POPULAR_SUPP" INTEGER , 
		  "PO_START_DATE" TIMESTAMP , 
		  "PO_SENT_DATE" DATE , 
		  "PO_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 

ALTER TABLE "DB2INST3"."S_PURCH_ORDER" APPEND ON;






-- DDL Statements for indexes on Table "DB2INST3"."S_PURCH_ORDER"

CREATE INDEX "DB2INST3"."S_PODATE_IDX" ON "DB2INST3"."S_PURCH_ORDER" 
		("PO_SITE_ID" ASC,
		 "PO_START_DATE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST3"."S_PURCH_ORDER"

CREATE UNIQUE INDEX "DB2INST3"."S_PO_IDX" ON "DB2INST3"."S_PURCH_ORDER" 
		("PO_SITE_ID" ASC,
		 "PO_NUMBER" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."S_PURCH_ORDERLINE"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."S_PURCH_ORDERLINE"  (
		  "POL_NUMBER" INTEGER NOT NULL , 
		  "POL_PO_ID" INTEGER NOT NULL , 
		  "POL_LOCATION" INTEGER NOT NULL , 
		  "POL_P_ID" CHAR(20) , 
		  "POL_QTY" INTEGER , 
		  "POL_BALANCE" DECIMAL(12,2) , 
		  "POL_LEADTIME" INTEGER WITH DEFAULT 0 , 
		  "POL_DELDATE" DATE , 
		  "POL_MESSAGE" VARCHAR(100) , 
		  "POL_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."S_PURCH_ORDERLINE"

CREATE UNIQUE INDEX "DB2INST3"."S_POL_IDX" ON "DB2INST3"."S_PURCH_ORDERLINE" 
		("POL_LOCATION" ASC,
		 "POL_PO_ID" ASC,
		 "POL_NUMBER" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."S_RUN_CONFIG"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."S_RUN_CONFIG"  (
		  "NAME" VARCHAR(20) NOT NULL , 
		  "VALUE" INTEGER NOT NULL )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "DB2INST3"."U_SEQUENCES"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."U_SEQUENCES"  (
		  "S_ID" VARCHAR(50) NOT NULL , 
		  "S_NEXTNUM" INTEGER )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."U_SEQUENCES"

CREATE UNIQUE INDEX "DB2INST3"."U_S_IDX" ON "DB2INST3"."U_SEQUENCES" 
		("S_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."U_DATASEGMENT"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."U_DATASEGMENT"  (
		  "DS_ID" VARCHAR(100) NOT NULL , 
		  "DS_BLOB" CLOB(1048576) LOGGED NOT COMPACT )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."U_DATASEGMENT"

CREATE UNIQUE INDEX "DB2INST3"."DS_ID_IDX" ON "DB2INST3"."U_DATASEGMENT" 
		("DS_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."U_LOADER"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."U_LOADER"  (
		  "L_TXRATE" INTEGER , 
		  "L_ITEMCOUNT" INTEGER , 
		  "L_ITEMS_PER_TXRATE" INTEGER , 
		  "L_DBIR" INTEGER , 
		  "L_PARALLELISM" INTEGER , 
		  "L_IS_FF" INTEGER , 
		  "L_FF_DIR" VARCHAR(1000) , 
		  "L_FF_DEL" VARCHAR(10) , 
		  "L_IS_STANDALONE" INTEGER , 
		  "L_DB_DRIVER_CLASS" VARCHAR(512) , 
		  "L_DB_URL" VARCHAR(512) , 
		  "L_DB_USER" VARCHAR(512) , 
		  "L_DB_PASSWORD" VARCHAR(512) , 
		  "L_ROOT_SEED" DECIMAL(19,0) , 
		  "L_STATUS" INTEGER , 
		  "L_STARTED_AT" TIMESTAMP , 
		  "L_ENDED_AT" TIMESTAMP , 
		  "L_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."U_LOADER"

CREATE UNIQUE INDEX "DB2INST3"."L_TX_IDX" ON "DB2INST3"."U_LOADER" 
		("L_TXRATE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."U_LOAD_MESSAGE"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."U_LOAD_MESSAGE"  (
		  "LM_ID" INTEGER , 
		  "LM_TEXT" CLOB(1048576) LOGGED NOT COMPACT )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."U_LOAD_MESSAGE"

CREATE UNIQUE INDEX "DB2INST3"."LM_ID_IDX" ON "DB2INST3"."U_LOAD_MESSAGE" 
		("LM_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."U_LOAD_SECTION"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."U_LOAD_SECTION"  (
		  "LS_ID" INTEGER , 
		  "LS_DOMAIN" VARCHAR(50) , 
		  "LS_TABLENAMES" VARCHAR(200) , 
		  "LS_SECTION_ID" INTEGER , 
		  "LS_START_STEP" INTEGER , 
		  "LS_NUM_STEPS" INTEGER , 
		  "LS_STATE" INTEGER , 
		  "LS_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST3"."U_LOAD_SECTION"

CREATE UNIQUE INDEX "DB2INST3"."LS_ID_IDX" ON "DB2INST3"."U_LOAD_SECTION" 
		("LS_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM10NODE09"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM10NODE09"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM10NODE09"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM10NODE09"."SIB000"

CREATE UNIQUE INDEX "NEHALEM10NODE09"."SIB000PKIX" ON "NEHALEM10NODE09"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM10NODE09"."SIB000"

ALTER TABLE "NEHALEM10NODE09"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM10NODE09"."SIB000"

CREATE INDEX "NEHALEM10NODE09"."SIB000STREAMIX" ON "NEHALEM10NODE09"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM10NODE09"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM10NODE09"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM10NODE09"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM10NODE09"."SIB001"

CREATE UNIQUE INDEX "NEHALEM10NODE09"."SIB001PKIX" ON "NEHALEM10NODE09"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM10NODE09"."SIB001"

ALTER TABLE "NEHALEM10NODE09"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM10NODE09"."SIB001"

CREATE INDEX "NEHALEM10NODE09"."SIB001STREAMIX" ON "NEHALEM10NODE09"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM10NODE09"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM10NODE09"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM10NODE09"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM10NODE09"."SIB002"

CREATE UNIQUE INDEX "NEHALEM10NODE09"."SIB002PKIX" ON "NEHALEM10NODE09"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM10NODE09"."SIB002"

ALTER TABLE "NEHALEM10NODE09"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM10NODE09"."SIB002"

CREATE INDEX "NEHALEM10NODE09"."SIB002STREAMIX" ON "NEHALEM10NODE09"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM10NODE10"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM10NODE10"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM10NODE10"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM10NODE10"."SIB000"

CREATE UNIQUE INDEX "NEHALEM10NODE10"."SIB000PKIX" ON "NEHALEM10NODE10"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM10NODE10"."SIB000"

ALTER TABLE "NEHALEM10NODE10"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM10NODE10"."SIB000"

CREATE INDEX "NEHALEM10NODE10"."SIB000STREAMIX" ON "NEHALEM10NODE10"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM10NODE10"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM10NODE10"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM10NODE10"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM10NODE10"."SIB001"

CREATE UNIQUE INDEX "NEHALEM10NODE10"."SIB001PKIX" ON "NEHALEM10NODE10"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM10NODE10"."SIB001"

ALTER TABLE "NEHALEM10NODE10"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM10NODE10"."SIB001"

CREATE INDEX "NEHALEM10NODE10"."SIB001STREAMIX" ON "NEHALEM10NODE10"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM10NODE10"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM10NODE10"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM10NODE10"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM10NODE10"."SIB002"

CREATE UNIQUE INDEX "NEHALEM10NODE10"."SIB002PKIX" ON "NEHALEM10NODE10"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM10NODE10"."SIB002"

ALTER TABLE "NEHALEM10NODE10"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM10NODE10"."SIB002"

CREATE INDEX "NEHALEM10NODE10"."SIB002STREAMIX" ON "NEHALEM10NODE10"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM11NODE05"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM11NODE05"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM11NODE05"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM11NODE05"."SIB000"

CREATE UNIQUE INDEX "NEHALEM11NODE05"."SIB000PKIX" ON "NEHALEM11NODE05"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM11NODE05"."SIB000"

ALTER TABLE "NEHALEM11NODE05"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM11NODE05"."SIB000"

CREATE INDEX "NEHALEM11NODE05"."SIB000STREAMIX" ON "NEHALEM11NODE05"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM11NODE05"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM11NODE05"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM11NODE05"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM11NODE05"."SIB001"

CREATE UNIQUE INDEX "NEHALEM11NODE05"."SIB001PKIX" ON "NEHALEM11NODE05"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM11NODE05"."SIB001"

ALTER TABLE "NEHALEM11NODE05"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM11NODE05"."SIB001"

CREATE INDEX "NEHALEM11NODE05"."SIB001STREAMIX" ON "NEHALEM11NODE05"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM11NODE05"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM11NODE05"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM11NODE05"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM11NODE05"."SIB002"

CREATE UNIQUE INDEX "NEHALEM11NODE05"."SIB002PKIX" ON "NEHALEM11NODE05"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM11NODE05"."SIB002"

ALTER TABLE "NEHALEM11NODE05"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM11NODE05"."SIB002"

CREATE INDEX "NEHALEM11NODE05"."SIB002STREAMIX" ON "NEHALEM11NODE05"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM11NODE06"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM11NODE06"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM11NODE06"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM11NODE06"."SIB000"

CREATE UNIQUE INDEX "NEHALEM11NODE06"."SIB000PKIX" ON "NEHALEM11NODE06"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM11NODE06"."SIB000"

ALTER TABLE "NEHALEM11NODE06"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM11NODE06"."SIB000"

CREATE INDEX "NEHALEM11NODE06"."SIB000STREAMIX" ON "NEHALEM11NODE06"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM11NODE06"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM11NODE06"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM11NODE06"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM11NODE06"."SIB001"

CREATE UNIQUE INDEX "NEHALEM11NODE06"."SIB001PKIX" ON "NEHALEM11NODE06"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM11NODE06"."SIB001"

ALTER TABLE "NEHALEM11NODE06"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM11NODE06"."SIB001"

CREATE INDEX "NEHALEM11NODE06"."SIB001STREAMIX" ON "NEHALEM11NODE06"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM11NODE06"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM11NODE06"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM11NODE06"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM11NODE06"."SIB002"

CREATE UNIQUE INDEX "NEHALEM11NODE06"."SIB002PKIX" ON "NEHALEM11NODE06"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM11NODE06"."SIB002"

ALTER TABLE "NEHALEM11NODE06"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM11NODE06"."SIB002"

CREATE INDEX "NEHALEM11NODE06"."SIB002STREAMIX" ON "NEHALEM11NODE06"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE15"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE15"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM1NODE15"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE15"."SIB000"

CREATE UNIQUE INDEX "NEHALEM1NODE15"."SIB000PKIX" ON "NEHALEM1NODE15"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE15"."SIB000"

ALTER TABLE "NEHALEM1NODE15"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE15"."SIB000"

CREATE INDEX "NEHALEM1NODE15"."SIB000STREAMIX" ON "NEHALEM1NODE15"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE15"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE15"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM1NODE15"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE15"."SIB001"

CREATE UNIQUE INDEX "NEHALEM1NODE15"."SIB001PKIX" ON "NEHALEM1NODE15"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE15"."SIB001"

ALTER TABLE "NEHALEM1NODE15"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE15"."SIB001"

CREATE INDEX "NEHALEM1NODE15"."SIB001STREAMIX" ON "NEHALEM1NODE15"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE15"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE15"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM1NODE15"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE15"."SIB002"

CREATE UNIQUE INDEX "NEHALEM1NODE15"."SIB002PKIX" ON "NEHALEM1NODE15"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE15"."SIB002"

ALTER TABLE "NEHALEM1NODE15"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE15"."SIB002"

CREATE INDEX "NEHALEM1NODE15"."SIB002STREAMIX" ON "NEHALEM1NODE15"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE16"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE16"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM1NODE16"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE16"."SIB000"

CREATE UNIQUE INDEX "NEHALEM1NODE16"."SIB000PKIX" ON "NEHALEM1NODE16"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE16"."SIB000"

ALTER TABLE "NEHALEM1NODE16"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE16"."SIB000"

CREATE INDEX "NEHALEM1NODE16"."SIB000STREAMIX" ON "NEHALEM1NODE16"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE16"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE16"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM1NODE16"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE16"."SIB001"

CREATE UNIQUE INDEX "NEHALEM1NODE16"."SIB001PKIX" ON "NEHALEM1NODE16"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE16"."SIB001"

ALTER TABLE "NEHALEM1NODE16"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE16"."SIB001"

CREATE INDEX "NEHALEM1NODE16"."SIB001STREAMIX" ON "NEHALEM1NODE16"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE16"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE16"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM1NODE16"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE16"."SIB002"

CREATE UNIQUE INDEX "NEHALEM1NODE16"."SIB002PKIX" ON "NEHALEM1NODE16"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE16"."SIB002"

ALTER TABLE "NEHALEM1NODE16"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE16"."SIB002"

CREATE INDEX "NEHALEM1NODE16"."SIB002STREAMIX" ON "NEHALEM1NODE16"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE11"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE11"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM2NODE11"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE11"."SIB000"

CREATE UNIQUE INDEX "NEHALEM2NODE11"."SIB000PKIX" ON "NEHALEM2NODE11"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE11"."SIB000"

ALTER TABLE "NEHALEM2NODE11"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE11"."SIB000"

CREATE INDEX "NEHALEM2NODE11"."SIB000STREAMIX" ON "NEHALEM2NODE11"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE11"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE11"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM2NODE11"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE11"."SIB001"

CREATE UNIQUE INDEX "NEHALEM2NODE11"."SIB001PKIX" ON "NEHALEM2NODE11"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE11"."SIB001"

ALTER TABLE "NEHALEM2NODE11"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE11"."SIB001"

CREATE INDEX "NEHALEM2NODE11"."SIB001STREAMIX" ON "NEHALEM2NODE11"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE11"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE11"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM2NODE11"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE11"."SIB002"

CREATE UNIQUE INDEX "NEHALEM2NODE11"."SIB002PKIX" ON "NEHALEM2NODE11"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE11"."SIB002"

ALTER TABLE "NEHALEM2NODE11"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE11"."SIB002"

CREATE INDEX "NEHALEM2NODE11"."SIB002STREAMIX" ON "NEHALEM2NODE11"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE12"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE12"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM2NODE12"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE12"."SIB000"

CREATE UNIQUE INDEX "NEHALEM2NODE12"."SIB000PKIX" ON "NEHALEM2NODE12"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE12"."SIB000"

ALTER TABLE "NEHALEM2NODE12"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE12"."SIB000"

CREATE INDEX "NEHALEM2NODE12"."SIB000STREAMIX" ON "NEHALEM2NODE12"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE12"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE12"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM2NODE12"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE12"."SIB001"

CREATE UNIQUE INDEX "NEHALEM2NODE12"."SIB001PKIX" ON "NEHALEM2NODE12"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE12"."SIB001"

ALTER TABLE "NEHALEM2NODE12"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE12"."SIB001"

CREATE INDEX "NEHALEM2NODE12"."SIB001STREAMIX" ON "NEHALEM2NODE12"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE12"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE12"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM2NODE12"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE12"."SIB002"

CREATE UNIQUE INDEX "NEHALEM2NODE12"."SIB002PKIX" ON "NEHALEM2NODE12"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE12"."SIB002"

ALTER TABLE "NEHALEM2NODE12"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE12"."SIB002"

CREATE INDEX "NEHALEM2NODE12"."SIB002STREAMIX" ON "NEHALEM2NODE12"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE11"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE11"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM3NODE11"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE11"."SIB000"

CREATE UNIQUE INDEX "NEHALEM3NODE11"."SIB000PKIX" ON "NEHALEM3NODE11"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE11"."SIB000"

ALTER TABLE "NEHALEM3NODE11"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE11"."SIB000"

CREATE INDEX "NEHALEM3NODE11"."SIB000STREAMIX" ON "NEHALEM3NODE11"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE11"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE11"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM3NODE11"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE11"."SIB001"

CREATE UNIQUE INDEX "NEHALEM3NODE11"."SIB001PKIX" ON "NEHALEM3NODE11"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE11"."SIB001"

ALTER TABLE "NEHALEM3NODE11"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE11"."SIB001"

CREATE INDEX "NEHALEM3NODE11"."SIB001STREAMIX" ON "NEHALEM3NODE11"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE11"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE11"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM3NODE11"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE11"."SIB002"

CREATE UNIQUE INDEX "NEHALEM3NODE11"."SIB002PKIX" ON "NEHALEM3NODE11"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE11"."SIB002"

ALTER TABLE "NEHALEM3NODE11"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE11"."SIB002"

CREATE INDEX "NEHALEM3NODE11"."SIB002STREAMIX" ON "NEHALEM3NODE11"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE12"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE12"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM3NODE12"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE12"."SIB000"

CREATE UNIQUE INDEX "NEHALEM3NODE12"."SIB000PKIX" ON "NEHALEM3NODE12"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE12"."SIB000"

ALTER TABLE "NEHALEM3NODE12"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE12"."SIB000"

CREATE INDEX "NEHALEM3NODE12"."SIB000STREAMIX" ON "NEHALEM3NODE12"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE12"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE12"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM3NODE12"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE12"."SIB001"

CREATE UNIQUE INDEX "NEHALEM3NODE12"."SIB001PKIX" ON "NEHALEM3NODE12"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE12"."SIB001"

ALTER TABLE "NEHALEM3NODE12"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE12"."SIB001"

CREATE INDEX "NEHALEM3NODE12"."SIB001STREAMIX" ON "NEHALEM3NODE12"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE12"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE12"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM3NODE12"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE12"."SIB002"

CREATE UNIQUE INDEX "NEHALEM3NODE12"."SIB002PKIX" ON "NEHALEM3NODE12"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE12"."SIB002"

ALTER TABLE "NEHALEM3NODE12"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE12"."SIB002"

CREATE INDEX "NEHALEM3NODE12"."SIB002STREAMIX" ON "NEHALEM3NODE12"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE11"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE11"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM4NODE11"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE11"."SIB000"

CREATE UNIQUE INDEX "NEHALEM4NODE11"."SIB000PKIX" ON "NEHALEM4NODE11"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE11"."SIB000"

ALTER TABLE "NEHALEM4NODE11"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE11"."SIB000"

CREATE INDEX "NEHALEM4NODE11"."SIB000STREAMIX" ON "NEHALEM4NODE11"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE11"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE11"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM4NODE11"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE11"."SIB001"

CREATE UNIQUE INDEX "NEHALEM4NODE11"."SIB001PKIX" ON "NEHALEM4NODE11"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE11"."SIB001"

ALTER TABLE "NEHALEM4NODE11"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE11"."SIB001"

CREATE INDEX "NEHALEM4NODE11"."SIB001STREAMIX" ON "NEHALEM4NODE11"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE11"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE11"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM4NODE11"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE11"."SIB002"

CREATE UNIQUE INDEX "NEHALEM4NODE11"."SIB002PKIX" ON "NEHALEM4NODE11"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE11"."SIB002"

ALTER TABLE "NEHALEM4NODE11"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE11"."SIB002"

CREATE INDEX "NEHALEM4NODE11"."SIB002STREAMIX" ON "NEHALEM4NODE11"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE12"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE12"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM4NODE12"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE12"."SIB000"

CREATE UNIQUE INDEX "NEHALEM4NODE12"."SIB000PKIX" ON "NEHALEM4NODE12"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE12"."SIB000"

ALTER TABLE "NEHALEM4NODE12"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE12"."SIB000"

CREATE INDEX "NEHALEM4NODE12"."SIB000STREAMIX" ON "NEHALEM4NODE12"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE12"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE12"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM4NODE12"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE12"."SIB001"

CREATE UNIQUE INDEX "NEHALEM4NODE12"."SIB001PKIX" ON "NEHALEM4NODE12"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE12"."SIB001"

ALTER TABLE "NEHALEM4NODE12"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE12"."SIB001"

CREATE INDEX "NEHALEM4NODE12"."SIB001STREAMIX" ON "NEHALEM4NODE12"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE12"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE12"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM4NODE12"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE12"."SIB002"

CREATE UNIQUE INDEX "NEHALEM4NODE12"."SIB002PKIX" ON "NEHALEM4NODE12"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE12"."SIB002"

ALTER TABLE "NEHALEM4NODE12"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE12"."SIB002"

CREATE INDEX "NEHALEM4NODE12"."SIB002STREAMIX" ON "NEHALEM4NODE12"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE11"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE11"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM5NODE11"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE11"."SIB000"

CREATE UNIQUE INDEX "NEHALEM5NODE11"."SIB000PKIX" ON "NEHALEM5NODE11"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE11"."SIB000"

ALTER TABLE "NEHALEM5NODE11"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE11"."SIB000"

CREATE INDEX "NEHALEM5NODE11"."SIB000STREAMIX" ON "NEHALEM5NODE11"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE11"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE11"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM5NODE11"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE11"."SIB001"

CREATE UNIQUE INDEX "NEHALEM5NODE11"."SIB001PKIX" ON "NEHALEM5NODE11"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE11"."SIB001"

ALTER TABLE "NEHALEM5NODE11"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE11"."SIB001"

CREATE INDEX "NEHALEM5NODE11"."SIB001STREAMIX" ON "NEHALEM5NODE11"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE11"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE11"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM5NODE11"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE11"."SIB002"

CREATE UNIQUE INDEX "NEHALEM5NODE11"."SIB002PKIX" ON "NEHALEM5NODE11"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE11"."SIB002"

ALTER TABLE "NEHALEM5NODE11"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE11"."SIB002"

CREATE INDEX "NEHALEM5NODE11"."SIB002STREAMIX" ON "NEHALEM5NODE11"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE12"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE12"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM5NODE12"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE12"."SIB000"

CREATE UNIQUE INDEX "NEHALEM5NODE12"."SIB000PKIX" ON "NEHALEM5NODE12"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE12"."SIB000"

ALTER TABLE "NEHALEM5NODE12"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE12"."SIB000"

CREATE INDEX "NEHALEM5NODE12"."SIB000STREAMIX" ON "NEHALEM5NODE12"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE12"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE12"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM5NODE12"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE12"."SIB001"

CREATE UNIQUE INDEX "NEHALEM5NODE12"."SIB001PKIX" ON "NEHALEM5NODE12"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE12"."SIB001"

ALTER TABLE "NEHALEM5NODE12"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE12"."SIB001"

CREATE INDEX "NEHALEM5NODE12"."SIB001STREAMIX" ON "NEHALEM5NODE12"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE12"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE12"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM5NODE12"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE12"."SIB002"

CREATE UNIQUE INDEX "NEHALEM5NODE12"."SIB002PKIX" ON "NEHALEM5NODE12"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE12"."SIB002"

ALTER TABLE "NEHALEM5NODE12"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE12"."SIB002"

CREATE INDEX "NEHALEM5NODE12"."SIB002STREAMIX" ON "NEHALEM5NODE12"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE09"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE09"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM7NODE09"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE09"."SIB000"

CREATE UNIQUE INDEX "NEHALEM7NODE09"."SIB000PKIX" ON "NEHALEM7NODE09"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE09"."SIB000"

ALTER TABLE "NEHALEM7NODE09"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE09"."SIB000"

CREATE INDEX "NEHALEM7NODE09"."SIB000STREAMIX" ON "NEHALEM7NODE09"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE09"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE09"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM7NODE09"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE09"."SIB001"

CREATE UNIQUE INDEX "NEHALEM7NODE09"."SIB001PKIX" ON "NEHALEM7NODE09"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE09"."SIB001"

ALTER TABLE "NEHALEM7NODE09"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE09"."SIB001"

CREATE INDEX "NEHALEM7NODE09"."SIB001STREAMIX" ON "NEHALEM7NODE09"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE09"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE09"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM7NODE09"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE09"."SIB002"

CREATE UNIQUE INDEX "NEHALEM7NODE09"."SIB002PKIX" ON "NEHALEM7NODE09"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE09"."SIB002"

ALTER TABLE "NEHALEM7NODE09"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE09"."SIB002"

CREATE INDEX "NEHALEM7NODE09"."SIB002STREAMIX" ON "NEHALEM7NODE09"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE10"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE10"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM7NODE10"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE10"."SIB000"

CREATE UNIQUE INDEX "NEHALEM7NODE10"."SIB000PKIX" ON "NEHALEM7NODE10"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE10"."SIB000"

ALTER TABLE "NEHALEM7NODE10"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE10"."SIB000"

CREATE INDEX "NEHALEM7NODE10"."SIB000STREAMIX" ON "NEHALEM7NODE10"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE10"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE10"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM7NODE10"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE10"."SIB001"

CREATE UNIQUE INDEX "NEHALEM7NODE10"."SIB001PKIX" ON "NEHALEM7NODE10"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE10"."SIB001"

ALTER TABLE "NEHALEM7NODE10"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE10"."SIB001"

CREATE INDEX "NEHALEM7NODE10"."SIB001STREAMIX" ON "NEHALEM7NODE10"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE10"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE10"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM7NODE10"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE10"."SIB002"

CREATE UNIQUE INDEX "NEHALEM7NODE10"."SIB002PKIX" ON "NEHALEM7NODE10"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE10"."SIB002"

ALTER TABLE "NEHALEM7NODE10"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE10"."SIB002"

CREATE INDEX "NEHALEM7NODE10"."SIB002STREAMIX" ON "NEHALEM7NODE10"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE09"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE09"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM8NODE09"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE09"."SIB000"

CREATE UNIQUE INDEX "NEHALEM8NODE09"."SIB000PKIX" ON "NEHALEM8NODE09"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE09"."SIB000"

ALTER TABLE "NEHALEM8NODE09"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE09"."SIB000"

CREATE INDEX "NEHALEM8NODE09"."SIB000STREAMIX" ON "NEHALEM8NODE09"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE09"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE09"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM8NODE09"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE09"."SIB001"

CREATE UNIQUE INDEX "NEHALEM8NODE09"."SIB001PKIX" ON "NEHALEM8NODE09"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE09"."SIB001"

ALTER TABLE "NEHALEM8NODE09"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE09"."SIB001"

CREATE INDEX "NEHALEM8NODE09"."SIB001STREAMIX" ON "NEHALEM8NODE09"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE09"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE09"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM8NODE09"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE09"."SIB002"

CREATE UNIQUE INDEX "NEHALEM8NODE09"."SIB002PKIX" ON "NEHALEM8NODE09"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE09"."SIB002"

ALTER TABLE "NEHALEM8NODE09"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE09"."SIB002"

CREATE INDEX "NEHALEM8NODE09"."SIB002STREAMIX" ON "NEHALEM8NODE09"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE10"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE10"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM8NODE10"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE10"."SIB000"

CREATE UNIQUE INDEX "NEHALEM8NODE10"."SIB000PKIX" ON "NEHALEM8NODE10"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE10"."SIB000"

ALTER TABLE "NEHALEM8NODE10"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE10"."SIB000"

CREATE INDEX "NEHALEM8NODE10"."SIB000STREAMIX" ON "NEHALEM8NODE10"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE10"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE10"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM8NODE10"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE10"."SIB001"

CREATE UNIQUE INDEX "NEHALEM8NODE10"."SIB001PKIX" ON "NEHALEM8NODE10"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE10"."SIB001"

ALTER TABLE "NEHALEM8NODE10"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE10"."SIB001"

CREATE INDEX "NEHALEM8NODE10"."SIB001STREAMIX" ON "NEHALEM8NODE10"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE10"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE10"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM8NODE10"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE10"."SIB002"

CREATE UNIQUE INDEX "NEHALEM8NODE10"."SIB002PKIX" ON "NEHALEM8NODE10"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE10"."SIB002"

ALTER TABLE "NEHALEM8NODE10"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE10"."SIB002"

CREATE INDEX "NEHALEM8NODE10"."SIB002STREAMIX" ON "NEHALEM8NODE10"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE09"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE09"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM9NODE09"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE09"."SIB000"

CREATE UNIQUE INDEX "NEHALEM9NODE09"."SIB000PKIX" ON "NEHALEM9NODE09"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE09"."SIB000"

ALTER TABLE "NEHALEM9NODE09"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE09"."SIB000"

CREATE INDEX "NEHALEM9NODE09"."SIB000STREAMIX" ON "NEHALEM9NODE09"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE09"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE09"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM9NODE09"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE09"."SIB001"

CREATE UNIQUE INDEX "NEHALEM9NODE09"."SIB001PKIX" ON "NEHALEM9NODE09"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE09"."SIB001"

ALTER TABLE "NEHALEM9NODE09"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE09"."SIB001"

CREATE INDEX "NEHALEM9NODE09"."SIB001STREAMIX" ON "NEHALEM9NODE09"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE09"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE09"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM9NODE09"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE09"."SIB002"

CREATE UNIQUE INDEX "NEHALEM9NODE09"."SIB002PKIX" ON "NEHALEM9NODE09"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE09"."SIB002"

ALTER TABLE "NEHALEM9NODE09"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE09"."SIB002"

CREATE INDEX "NEHALEM9NODE09"."SIB002STREAMIX" ON "NEHALEM9NODE09"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE10"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE10"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM9NODE10"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE10"."SIB000"

CREATE UNIQUE INDEX "NEHALEM9NODE10"."SIB000PKIX" ON "NEHALEM9NODE10"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE10"."SIB000"

ALTER TABLE "NEHALEM9NODE10"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE10"."SIB000"

CREATE INDEX "NEHALEM9NODE10"."SIB000STREAMIX" ON "NEHALEM9NODE10"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE10"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE10"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM9NODE10"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE10"."SIB001"

CREATE UNIQUE INDEX "NEHALEM9NODE10"."SIB001PKIX" ON "NEHALEM9NODE10"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE10"."SIB001"

ALTER TABLE "NEHALEM9NODE10"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE10"."SIB001"

CREATE INDEX "NEHALEM9NODE10"."SIB001STREAMIX" ON "NEHALEM9NODE10"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE10"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE10"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" ; 

ALTER TABLE "NEHALEM9NODE10"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE10"."SIB002"

CREATE UNIQUE INDEX "NEHALEM9NODE10"."SIB002PKIX" ON "NEHALEM9NODE10"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE10"."SIB002"

ALTER TABLE "NEHALEM9NODE10"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE10"."SIB002"

CREATE INDEX "NEHALEM9NODE10"."SIB002STREAMIX" ON "NEHALEM9NODE10"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."M_INVENTORY"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."M_INVENTORY"  (
		  "IN_P_ID" CHAR(20) NOT NULL , 
		  "IN_QTY" INTEGER , 
		  "IN_ORDERED" INTEGER , 
		  "IN_LOCATION" INTEGER NOT NULL , 
		  "IN_ACC_CODE" INTEGER , 
		  "IN_ACT_DATE" TIMESTAMP , 
		  "IN_VERSION" INTEGER WITH DEFAULT 0 )   
		 PARTITION BY RANGE("IN_P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ANTIA0001100000') IN "USERSPACE1", 
		 PART "PART1" STARTING('00001ATION0000000000') ENDING('00001BARAA0001100000') IN "USERSPACE1", 
		 PART "PART2" STARTING('00001CALLY0000000000') ENDING('00001EINGA0001100000') IN "USERSPACE1", 
		 PART "PART3" STARTING('00001ESEAA0000000000') ENDING('00001IRESE0001100000') IN "USERSPACE1", 
		 PART "PART4" STARTING('00001LINES0000000000') ENDING('00001MITEM0001100000') IN "USERSPACE1", 
		 PART "PART5" STARTING('00001NAILS0000000000') ENDING('00001OUGHT0001100000') IN "USERSPACE1", 
		 PART "PART6" STARTING('00001PRESA0000000000') ENDING('00001QUIET0001100000') IN "USERSPACE1", 
		 PART "PART7" STARTING('00001SCREW0000000000') ENDING('00001SHARE0001100000') IN "USERSPACE1"); 

ALTER TABLE "DB2INST3"."M_INVENTORY" VOLATILE CARDINALITY;






-- DDL Statements for indexes on Table "DB2INST3"."M_INVENTORY"

CREATE UNIQUE INDEX "DB2INST3"."M_INV_IDX" ON "DB2INST3"."M_INVENTORY" 
		("IN_LOCATION" ASC,
		 "IN_P_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST3"."M_PARTS"
------------------------------------------------
 

CREATE TABLE "DB2INST3"."M_PARTS"  (
		  "P_ID" CHAR(20) NOT NULL , 
		  "P_NAME" CHAR(35) , 
		  "P_DESC" VARCHAR(100) , 
		  "P_REV" CHAR(6) , 
		  "P_PLANNER" INTEGER , 
		  "P_TYPE" INTEGER , 
		  "P_IND" INTEGER , 
		  "P_LOMARK" INTEGER , 
		  "P_HIMARK" INTEGER , 
		  "P_VERSION" INTEGER WITH DEFAULT 0 )   
		 PARTITION BY RANGE("P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ANTIA0001100000') IN "USERSPACE1", 
		 PART "PART1" STARTING('00001ATION0000000000') ENDING('00001BARAA0001100000') IN "USERSPACE1", 
		 PART "PART2" STARTING('00001CALLY0000000000') ENDING('00001EINGA0001100000') IN "USERSPACE1", 
		 PART "PART3" STARTING('00001ESEAA0000000000') ENDING('00001IRESE0001100000') IN "USERSPACE1", 
		 PART "PART4" STARTING('00001LINES0000000000') ENDING('00001MITEM0001100000') IN "USERSPACE1", 
		 PART "PART5" STARTING('00001NAILS0000000000') ENDING('00001OUGHT0001100000') IN "USERSPACE1", 
		 PART "PART6" STARTING('00001PRESA0000000000') ENDING('00001QUIET0001100000') IN "USERSPACE1", 
		 PART "PART7" STARTING('00001SCREW0000000000') ENDING('00001SHARE0001100000') IN "USERSPACE1"); 

ALTER TABLE "DB2INST3"."M_PARTS" VOLATILE CARDINALITY;






-- DDL Statements for indexes on Table "DB2INST3"."M_PARTS"

CREATE UNIQUE INDEX "DB2INST3"."M_PARTS_IDX" ON "DB2INST3"."M_PARTS" 
		("P_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE20"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE20"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE19"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE19"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE20"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE20"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE19"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE19"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE19"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE19"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM1NODE19"."SIBCLASSMAP"

ALTER TABLE "NEHALEM1NODE19"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE20"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE20"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM1NODE20"."SIBCLASSMAP"

ALTER TABLE "NEHALEM1NODE20"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE19"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE19"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM1NODE19"."SIBLISTING"

ALTER TABLE "NEHALEM1NODE19"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE20"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE20"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM1NODE20"."SIBLISTING"

ALTER TABLE "NEHALEM1NODE20"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE19"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE19"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM1NODE19"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE19"."SIB000"

CREATE UNIQUE INDEX "NEHALEM1NODE19"."SIB000PKIX" ON "NEHALEM1NODE19"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE19"."SIB000"

ALTER TABLE "NEHALEM1NODE19"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE19"."SIB000"

CREATE INDEX "NEHALEM1NODE19"."SIB000STREAMIX" ON "NEHALEM1NODE19"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE20"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE20"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM1NODE20"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE20"."SIB000"

CREATE UNIQUE INDEX "NEHALEM1NODE20"."SIB000PKIX" ON "NEHALEM1NODE20"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE20"."SIB000"

ALTER TABLE "NEHALEM1NODE20"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE20"."SIB000"

CREATE INDEX "NEHALEM1NODE20"."SIB000STREAMIX" ON "NEHALEM1NODE20"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE19"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE19"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM1NODE19"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE19"."SIB001"

CREATE UNIQUE INDEX "NEHALEM1NODE19"."SIB001PKIX" ON "NEHALEM1NODE19"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE19"."SIB001"

ALTER TABLE "NEHALEM1NODE19"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE19"."SIB001"

CREATE INDEX "NEHALEM1NODE19"."SIB001STREAMIX" ON "NEHALEM1NODE19"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE20"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE20"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM1NODE20"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE20"."SIB001"

CREATE UNIQUE INDEX "NEHALEM1NODE20"."SIB001PKIX" ON "NEHALEM1NODE20"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE20"."SIB001"

ALTER TABLE "NEHALEM1NODE20"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE20"."SIB001"

CREATE INDEX "NEHALEM1NODE20"."SIB001STREAMIX" ON "NEHALEM1NODE20"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE19"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE19"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM1NODE19"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE19"."SIB002"

CREATE UNIQUE INDEX "NEHALEM1NODE19"."SIB002PKIX" ON "NEHALEM1NODE19"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE19"."SIB002"

ALTER TABLE "NEHALEM1NODE19"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE19"."SIB002"

CREATE INDEX "NEHALEM1NODE19"."SIB002STREAMIX" ON "NEHALEM1NODE19"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE20"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE20"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM1NODE20"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM1NODE20"."SIB002"

CREATE UNIQUE INDEX "NEHALEM1NODE20"."SIB002PKIX" ON "NEHALEM1NODE20"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM1NODE20"."SIB002"

ALTER TABLE "NEHALEM1NODE20"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM1NODE20"."SIB002"

CREATE INDEX "NEHALEM1NODE20"."SIB002STREAMIX" ON "NEHALEM1NODE20"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE19"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE19"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM1NODE19"."SIBKEYS"

ALTER TABLE "NEHALEM1NODE19"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE20"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE20"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM1NODE20"."SIBKEYS"

ALTER TABLE "NEHALEM1NODE20"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE19"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE19"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM1NODE19"."SIBXACTS"

ALTER TABLE "NEHALEM1NODE19"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM1NODE20"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM1NODE20"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM1NODE20"."SIBXACTS"

ALTER TABLE "NEHALEM1NODE20"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE14"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE14"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE13"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE13"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE14"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE14"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE13"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE13"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE14"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE14"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM8NODE14"."SIBCLASSMAP"

ALTER TABLE "NEHALEM8NODE14"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE13"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE13"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM8NODE13"."SIBCLASSMAP"

ALTER TABLE "NEHALEM8NODE13"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE14"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE14"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM8NODE14"."SIBLISTING"

ALTER TABLE "NEHALEM8NODE14"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE13"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE13"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM8NODE13"."SIBLISTING"

ALTER TABLE "NEHALEM8NODE13"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE13"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE13"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM8NODE13"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE13"."SIB000"

CREATE UNIQUE INDEX "NEHALEM8NODE13"."SIB000PKIX" ON "NEHALEM8NODE13"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE13"."SIB000"

ALTER TABLE "NEHALEM8NODE13"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE13"."SIB000"

CREATE INDEX "NEHALEM8NODE13"."SIB000STREAMIX" ON "NEHALEM8NODE13"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE14"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE14"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM8NODE14"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE14"."SIB000"

CREATE UNIQUE INDEX "NEHALEM8NODE14"."SIB000PKIX" ON "NEHALEM8NODE14"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE14"."SIB000"

ALTER TABLE "NEHALEM8NODE14"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE14"."SIB000"

CREATE INDEX "NEHALEM8NODE14"."SIB000STREAMIX" ON "NEHALEM8NODE14"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE13"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE13"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM8NODE13"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE13"."SIB001"

CREATE UNIQUE INDEX "NEHALEM8NODE13"."SIB001PKIX" ON "NEHALEM8NODE13"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE13"."SIB001"

ALTER TABLE "NEHALEM8NODE13"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE13"."SIB001"

CREATE INDEX "NEHALEM8NODE13"."SIB001STREAMIX" ON "NEHALEM8NODE13"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE14"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE14"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM8NODE14"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE14"."SIB001"

CREATE UNIQUE INDEX "NEHALEM8NODE14"."SIB001PKIX" ON "NEHALEM8NODE14"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE14"."SIB001"

ALTER TABLE "NEHALEM8NODE14"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE14"."SIB001"

CREATE INDEX "NEHALEM8NODE14"."SIB001STREAMIX" ON "NEHALEM8NODE14"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE13"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE13"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM8NODE13"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE13"."SIB002"

CREATE UNIQUE INDEX "NEHALEM8NODE13"."SIB002PKIX" ON "NEHALEM8NODE13"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE13"."SIB002"

ALTER TABLE "NEHALEM8NODE13"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE13"."SIB002"

CREATE INDEX "NEHALEM8NODE13"."SIB002STREAMIX" ON "NEHALEM8NODE13"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE14"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE14"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM8NODE14"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM8NODE14"."SIB002"

CREATE UNIQUE INDEX "NEHALEM8NODE14"."SIB002PKIX" ON "NEHALEM8NODE14"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM8NODE14"."SIB002"

ALTER TABLE "NEHALEM8NODE14"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM8NODE14"."SIB002"

CREATE INDEX "NEHALEM8NODE14"."SIB002STREAMIX" ON "NEHALEM8NODE14"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE13"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE13"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM8NODE13"."SIBKEYS"

ALTER TABLE "NEHALEM8NODE13"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE14"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE14"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM8NODE14"."SIBKEYS"

ALTER TABLE "NEHALEM8NODE14"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE13"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE13"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM8NODE13"."SIBXACTS"

ALTER TABLE "NEHALEM8NODE13"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM8NODE14"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM8NODE14"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM8NODE14"."SIBXACTS"

ALTER TABLE "NEHALEM8NODE14"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE13"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE13"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE14"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE14"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE13"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE13"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE14"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE14"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE15"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE15"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE16"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE16"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE13"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE13"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM7NODE13"."SIBCLASSMAP"

ALTER TABLE "NEHALEM7NODE13"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE14"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE14"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM7NODE14"."SIBCLASSMAP"

ALTER TABLE "NEHALEM7NODE14"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE16"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE16"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE15"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE15"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE14"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE14"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM7NODE14"."SIBLISTING"

ALTER TABLE "NEHALEM7NODE14"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE13"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE13"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM7NODE13"."SIBLISTING"

ALTER TABLE "NEHALEM7NODE13"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE16"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE16"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM2NODE16"."SIBCLASSMAP"

ALTER TABLE "NEHALEM2NODE16"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE15"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE15"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM2NODE15"."SIBCLASSMAP"

ALTER TABLE "NEHALEM2NODE15"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE14"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE14"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM7NODE14"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE14"."SIB000"

CREATE UNIQUE INDEX "NEHALEM7NODE14"."SIB000PKIX" ON "NEHALEM7NODE14"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE14"."SIB000"

ALTER TABLE "NEHALEM7NODE14"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE14"."SIB000"

CREATE INDEX "NEHALEM7NODE14"."SIB000STREAMIX" ON "NEHALEM7NODE14"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE13"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE13"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM7NODE13"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE13"."SIB000"

CREATE UNIQUE INDEX "NEHALEM7NODE13"."SIB000PKIX" ON "NEHALEM7NODE13"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE13"."SIB000"

ALTER TABLE "NEHALEM7NODE13"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE13"."SIB000"

CREATE INDEX "NEHALEM7NODE13"."SIB000STREAMIX" ON "NEHALEM7NODE13"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE16"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE16"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM2NODE16"."SIBLISTING"

ALTER TABLE "NEHALEM2NODE16"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE15"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE15"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM2NODE15"."SIBLISTING"

ALTER TABLE "NEHALEM2NODE15"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE14"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE14"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM7NODE14"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE14"."SIB001"

CREATE UNIQUE INDEX "NEHALEM7NODE14"."SIB001PKIX" ON "NEHALEM7NODE14"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE14"."SIB001"

ALTER TABLE "NEHALEM7NODE14"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE14"."SIB001"

CREATE INDEX "NEHALEM7NODE14"."SIB001STREAMIX" ON "NEHALEM7NODE14"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE15"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE15"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM2NODE15"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE15"."SIB000"

CREATE UNIQUE INDEX "NEHALEM2NODE15"."SIB000PKIX" ON "NEHALEM2NODE15"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE15"."SIB000"

ALTER TABLE "NEHALEM2NODE15"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE15"."SIB000"

CREATE INDEX "NEHALEM2NODE15"."SIB000STREAMIX" ON "NEHALEM2NODE15"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE16"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE16"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM2NODE16"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE16"."SIB000"

CREATE UNIQUE INDEX "NEHALEM2NODE16"."SIB000PKIX" ON "NEHALEM2NODE16"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE16"."SIB000"

ALTER TABLE "NEHALEM2NODE16"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE16"."SIB000"

CREATE INDEX "NEHALEM2NODE16"."SIB000STREAMIX" ON "NEHALEM2NODE16"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE13"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE13"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM7NODE13"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE13"."SIB001"

CREATE UNIQUE INDEX "NEHALEM7NODE13"."SIB001PKIX" ON "NEHALEM7NODE13"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE13"."SIB001"

ALTER TABLE "NEHALEM7NODE13"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE13"."SIB001"

CREATE INDEX "NEHALEM7NODE13"."SIB001STREAMIX" ON "NEHALEM7NODE13"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE14"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE14"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM7NODE14"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE14"."SIB002"

CREATE UNIQUE INDEX "NEHALEM7NODE14"."SIB002PKIX" ON "NEHALEM7NODE14"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE14"."SIB002"

ALTER TABLE "NEHALEM7NODE14"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE14"."SIB002"

CREATE INDEX "NEHALEM7NODE14"."SIB002STREAMIX" ON "NEHALEM7NODE14"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE15"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE15"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM2NODE15"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE15"."SIB001"

CREATE UNIQUE INDEX "NEHALEM2NODE15"."SIB001PKIX" ON "NEHALEM2NODE15"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE15"."SIB001"

ALTER TABLE "NEHALEM2NODE15"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE15"."SIB001"

CREATE INDEX "NEHALEM2NODE15"."SIB001STREAMIX" ON "NEHALEM2NODE15"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE13"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE13"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM7NODE13"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM7NODE13"."SIB002"

CREATE UNIQUE INDEX "NEHALEM7NODE13"."SIB002PKIX" ON "NEHALEM7NODE13"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM7NODE13"."SIB002"

ALTER TABLE "NEHALEM7NODE13"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM7NODE13"."SIB002"

CREATE INDEX "NEHALEM7NODE13"."SIB002STREAMIX" ON "NEHALEM7NODE13"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE16"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE16"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM2NODE16"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE16"."SIB001"

CREATE UNIQUE INDEX "NEHALEM2NODE16"."SIB001PKIX" ON "NEHALEM2NODE16"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE16"."SIB001"

ALTER TABLE "NEHALEM2NODE16"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE16"."SIB001"

CREATE INDEX "NEHALEM2NODE16"."SIB001STREAMIX" ON "NEHALEM2NODE16"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE14"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE14"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM7NODE14"."SIBKEYS"

ALTER TABLE "NEHALEM7NODE14"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE15"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE15"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM2NODE15"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE15"."SIB002"

CREATE UNIQUE INDEX "NEHALEM2NODE15"."SIB002PKIX" ON "NEHALEM2NODE15"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE15"."SIB002"

ALTER TABLE "NEHALEM2NODE15"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE15"."SIB002"

CREATE INDEX "NEHALEM2NODE15"."SIB002STREAMIX" ON "NEHALEM2NODE15"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE13"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE13"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM7NODE13"."SIBKEYS"

ALTER TABLE "NEHALEM7NODE13"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE16"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE16"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM2NODE16"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM2NODE16"."SIB002"

CREATE UNIQUE INDEX "NEHALEM2NODE16"."SIB002PKIX" ON "NEHALEM2NODE16"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM2NODE16"."SIB002"

ALTER TABLE "NEHALEM2NODE16"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM2NODE16"."SIB002"

CREATE INDEX "NEHALEM2NODE16"."SIB002STREAMIX" ON "NEHALEM2NODE16"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE14"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE14"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM7NODE14"."SIBXACTS"

ALTER TABLE "NEHALEM7NODE14"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM7NODE13"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM7NODE13"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM7NODE13"."SIBXACTS"

ALTER TABLE "NEHALEM7NODE13"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE15"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE15"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM2NODE15"."SIBKEYS"

ALTER TABLE "NEHALEM2NODE15"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE15"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE15"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM2NODE15"."SIBXACTS"

ALTER TABLE "NEHALEM2NODE15"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE16"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE16"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM2NODE16"."SIBKEYS"

ALTER TABLE "NEHALEM2NODE16"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM2NODE16"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM2NODE16"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM2NODE16"."SIBXACTS"

ALTER TABLE "NEHALEM2NODE16"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE15"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE15"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE16"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE16"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE15"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE15"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE16"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE16"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE15"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE15"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM3NODE15"."SIBCLASSMAP"

ALTER TABLE "NEHALEM3NODE15"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE16"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE16"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM3NODE16"."SIBCLASSMAP"

ALTER TABLE "NEHALEM3NODE16"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE16"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE16"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM3NODE16"."SIBLISTING"

ALTER TABLE "NEHALEM3NODE16"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE15"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE15"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM3NODE15"."SIBLISTING"

ALTER TABLE "NEHALEM3NODE15"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE16"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE16"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM3NODE16"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE16"."SIB000"

CREATE UNIQUE INDEX "NEHALEM3NODE16"."SIB000PKIX" ON "NEHALEM3NODE16"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE16"."SIB000"

ALTER TABLE "NEHALEM3NODE16"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE16"."SIB000"

CREATE INDEX "NEHALEM3NODE16"."SIB000STREAMIX" ON "NEHALEM3NODE16"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE15"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE15"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM3NODE15"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE15"."SIB000"

CREATE UNIQUE INDEX "NEHALEM3NODE15"."SIB000PKIX" ON "NEHALEM3NODE15"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE15"."SIB000"

ALTER TABLE "NEHALEM3NODE15"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE15"."SIB000"

CREATE INDEX "NEHALEM3NODE15"."SIB000STREAMIX" ON "NEHALEM3NODE15"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE16"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE16"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM3NODE16"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE16"."SIB001"

CREATE UNIQUE INDEX "NEHALEM3NODE16"."SIB001PKIX" ON "NEHALEM3NODE16"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE16"."SIB001"

ALTER TABLE "NEHALEM3NODE16"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE16"."SIB001"

CREATE INDEX "NEHALEM3NODE16"."SIB001STREAMIX" ON "NEHALEM3NODE16"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE15"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE15"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM3NODE15"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE15"."SIB001"

CREATE UNIQUE INDEX "NEHALEM3NODE15"."SIB001PKIX" ON "NEHALEM3NODE15"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE15"."SIB001"

ALTER TABLE "NEHALEM3NODE15"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE15"."SIB001"

CREATE INDEX "NEHALEM3NODE15"."SIB001STREAMIX" ON "NEHALEM3NODE15"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE16"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE16"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM3NODE16"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE16"."SIB002"

CREATE UNIQUE INDEX "NEHALEM3NODE16"."SIB002PKIX" ON "NEHALEM3NODE16"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE16"."SIB002"

ALTER TABLE "NEHALEM3NODE16"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE16"."SIB002"

CREATE INDEX "NEHALEM3NODE16"."SIB002STREAMIX" ON "NEHALEM3NODE16"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE15"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE15"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM3NODE15"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM3NODE15"."SIB002"

CREATE UNIQUE INDEX "NEHALEM3NODE15"."SIB002PKIX" ON "NEHALEM3NODE15"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM3NODE15"."SIB002"

ALTER TABLE "NEHALEM3NODE15"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM3NODE15"."SIB002"

CREATE INDEX "NEHALEM3NODE15"."SIB002STREAMIX" ON "NEHALEM3NODE15"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE16"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE16"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM3NODE16"."SIBKEYS"

ALTER TABLE "NEHALEM3NODE16"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE15"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE15"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM3NODE15"."SIBKEYS"

ALTER TABLE "NEHALEM3NODE15"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE16"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE16"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM3NODE16"."SIBXACTS"

ALTER TABLE "NEHALEM3NODE16"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM3NODE15"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM3NODE15"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM3NODE15"."SIBXACTS"

ALTER TABLE "NEHALEM3NODE15"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE17"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE17"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE16"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE16"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE16"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE16"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE17"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE17"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE15"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE15"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE16"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE16"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE17"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE17"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM4NODE17"."SIBCLASSMAP"

ALTER TABLE "NEHALEM4NODE17"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE16"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE16"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM4NODE16"."SIBCLASSMAP"

ALTER TABLE "NEHALEM4NODE16"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE15"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE15"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE16"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE16"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE16"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE16"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM4NODE16"."SIBLISTING"

ALTER TABLE "NEHALEM4NODE16"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE17"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE17"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM4NODE17"."SIBLISTING"

ALTER TABLE "NEHALEM4NODE17"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE16"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE16"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM4NODE16"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE16"."SIB000"

CREATE UNIQUE INDEX "NEHALEM4NODE16"."SIB000PKIX" ON "NEHALEM4NODE16"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE16"."SIB000"

ALTER TABLE "NEHALEM4NODE16"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE16"."SIB000"

CREATE INDEX "NEHALEM4NODE16"."SIB000STREAMIX" ON "NEHALEM4NODE16"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE17"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE17"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM4NODE17"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE17"."SIB000"

CREATE UNIQUE INDEX "NEHALEM4NODE17"."SIB000PKIX" ON "NEHALEM4NODE17"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE17"."SIB000"

ALTER TABLE "NEHALEM4NODE17"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE17"."SIB000"

CREATE INDEX "NEHALEM4NODE17"."SIB000STREAMIX" ON "NEHALEM4NODE17"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE16"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE16"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM5NODE16"."SIBCLASSMAP"

ALTER TABLE "NEHALEM5NODE16"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE15"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE15"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM5NODE15"."SIBCLASSMAP"

ALTER TABLE "NEHALEM5NODE15"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE16"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE16"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM5NODE16"."SIBLISTING"

ALTER TABLE "NEHALEM5NODE16"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE15"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE15"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM5NODE15"."SIBLISTING"

ALTER TABLE "NEHALEM5NODE15"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE16"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE16"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM4NODE16"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE16"."SIB001"

CREATE UNIQUE INDEX "NEHALEM4NODE16"."SIB001PKIX" ON "NEHALEM4NODE16"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE16"."SIB001"

ALTER TABLE "NEHALEM4NODE16"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE16"."SIB001"

CREATE INDEX "NEHALEM4NODE16"."SIB001STREAMIX" ON "NEHALEM4NODE16"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE17"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE17"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM4NODE17"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE17"."SIB001"

CREATE UNIQUE INDEX "NEHALEM4NODE17"."SIB001PKIX" ON "NEHALEM4NODE17"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE17"."SIB001"

ALTER TABLE "NEHALEM4NODE17"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE17"."SIB001"

CREATE INDEX "NEHALEM4NODE17"."SIB001STREAMIX" ON "NEHALEM4NODE17"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE16"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE16"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM5NODE16"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE16"."SIB000"

CREATE UNIQUE INDEX "NEHALEM5NODE16"."SIB000PKIX" ON "NEHALEM5NODE16"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE16"."SIB000"

ALTER TABLE "NEHALEM5NODE16"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE16"."SIB000"

CREATE INDEX "NEHALEM5NODE16"."SIB000STREAMIX" ON "NEHALEM5NODE16"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE15"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE15"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM5NODE15"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE15"."SIB000"

CREATE UNIQUE INDEX "NEHALEM5NODE15"."SIB000PKIX" ON "NEHALEM5NODE15"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE15"."SIB000"

ALTER TABLE "NEHALEM5NODE15"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE15"."SIB000"

CREATE INDEX "NEHALEM5NODE15"."SIB000STREAMIX" ON "NEHALEM5NODE15"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE16"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE16"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM4NODE16"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE16"."SIB002"

CREATE UNIQUE INDEX "NEHALEM4NODE16"."SIB002PKIX" ON "NEHALEM4NODE16"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE16"."SIB002"

ALTER TABLE "NEHALEM4NODE16"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE16"."SIB002"

CREATE INDEX "NEHALEM4NODE16"."SIB002STREAMIX" ON "NEHALEM4NODE16"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE17"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE17"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM4NODE17"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM4NODE17"."SIB002"

CREATE UNIQUE INDEX "NEHALEM4NODE17"."SIB002PKIX" ON "NEHALEM4NODE17"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM4NODE17"."SIB002"

ALTER TABLE "NEHALEM4NODE17"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM4NODE17"."SIB002"

CREATE INDEX "NEHALEM4NODE17"."SIB002STREAMIX" ON "NEHALEM4NODE17"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE16"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE16"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM5NODE16"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE16"."SIB001"

CREATE UNIQUE INDEX "NEHALEM5NODE16"."SIB001PKIX" ON "NEHALEM5NODE16"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE16"."SIB001"

ALTER TABLE "NEHALEM5NODE16"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE16"."SIB001"

CREATE INDEX "NEHALEM5NODE16"."SIB001STREAMIX" ON "NEHALEM5NODE16"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE15"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE15"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM5NODE15"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE15"."SIB001"

CREATE UNIQUE INDEX "NEHALEM5NODE15"."SIB001PKIX" ON "NEHALEM5NODE15"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE15"."SIB001"

ALTER TABLE "NEHALEM5NODE15"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE15"."SIB001"

CREATE INDEX "NEHALEM5NODE15"."SIB001STREAMIX" ON "NEHALEM5NODE15"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE16"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE16"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM4NODE16"."SIBKEYS"

ALTER TABLE "NEHALEM4NODE16"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE17"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE17"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM4NODE17"."SIBKEYS"

ALTER TABLE "NEHALEM4NODE17"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE14"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE14"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE13"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE13"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE16"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE16"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM4NODE16"."SIBXACTS"

ALTER TABLE "NEHALEM4NODE16"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE16"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE16"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM5NODE16"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE16"."SIB002"

CREATE UNIQUE INDEX "NEHALEM5NODE16"."SIB002PKIX" ON "NEHALEM5NODE16"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE16"."SIB002"

ALTER TABLE "NEHALEM5NODE16"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE16"."SIB002"

CREATE INDEX "NEHALEM5NODE16"."SIB002STREAMIX" ON "NEHALEM5NODE16"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE15"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE15"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM5NODE15"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM5NODE15"."SIB002"

CREATE UNIQUE INDEX "NEHALEM5NODE15"."SIB002PKIX" ON "NEHALEM5NODE15"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM5NODE15"."SIB002"

ALTER TABLE "NEHALEM5NODE15"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM5NODE15"."SIB002"

CREATE INDEX "NEHALEM5NODE15"."SIB002STREAMIX" ON "NEHALEM5NODE15"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE14"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE14"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE13"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE13"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "NEHALEM4NODE17"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM4NODE17"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM4NODE17"."SIBXACTS"

ALTER TABLE "NEHALEM4NODE17"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE14"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE14"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM9NODE14"."SIBCLASSMAP"

ALTER TABLE "NEHALEM9NODE14"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE16"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE16"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM5NODE16"."SIBKEYS"

ALTER TABLE "NEHALEM5NODE16"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE13"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE13"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM9NODE13"."SIBCLASSMAP"

ALTER TABLE "NEHALEM9NODE13"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE14"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE14"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM9NODE14"."SIBLISTING"

ALTER TABLE "NEHALEM9NODE14"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE15"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE15"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM5NODE15"."SIBKEYS"

ALTER TABLE "NEHALEM5NODE15"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE13"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE13"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM9NODE13"."SIBLISTING"

ALTER TABLE "NEHALEM9NODE13"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE14"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE14"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM9NODE14"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE14"."SIB000"

CREATE UNIQUE INDEX "NEHALEM9NODE14"."SIB000PKIX" ON "NEHALEM9NODE14"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE14"."SIB000"

ALTER TABLE "NEHALEM9NODE14"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE14"."SIB000"

CREATE INDEX "NEHALEM9NODE14"."SIB000STREAMIX" ON "NEHALEM9NODE14"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE16"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE16"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM5NODE16"."SIBXACTS"

ALTER TABLE "NEHALEM5NODE16"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE13"."SIB000"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE13"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM9NODE13"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE13"."SIB000"

CREATE UNIQUE INDEX "NEHALEM9NODE13"."SIB000PKIX" ON "NEHALEM9NODE13"."SIB000" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE13"."SIB000"

ALTER TABLE "NEHALEM9NODE13"."SIB000" 
	ADD CONSTRAINT "SIB000PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE13"."SIB000"

CREATE INDEX "NEHALEM9NODE13"."SIB000STREAMIX" ON "NEHALEM9NODE13"."SIB000" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM5NODE15"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM5NODE15"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM5NODE15"."SIBXACTS"

ALTER TABLE "NEHALEM5NODE15"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE14"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE14"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM9NODE14"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE14"."SIB001"

CREATE UNIQUE INDEX "NEHALEM9NODE14"."SIB001PKIX" ON "NEHALEM9NODE14"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE14"."SIB001"

ALTER TABLE "NEHALEM9NODE14"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE14"."SIB001"

CREATE INDEX "NEHALEM9NODE14"."SIB001STREAMIX" ON "NEHALEM9NODE14"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE13"."SIB001"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE13"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM9NODE13"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE13"."SIB001"

CREATE UNIQUE INDEX "NEHALEM9NODE13"."SIB001PKIX" ON "NEHALEM9NODE13"."SIB001" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE13"."SIB001"

ALTER TABLE "NEHALEM9NODE13"."SIB001" 
	ADD CONSTRAINT "SIB001PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE13"."SIB001"

CREATE INDEX "NEHALEM9NODE13"."SIB001STREAMIX" ON "NEHALEM9NODE13"."SIB001" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE14"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE14"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM9NODE14"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE14"."SIB002"

CREATE UNIQUE INDEX "NEHALEM9NODE14"."SIB002PKIX" ON "NEHALEM9NODE14"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE14"."SIB002"

ALTER TABLE "NEHALEM9NODE14"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE14"."SIB002"

CREATE INDEX "NEHALEM9NODE14"."SIB002STREAMIX" ON "NEHALEM9NODE14"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE13"."SIB002"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE13"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(3360) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "USERSPACE1" ; 

ALTER TABLE "NEHALEM9NODE13"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for indexes on Table "NEHALEM9NODE13"."SIB002"

CREATE UNIQUE INDEX "NEHALEM9NODE13"."SIB002PKIX" ON "NEHALEM9NODE13"."SIB002" 
		("ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
-- DDL Statements for primary key on Table "NEHALEM9NODE13"."SIB002"

ALTER TABLE "NEHALEM9NODE13"."SIB002" 
	ADD CONSTRAINT "SIB002PKIX" PRIMARY KEY
		("ID");




-- DDL Statements for indexes on Table "NEHALEM9NODE13"."SIB002"

CREATE INDEX "NEHALEM9NODE13"."SIB002STREAMIX" ON "NEHALEM9NODE13"."SIB002" 
		("STREAM_ID" ASC,
		 "SEQUENCE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE14"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE14"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM9NODE14"."SIBKEYS"

ALTER TABLE "NEHALEM9NODE14"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE13"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE13"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM9NODE13"."SIBKEYS"

ALTER TABLE "NEHALEM9NODE13"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE14"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE14"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM9NODE14"."SIBXACTS"

ALTER TABLE "NEHALEM9NODE14"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "NEHALEM9NODE13"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "NEHALEM9NODE13"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" ; 


-- DDL Statements for primary key on Table "NEHALEM9NODE13"."SIBXACTS"

ALTER TABLE "NEHALEM9NODE13"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");









COMMIT WORK;

CONNECT RESET;

TERMINATE;

