#!/bin/sh
#
ORACLE_SID=specdb
DB_DIR=/specdb
LLR_TS=$DB_DIR/llr_ts

sqlplus "/as sysdba" << !
CREATE TABLESPACE LLR_TS
       DATAFILE '$LLR_TS' SIZE 1G REUSE
       EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;
!

for x in 11 12 13 14 15 16 17 18
do
sqlplus "spec/spec" << EOT
alter table WL_LLR_MT_${x} enable table lock;
drop table WL_LLR_MT_${x} ;
CREATE TABLE WL_LLR_MT_${x}
    (
    XIDSTR  VARCHAR2(40) not null,
    POOLNAMESTR VARCHAR2(64),
    RECORDSTR VARCHAR2(1000)
    )
    PARTITION BY HASH (XIDSTR)
    PARTITIONS 43
    STORE IN (LLR_TS)
    initrans 30 pctfree 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

CREATE UNIQUE INDEX WL_LLR_MT_${x}_idx ON WL_LLR_MT_${x} (xidstr) LOCAL
    STORE IN (LLR_TS)
    INITRANS 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

alter table WL_LLR_MT_${x} disable table lock;
EOT
done

