#!/bin/ksh
dd if=/dev/zero of=/dev/rloglv bs=4096k count=21
#############################################
# REGISTRY VARIABLE TUNING                  #
#############################################
db2set DB2_COLLECT_TS_REC_INFO=FALSE
db2set DB2_LARGE_PAGE_MEM=DB
db2set DB2_APM_PERFORMANCE=ON
db2set DB2_KEEPTABLELOCK=CONNECTION
db2set DB2_MINIMIZE_LISTPREFETCH=YES
db2set DB2_USE_ALTERNATE_PAGE_CLEANING=ON
db2set DB2_RESOURCE_POLICY=/specdata8/db2inst1/scripts/ir20k/affinity.cfg
#############################################
# DATABASE MANAGER CONFIGURATION TUNING     #
#############################################
db2 -v update dbm cfg using DIAGLEVEL 3
db2 -v update dbm cfg using DFT_MON_BUFPOOL on DFT_MON_LOCK off DFT_MON_SORT off DFT_MON_STMT off DFT_MON_TIMESTAMP on DFT_MON_UOW off DFT_MON_TABLE off
db2 -v update dbm cfg using CPUSPEED -1
db2 -v update dbm cfg using MAX_COORDAGENTS 4800 automatic
db2 -v update dbm cfg using HEALTH_MON off
db2 -v connect to specdb
############################################
# DATABASE CONFIGURATION TUNING            #
############################################
db2 -v update db cfg for specdb using LOGBUFSZ 4096
db2 -v update db cfg for specdb using LOGPRIMARY 150
db2 -v update db cfg for specdb using SOFTMAX 3000
db2 -v update db cfg for specdb using CHNGPGS_THRESH 99
db2 -v update db cfg for specdb using LOGFILSIZ 65535
db2 -v update db cfg for specdb using LOGSECOND 0
db2 -v update db cfg for specdb using NEWLOGPATH /dev/rloglv
db2 -v update db cfg for specdb using AUTO_MAINT off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
db2 -v update db cfg for specdb using NUM_IOCLEANERS 32
db2 -v update db cfg for specdb using MAXLOCKS 100 LOCKLIST 100000
db2 -v update db cfg for specdb using MINCOMMIT 1
db2 -v update db cfg for specdb using MON_REQ_METRICS none
db2 -v update db cfg for specdb using MON_ACT_METRICS none
db2 -v update db cfg for specdb using MON_OBJ_METRICS none
db2 -v update db cfg for specdb using AUTO_STMT_STATS off
db2stop force
db2start
db2 -v connect to specdb
############################################
# BUFFER POOL TUNING                       #
############################################
db2 -v alter bufferpool IBMDEFAULTBP immediate size 30000000
db2stop force
db2start
db2 -v connect to specdb
db2 -v alter bufferpool SPEC_BP immediate size 35214400
db2stop force
db2start
db2 -v connect to specdb
db2 -v alter bufferpool JMS_BP immediate size 5000
db2stop force
db2start
db2 -v connect to specdb
############################################
# TABLE TUNING                             #
############################################
db2 -v alter table O_ORDERLINE append on
db2 -v alter table O_CUSTINVENTORY append on
db2 -v alter table O_ORDERS append on
db2 -v alter table S_PURCH_ORDER append on
db2 -v alter table S_PURCH_ORDERLINE append on
db2 -v alter table M_WORKORDER append on
db2 -v alter table M_WORKORDER volatile
db2 -v alter table O_ITEM volatile
db2 -v alter table M_PARTS volatile
db2 -v alter table M_INVENTORY volatile
db2 -v terminate
db2set DB2COMM=TCPIP
db2stop force
db2start

