#!/bin/bash

# IBM DB2 Database/Table Load Script for SPECjAppServer2004
# The script will load flatfiles generated by the loader program 
# using the option -doFlatFiles
#
# Adrian Chan
#
# Usage: db2load.sh <root of where the flatfiles are stored> <injection Rate> <number of threads used to generate those files>
# Example:
#
# db2load.sh /home/userA/SPECjAppServer 50 3
#
# this means the flatfiles are located under
#
# /home/userA/SPECjAppServer/datafiles/Ir_50
#
# where the data files are of Ir 50
#
# and the loader options use to generate these files are
#
# ./loaddb.sh 50 3 -doFlatFiles
#
#####################################################################################
#
# Tables are all the tables in SPECj2004
#####################################################################################

tables=( c_customer c_customerinventory c_parts c_site c_supplier m_bom m_inventory m_parts m_workorder o_item o_orderline o_orders s_component s_purchase_order s_purchase_orderline s_site s_supp_component s_supplier u_sequences)

#####################################################################################
# Prefix is the trailing format of the flatfiles
#####################################################################################

prefix='_000'


#####################################################################################
#
# connect to database
#
#####################################################################################

db2 -v connect to specj04

#####################################################################################
#
# for each table, for each thread used to generate the files, load each of the files
# one by one where the delimiter is '|'
#
# Warning: before loading, make sure the tables are empty! The script will not clean
#          out any of the existing data
#
#####################################################################################
echo "Prefix is $prefix"

for table in ${tables[*]}
do
	echo "deleteing from $table"
	db2 "delete from $table"
	x=0
	while [ $x -lt $3 ]
	do
		echo "Loading ${table}"		
		db2 "load from $1/datafiles/Ir_$2/$table/$table$prefix$x of del modified by coldel| insert into $table nonrecoverable"		
		x=$((x+1))
	done
done
echo "Done"
exit
