##########################################################################
# IBM DB2 Database/Table Load Script for SPECjAppServer2004
# This script will load flatfiles generated by the loader program (loaddb.sh) 
# using the option -doFlatFiles.  
# 
# Author: Adrian Chan
# Modified by: Meng Fu
#
# Usage: db2loadxa.sh <root_of_where_the_flatfiles_are_stored> <database_name> 
# 		<injection_rate> <number_of_threads_used_to_generate_those_files>
#
# Example:
#
# db2loadxa.sh /home/userA/SPECjAppServer/flat specdb 50 3
#
# This means the flatfiles are located under:
#
# /home/userA/SPECjAppServer/flat/datafiles/Ir_50
#
# Where the data files are of Ir 50
#
# And the loader options use to generate these files are
#
# ./loaddb.sh 50 3 -doFlatFiles
#
#!/bin/sh
##########################################################################

if [ $# -ne 4 ]
then
	echo "Usage: db2loadxa.sh <root_of_where_the_flatfiles_are_stored> <database_name>"
	echo "                    <injection_rate> <number_of_threads_used_to_generate_those_files>"
	exit 1
fi

# Prefix needed for trailing format of the flatfiles
prefix='_000'

db2 -v db2start
db2 -v connect to $2 

# Counter used to extract tablenames
counter=1

# Index of Table Array
index=1

for tabname in $(db2 list tables)
do
	if [ "$counter" -ge 10 ]
	then
		# Remove header from list table output
		check=`expr $counter - 6`

		# Tabname exists in column 1 of 4
		check=`expr $check % 4`
		
		# Add tabname to array
		if [ "$check" -eq 0 ]
		then
			tables[$index]=`echo $tabname | tr A-Z a-z`
			let "index += 1"
		fi
	fi
	let "counter += 1"
done

# Remove the "total selected" value from array since it also resided in column 1
tables[${#tables[*]}]=''
		
##########################################################################
#
# For each table and for each thread used to generate the files, 
# load each of the files one by one where the delimiter is '|'
#
# Warning: Before loading, make sure the tables are empty! The script will not clean
#          out any of the existing data
#
##########################################################################

for table in ${tables[*]}
do
	db2 "delete from $table"
	for ((x=0; x < $4; x+=1))
	do
		echo "Loading ${table}"	
		if [ -f $1/datafiles/Ir_$3/$table/$table$prefix$x ]
		then	
			db2 "load from $1/datafiles/Ir_$3/$table/$table$prefix$x of del modified by coldel| insert into $table nonrecoverable"		
		fi
	done
done
echo "Done"
