#########################################################
# IBM DB2 Create Database Script for SPECjAppServer2004
# This script will create a database with tables based
# on the options specified.
#
# Author: Meng Fu
# Created: July 23, 2004
#
# Usage: blddbxa.sh [-c -m -o -s -u] <database_name> <database_dir>
#
# Options:
# -c Creates C Tables
# -m Creates M Tables
# -o Creates O Tables
# -s Creates S Tables
# -u Creates U Tables
#
#!/bin/sh
#########################################################

c_table="false"
m_table="false"
o_table="false"
s_table="false"
u_table="false"

while getopts ':cmosu' option
do
	case	"$option" in
	"c")	c_table="true"
		;;
	"m")	m_table="true"
		;;
	"o")	o_table="true"
		;;
	"s")	s_table="true"
		;;
	"u")	u_table="true"
		;;
	?)	echo "Usage: blddbxa.sh [-c -m -o -s -u] <database_name> <database_dir>"
		exit 1
		;;
	esac
done

if [ $OPTIND -eq 1 ] 
then
	echo "Usage: blddbxa.sh [-c -m -o -s -u] <database_name> <database_dir>"
	exit 1
fi 

shift `expr $OPTIND - 1`

if [ $# -ne 2 ]
then
	echo "Usage: blddbxa.sh [-c -m -o -s -u] <database_name> <database_dir>"
	exit 1
fi

DB=$1
DB_DIR=$2

db2 -v db2start

# Create the DB
./createdb.sh ${DB} ${DB_DIR}

# Create the tablespaces and tables
if [ $c_table == "true" ]
then 
	./schema_C.sh ${DB} ${DB_DIR}
fi

if [ $m_table == "true" ]
then
	./schema_M.sh ${DB} ${DB_DIR}
fi

if [ $o_table == "true" ]
then
	./schema_O.sh ${DB} ${DB_DIR}
fi

if [ $s_table == "true" ]
then
	./schema_S.sh ${DB} ${DB_DIR}
fi

if [ $u_table == "true" ]
then
	# Create the (U??) tablespace and table
	./schema_U.sh ${DB} ${DB_DIR}
fi
echo "Done"
