#!/bin/bash

ulimit -n 10000

# allows for easy changing of the heap size
# just make sure that heap_size and lp_size are accurate (lp_size should be set once for the system and then left alone)
heap_size=2304
lp_size=16
num_lp=$(( $heap_size / $lp_size ))
shared_bytes=$(( $num_lp * $lp_size * 1024 * 1024 ))
echo -e "Heap Size = $heap_size\tLarge Page Size = $lp_size\tNumber of Large Pages = $num_lp\tShared Bytes = $shared_bytes"
echo "$num_lp" > /proc/sys/vm/nr_hugepages
echo "$shared_bytes" > /proc/sys/kernel/shmmax
echo "$shared_bytes" > /proc/sys/kernel/shmall

echo "20000" > /proc/sys/net/core/netdev_max_backlog
echo "20000" > /proc/sys/net/core/somaxconn
echo "30"    > /proc/sys/net/ipv4/tcp_fin_timeout
echo "20"    > /proc/sys/net/ipv4/tcp_syn_retries
echo "20"    > /proc/sys/net/ipv4/tcp_synack_retries

# changes needed for clustering
# prevents the server from responding to ARP on the cluster adddress

echo "3" >/proc/sys/net/ipv4/conf/all/arp_ignore
echo "2" >/proc/sys/net/ipv4/conf/all/arp_announce

echo "Using Cluster Address  9.3.32.147  "
ip addr add 9.3.32.147/32 scope host dev lo
