#!/bin/bash

ulimit -n 10000

# allows for easy changing of the heap size
# just make sure that heap_size and lp_size are accurate (lp_size should be set once for the system and then left alone)
heap_size=12032
lp_size=16
num_lp=$(( $heap_size / $lp_size ))
shared_bytes=$(( $num_lp * $lp_size * 1024 * 1024 ))
echo -e "Heap Size = $heap_size\tLarge Page Size = $lp_size\tNumber of Large Pages = $num_lp\tShared Bytes = $shared_bytes"
echo "$num_lp" > /proc/sys/vm/nr_hugepages
echo "$shared_bytes" > /proc/sys/kernel/shmmax
echo "$shared_bytes" > /proc/sys/kernel/shmall

