/*
 * Copyright (c) 2004 Standard Performance Evaluation Corporation (SPEC)
 *               All rights reserved.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *  History:
 *  Date        ID, Company                Description
 *  ----------  ------------------------   ----------------------------------------------
 *  2003/06/19  John Stecher, IBM          Created to making an abstraction around the naming
 *                                         lookups on the web tier of the application
 *  2003/06/19  John Stecher, IBM          Added Remote Interface Support
 *  2003/06/30  John Stecher, IBM          Added Local Interface Support
 *  2004/02/18  Samuel Kounev, Darmstadt   Added OrderAuditSes bean lookup
 */

package org.spec.jappserver.servlet.helper;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;

import org.spec.jappserver.corp.customerses.ejb.CustomerSes;
import org.spec.jappserver.corp.customerses.ejb.CustomerSesHome;
import org.spec.jappserver.corp.customerses.ejb.CustomerSesHomeLocal;
import org.spec.jappserver.corp.customerses.ejb.CustomerSesLocal;
import org.spec.jappserver.mfg.largeorderses.ejb.LargeOrderSes;
import org.spec.jappserver.mfg.largeorderses.ejb.LargeOrderSesHome;
import org.spec.jappserver.mfg.workorderses.ejb.WorkOrderSes;
import org.spec.jappserver.mfg.workorderses.ejb.WorkOrderSesHome;
import org.spec.jappserver.orders.itemBrowserSes.ejb.ItemBrowserSes;
import org.spec.jappserver.orders.itemBrowserSes.ejb.ItemBrowserSesHome;
import org.spec.jappserver.orders.itemBrowserSes.ejb.ItemBrowserSesHomeLocal;
import org.spec.jappserver.orders.itemBrowserSes.ejb.ItemBrowserSesLocal;
import org.spec.jappserver.orders.orderses.ejb.OrderSes;
import org.spec.jappserver.orders.orderses.ejb.OrderSesHome;
import org.spec.jappserver.orders.orderses.ejb.OrderSesHomeLocal;
import org.spec.jappserver.orders.orderses.ejb.OrderSesLocal;
import org.spec.jappserver.orders.orderauditses.ejb.OrderAuditSes;
import org.spec.jappserver.orders.orderauditses.ejb.OrderAuditSesHome;

/**
 * @author jstecher
 * 
 */
public class SpecBeanFactory {

    private static InitialContext ic;
    private static boolean local_interfaces = SpecConfig.web_to_ejb_locals;

    // Remote Homes
    private static CustomerSesHome csHome;
    private static OrderSesHome osHome;
    private static ItemBrowserSesHome ibsHome;
    private static OrderAuditSesHome oasHome;  
    private static WorkOrderSesHome wosHome;
    private static LargeOrderSesHome losHome; 
    
    private static CustomerSesHomeLocal csHomeLocal;
    private static OrderSesHomeLocal osHomeLocal;
    private static ItemBrowserSesHomeLocal ibsHomeLocal;
    
    /**
	 * Initalizes the remote homes of all beans accessed by the web tier.
	 * @return void
	 */
    public static void initalizeRemoteNaming() throws Exception{
    	if( SpecConfig.debugging ) {
            SpecConfig.debug.println(3, "SpecNamingFactory.initalizeRemoteNaming() ");  
        }
    	if(csHome==null || osHome==null || ibsHome==null || wosHome==null || losHome==null){
    			ic = new InitialContext();
    			csHome = (CustomerSesHome) javax.rmi.PortableRemoteObject.narrow(ic.lookup("java:comp/env/ejb/CustomerSes"), CustomerSesHome.class);
    			osHome = (OrderSesHome) javax.rmi.PortableRemoteObject.narrow(ic.lookup("java:comp/env/ejb/OrderSes"), OrderSesHome.class);
    			ibsHome = (ItemBrowserSesHome) javax.rmi.PortableRemoteObject.narrow(ic.lookup("java:comp/env/ejb/ItemBrowserSes"), ItemBrowserSesHome.class);
			oasHome = (OrderAuditSesHome) javax.rmi.PortableRemoteObject.narrow(ic.lookup("java:comp/env/ejb/OrderAuditSes"), OrderAuditSesHome.class);
    			losHome = (LargeOrderSesHome) javax.rmi.PortableRemoteObject.narrow(ic.lookup("java:comp/env/ejb/LargeOrderSes"), LargeOrderSesHome.class);
    			wosHome = (WorkOrderSesHome) javax.rmi.PortableRemoteObject.narrow(ic.lookup("java:comp/env/ejb/WorkOrderSes"), WorkOrderSesHome.class);
    	}	
    }
	/**
		 * Initalizes the local homes of all beans accessed by the web tier for the benchmarking application.
		 * Manufacturing beans are still created with remote interfaces.
		 * @return void
		 */
		public static void initalizeLocalNaming() throws Exception{
			if( SpecConfig.debugging ) {
				SpecConfig.debug.println(3, "SpecNamingFactory.initalizeRemoteNaming() ");  
			}
			if(csHomeLocal==null || osHomeLocal==null || ibsHomeLocal==null || wosHome==null || losHome==null){
					ic = new InitialContext();
					csHomeLocal = (CustomerSesHomeLocal) ic.lookup("java:comp/env/ejb/CustomerSesLocal");
					osHomeLocal = (OrderSesHomeLocal) ic.lookup("java:comp/env/ejb/OrderSesLocal");
					ibsHomeLocal = (ItemBrowserSesHomeLocal) ic.lookup("java:comp/env/ejb/ItemBrowserSesLocal");
					oasHome = (OrderAuditSesHome) javax.rmi.PortableRemoteObject.narrow(ic.lookup("java:comp/env/ejb/OrderAuditSes"), OrderAuditSesHome.class);
					losHome = (LargeOrderSesHome) javax.rmi.PortableRemoteObject.narrow(ic.lookup("java:comp/env/ejb/LargeOrderSes"), LargeOrderSesHome.class);
					wosHome = (WorkOrderSesHome) javax.rmi.PortableRemoteObject.narrow(ic.lookup("java:comp/env/ejb/WorkOrderSes"), WorkOrderSesHome.class);
			}	
		}
	/**
	 * Returns the CustomerSes.
	 * @return CustomerSes
	 */
	public static Object createCustomerSes() throws RemoteException, CreateException  {
		if(local_interfaces){
			return csHomeLocal.create();
		}else{
			return csHome.create();
		}
	}

	/**
	 * Returns the ItemBrowserSes.
	 * @return ItemBrowserSes
	 */
	public static Object createItemBrowserSes() throws RemoteException, CreateException {
		if(local_interfaces){
			return ibsHomeLocal.create();
		}else{
			return ibsHome.create();
		}
	}	

	/**
	 * Returns the OrderAuditSes.
	 * @return OrderAuditSes
	 */
	public static Object createOrderAuditSes() throws RemoteException, CreateException  {
		return oasHome.create();
	}

	/**
	 * Returns the LargeOrderSes.
	 * @return LargeOrderSes
	 */
	public static Object createLargeOrderSes() throws RemoteException, CreateException {
		return losHome.create();
	}

	/**
	 * Returns the OrderSes.
	 * @return OrderSes
	 */
	public static Object createOrderSes() throws RemoteException, CreateException {
		if(local_interfaces){
			return osHomeLocal.create();
		}else{
			return osHome.create();
		}
	}

	/**
	 * Returns the WorkOrderSes.
	 * @return WorkOrderSes
	 */
	public static Object createWorkOrderSes() throws RemoteException, CreateException {
		return wosHome.create();
	}
	
	/**
	 * Returns the CustomerSes.
	 * @return CustomerSes
	 */
	public static void destroyCustomerSes(Object cs) throws RemoteException, RemoveException  {
		if(local_interfaces){
			((CustomerSesLocal)cs).remove();
		}else{
			((CustomerSes)cs).remove();
		}
	}

	/**
	 * Returns the ItemBrowserSes.
	 * @return ItemBrowserSes
	 */
	public static void destroyItemBrowserSes(Object ibs) throws RemoteException, RemoveException {
		if(local_interfaces){
			((ItemBrowserSesLocal)ibs).remove();
		}else{
			((ItemBrowserSes)ibs).remove();			
		}
	}
	
	/**
	 * Destroys the OrderAuditSes.
	 * @return
	 */
	public static void destroyOrderAuditSes(Object oas) throws RemoteException, RemoveException  {
		((OrderAuditSes)oas).remove();
	}

	/**
	 * Returns the LargeOrderSes.
	 * @return LargeOrderSes
	 */
	public static void destroyLargeOrderSes(Object los) throws RemoteException, RemoveException {
		((LargeOrderSes)los).remove();
	}

	/**
	 * Returns the OrderSes.
	 * @return OrderSes
	 */
	public static void destroyOrderSes(Object os) throws RemoteException, RemoveException {
		if(local_interfaces){
			((OrderSesLocal)os).remove();
		}else{
			((OrderSes)os).remove();			
		}
	}

	/**
	 * Returns the WorkOrderSes.
	 * @return WorkOrderSes
	 */
	public static void destroyWorkOrderSes(Object wos) throws RemoteException, RemoveException {
		((WorkOrderSes)wos).remove();
	}
}
