#!/bin/bash

echo starting restore.sh at IR=$1
echo *!*!*! turning off NPTL !*!*!*
#export LD_ASSUME_KERNEL=2.4.19

PGMPATH="/SPECjAppServer2004/schema/db2"

# check that the root user is executing this program
if [ `id -u` -eq 0 ]; then
  echo "You must be db2inst1 to execute this program."
  echo "calling restore.sh $1 as user db2inst1"
  su - db2inst1 -c "$PGMPATH/restore.sh $1"
  exit
fi

db2stop force
db2 terminate
db2start

if [ `ls -A1 /archive/archive_$1|grep bz2|wc -l` -gt 0 ]
then
  echo "uncompressing database archive to temp file..."
  bunzip2 -k /archive/archive_$1/`ls -A1 /archive/archive_$1`
  echo "...done uncompressing database archive to temp file"
  NO_DELETE=0
else
  echo "database archive is not compressed"
  NO_DELETE=1
fi


echo "restoring database archive from temp file..."
db2 restore database specdb user db2inst1 using ibmdb2 from /archive/archive_$1 without prompting
echo "...done restoring database archive temp file"

# /home/db2inst1/SPECjAppServer2004/schema/db2/db2tune.sh | tee /home/db2inst1/SPECjAppServer2004/schema/db2/db2tune.log
db2 -v activate db specdb

TMP_FILE=`ls -A1 /archive/archive_$1/ | head -n 1`
if [ `echo $TMP_FILE | sed 's/.*bz2.*$/bz2/'` != "bz2" -a $NO_DELETE -eq 0 ]
then
  echo "removing database archive temp file"
  rm /archive/archive_$1/$TMP_FILE
fi
