#!/bin/sh
#
# Copyright (c) 2004 Standard Performance Evaluation Corporation (SPEC)
#                        All rights reserved.
# $Id: schema_C.sh,v 1.3 2004/04/21 13:51:22 skounev Exp $
# 
#
# Script to create corp tables
#
# Tom Daly Jan 2000 
#     modify script to build corp specific 
#     tables and tablespaces against an existing database
#     This is to allow all of spec to run on one database
#     which will allow for easier testing and installation.
#     schema_C.sh now takes database name and database directory 
#     parameters.
#     Note: The database must now exist, refer to the createdb.sh script
#     to build the database prior to running this script.
#
# April 2003 Balu Sthanikam: Updated for SJAS2004 and other changes.
#                     

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ $# -ne 2 ]
then
	echo "Usage: schema_C.sh <database_name> <database dir>"
	exit 1
fi

DB=$1
DB_DIR=$2
ORACLE_SID=$DB
export ORACLE_SID

######  datafiles #####

CUSTINV=${DB_DIR}/C_custinv
CUST=${DB_DIR}/C_cust
SUPP=${DB_DIR}/C_supp
SITE=${DB_DIR}/C_site
PARTS=${DB_DIR}/C_parts


#sqlplus <<EOT  
#CONNECT / as sysdba
#shutdown
#startup 
#EOT

##############################################
#  Enable table locks
##############################################
echo "Enabling table locks"
sqlplus spec/spec <<EOT 
alter table C_customerinventory enable table lock;
alter table C_customer enable table lock;
alter table C_supplier enable table lock;
alter table C_site enable table lock;
alter table C_parts enable table lock;
EOT

##############################################
#  clean up tablespaces and 
#  datafiles from  earlier attempts
##############################################
echo "Cleaning up old tables spaces"
sqlplus <<EOT 
CONNECT / as sysdba
DROP TABLESPACE C_custinv_space INCLUDING CONTENTS;
DROP TABLESPACE C_cust_space INCLUDING CONTENTS;
DROP TABLESPACE C_supp_space INCLUDING CONTENTS;
DROP TABLESPACE C_site_space INCLUDING CONTENTS;
DROP TABLESPACE C_parts_space INCLUDING CONTENTS;
EOT

echo "Removing Datafiles"
#rm -f $CUSTINV $CUST $SUPP $SITE $PARTS


##############################################
# Create the required tablespaces
##############################################
sqlplus <<EOT
CONNECT / as sysdba
CREATE BIGFILE TABLESPACE C_cust_space
	DATAFILE '${CUST}' SIZE 30000M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE BIGFILE TABLESPACE C_custinv_space
	DATAFILE '${CUSTINV}' SIZE 100000M REUSE 
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE TABLESPACE C_supp_space
	DATAFILE '${SUPP}' SIZE 499M REUSE 
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M
	SEGMENT SPACE MANAGEMENT AUTO;

EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE TABLESPACE C_site_space
	DATAFILE '${SITE}' SIZE 499M  REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE TABLESPACE C_parts_space
	DATAFILE '${PARTS}' SIZE 4000M REUSE 
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT


wait


##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec/spec <<EOT
@sql/schema_C
EOT

##############################################
#  enable table locks
##############################################
echo "Enabling table locks"
sqlplus spec/spec <<EOT
alter table C_customerinventory disable table lock;
alter table C_customer disable table lock;
alter table C_supplier disable table lock;
alter table C_site disable table lock;
alter table C_parts disable table lock;
EOT
