#!/bin/sh
#
# Copyright (c) 2004 Standard Performance Evaluation Corporation (SPEC)
#                                 All rights reserved.
#
# $Id: schema_M.sh,v 1.3 2004/04/21 13:51:22 skounev Exp $
#
# Script to create mfg database

# Tom Daly Jan 2000 
#     modify script to build mfg specific 
#     tables and tablespaces against an existing database
#     This is to allow all of spec to run on one database
#     which will allow for easier testing and installation.
#     schema_M.sh now takes database name and database directory 
#     parameters.
#     Note: The database must now exist, refer to the createdb.sh script
#     to build the database prior to running this script.
#
# April 2003 Balu Sthanikam: Updated for SJAS2004 and other changes.

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ $# -ne 2 ]
then
	echo "Usage: schema_M.sh <database_name> <database dir>"
	exit 1
fi

DB=$1
DB_DIR=$2
ORACLE_SID=$DB
export ORACLE_SID

######  datafiles #####
PART=${DB_DIR}/M_parts
BOM=${DB_DIR}/M_bom
WO=${DB_DIR}/M_wrkorder
WO_IDX=${DB_DIR}/M_wrkorder_idx
LO=${DB_DIR}/M_lrgorder
INV=${DB_DIR}/M_inv
INV_IDX=${DB_DIR}/M_inv_idx

#sqlplus <<EOT  
#CONNECT / as sysdba
#shutdown
#startup 
#EOT

##############################################
#  clean up datafiles from  earlier attempts
##############################################
echo "Cleaning up old tables spaces"
sqlplus <<EOT 
CONNECT / as sysdba
DROP TABLESPACE M_parts_space INCLUDING CONTENTS;
DROP TABLESPACE M_bom_space INCLUDING CONTENTS;
DROP TABLESPACE M_wo_space INCLUDING CONTENTS;
DROP TABLESPACE M_wo_idx_space INCLUDING CONTENTS;
DROP TABLESPACE M_lo_space INCLUDING CONTENTS;
DROP TABLESPACE M_inv_space INCLUDING CONTENTS;
EOT

#rm -f $BOM $WO $LO $INV $PART


##############################################
# Create the required tablespaces
##############################################
sqlplus <<EOT
CONNECT / as sysdba
CREATE BIGFILE TABLESPACE M_parts_space
	DATAFILE '${PART}' SIZE 60000M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE BIGFILE TABLESPACE M_bom_space
	DATAFILE '${BOM}' SIZE 15000M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE BIGFILE TABLESPACE M_wo_space
	DATAFILE '${WO}' SIZE 52000M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE BIGFILE TABLESPACE M_wo_idx_space
        DATAFILE '${WO_IDX}' SIZE 52000M REUSE
        EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
        SEGMENT SPACE MANAGEMENT AUTO;
        EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE BIGFILE TABLESPACE M_lo_space
	DATAFILE '${LO}' SIZE 12000M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
CREATE BIGFILE TABLESPACE M_inv_space
	DATAFILE '${INV}' SIZE 30000M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
	SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

sqlplus <<EOT
CONNECT / as sysdba
drop tablespace M_inv_idx_space including contents;
CREATE BIGFILE TABLESPACE M_inv_idx_space
        DATAFILE '${INV_IDX}' SIZE 30000M REUSE
        EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M
        SEGMENT SPACE MANAGEMENT AUTO;
        EXIT
EOT


wait

##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec/spec <<EOT
@sql/schema_M
EOT
