#!/bin/ksh
#
SUDO=/usr/bin/sudo
PCITOOL=/usr/sbin/pcitool

CPU_START=0
CPU_OFF=64
PSET_OFF=64

set -A link_arr     0    1    2    3    4     5    6     7    8    9   10   11   12    13    14    15    16
set -A dev_arr   i40e i40e i40e i40e   na ixgbe   na ixgbe   na   na   na   na   na ixgbe ixgbe ixgbe ixgbe
set -A inst_arr     0    1    2    3   na    na   na    na   na   na   na   na   na     1     0     3     2
set -A nexus_arr  300  300  300  300  302   302  300   302  300  300  305  305  303   302   302   302   302
set -A inst_start   0    0   64    0    0     0    0    64    0    0    0    0    0     0     0    64     0
set -A tgt_cnt      4    6    6    4    4     6    4     6    4    4    4    4    4     6     4     6     4

set -A inst_tgt    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0

for X in 5 7 1 2
do
        I=${inst_arr[$X]}
        device=`dladm show-phys -o DEVICE -p net${link_arr[$X]}`	#e.g. ixgbe1 or i40e1
        echo Configuring intrs for $device
        NEXUS=/`ls -l /dev/$device | awk '{print $11}' | cut -d / -f3`	#e.g., /pci@302
        echo $NEXUS

        driver=`echo $device | sed "s/${dev_arr[$X]}/${dev_arr[$X]}#/"`
        ino_cnt=`$SUDO $PCITOOL $NEXUS -i | grep -cw ${driver}`
        echo "Driver $driver has $ino_cnt interrupts"

        set -A ino_arr `$SUDO $PCITOOL $NEXUS -i | grep -w ${driver} | sort +0.10 | awk '{print $3}'`

        T=`expr $ino_cnt - 1`
        TC=${tgt_cnt[$X]}
        TGT=${inst_start[$X]}
        while [ $T -ge 0 ]; do
		#echo "$T: $TGT"
                inst_tgt[$T]=`printf "%x" $TGT`
                TC=`expr $TC - 1`
                TGT=`expr $TGT + 1`
                if [ $TC -eq 8 ]; then
                        TGT=${inst_start[$X]}
			TGT=`expr $TGT + 64`
                fi
                if [ $TC -eq 0 ]; then
                        TC=${tgt_cnt[$X]}
                        TGT=${inst_start[$X]}
                fi
                T=`expr $T - 1`
        done

        echo "Targeted cpus: "
        T=0
        while [ $T -lt $ino_cnt ]; do
                echo $T: "0x${inst_tgt[$T]} -> ${ino_arr[$T]}"
                T=`expr $T + 1`
        done

        i=0
        while [ $i -lt $ino_cnt ] ; do
                $SUDO $PCITOOL $NEXUS -m ${ino_arr[$i]} -w ${inst_tgt[$i]}
                i=`expr $i + 1`
        done

done

