sqlplus "/as sysdba" << !
spool createTS_S.out

DROP TABLESPACE S_comp_space INCLUDING CONTENTS;
DROP TABLESPACE S_sc_space INCLUDING CONTENTS;
DROP TABLESPACE S_po_space INCLUDING CONTENTS;
DROP TABLESPACE S_pol_space INCLUDING CONTENTS;
DROP TABLESPACE S_runcfg_space INCLUDING CONTENTS;
DROP TABLESPACE S_supp_space INCLUDING CONTENTS;

CREATE BIGFILE TABLESPACE S_comp_space
        DATAFILE '$DB_DIR/S_comp' SIZE 10000M REUSE BLOCKSIZE 4k
        ENCRYPTION USING 'AES256'
        DEFAULT STORAGE (ENCRYPT);
CREATE BIGFILE TABLESPACE S_sc_space
        DATAFILE '$DB_DIR/S_sc' SIZE 5000M REUSE BLOCKSIZE 4k
        ENCRYPTION USING 'AES256'
        DEFAULT STORAGE (ENCRYPT);
CREATE BIGFILE TABLESPACE S_po_space
        DATAFILE '$DB_DIR/S_po'SIZE 10000M REUSE 
        ENCRYPTION USING 'AES256'
        DEFAULT STORAGE (ENCRYPT);
CREATE BIGFILE TABLESPACE S_pol_space
        DATAFILE '$DB_DIR/S_pol'SIZE 30000M REUSE 
        ENCRYPTION USING 'AES256'
        DEFAULT STORAGE (ENCRYPT);
CREATE TABLESPACE S_runcfg_space
        DATAFILE '$DB_DIR/S_runcfg' SIZE 250M REUSE 
        EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_supp_space
        DATAFILE '$DB_DIR/S_supp' SIZE 1000M REUSE 
        ENCRYPTION USING 'AES256'
        DEFAULT STORAGE (ENCRYPT);
spool off
!
