#!/bin/ksh

LLR="+DATA/wlsllr"

sqlplus "/as sysdba" << !
CREATE BIGFILE TABLESPACE wlsllr_ts
       DATAFILE '${LLR}' SIZE 8000M REUSE
       EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;
!


for x in 71 72 ; do

sqlplus "spec/spec" << EOT
alter table WL_LLR_JENT${x} enable table lock;
drop table WL_LLR_JENT${x};
CREATE TABLE WL_LLR_JENT${x}
    (
    XIDSTR  VARCHAR2(40) not null,
    POOLNAMESTR VARCHAR2(64),
    RECORDSTR VARCHAR2(1000)
    )
    PARTITION BY HASH (XIDSTR)
    PARTITIONS 32
    STORE IN (wlsllr_ts)
    initrans 30 pctfree 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

    CREATE UNIQUE INDEX WL_LLR_JENT${x}_idx ON WL_LLR_JENT${x} (xidstr) LOCAL
    STORE IN (wlsllr_ts)
    INITRANS 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

    alter table WL_LLR_JENT${x} disable table lock;
EOT

done
