DROP TABLESPACE O_cust_space INCLUDING CONTENTS;
DROP TABLESPACE O_custinv_space INCLUDING CONTENTS;
DROP TABLESPACE O_ords_space INCLUDING CONTENTS;
DROP TABLESPACE O_ordl_space INCLUDING CONTENTS;
DROP TABLESPACE O_item_space INCLUDING CONTENTS;

CREATE BIGFILE TABLESPACE O_cust_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/O_cust' SIZE 20G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE BIGFILE TABLESPACE O_custinv_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/O_custinv' SIZE 80G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE O_ords_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/O_ords' SIZE 2G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE BIGFILE TABLESPACE O_ordl_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/O_ordl' SIZE 16G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE O_item_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/O_item' SIZE 1G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;

DROP TABLESPACE M_parts_space INCLUDING CONTENTS;
DROP TABLESPACE M_bom_space INCLUDING CONTENTS;
DROP TABLESPACE M_wo_space INCLUDING CONTENTS;
DROP TABLESPACE M_inv_space INCLUDING CONTENTS;

CREATE TABLESPACE M_parts_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/M_site'  SIZE 1G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE M_bom_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/M_bom'  SIZE 1G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE BIGFILE TABLESPACE M_wo_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/M_wo'  SIZE 30G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE M_inv_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/M_inv'  SIZE 1G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 5M SEGMENT SPACE MANAGEMENT AUTO;

DROP TABLESPACE S_comp_space INCLUDING CONTENTS;
DROP TABLESPACE S_sc_space INCLUDING CONTENTS;
DROP TABLESPACE S_po_space INCLUDING CONTENTS;
DROP TABLESPACE S_pol_space INCLUDING CONTENTS;
DROP TABLESPACE S_runcfg_space INCLUDING CONTENTS;
DROP TABLESPACE S_supp_space INCLUDING CONTENTS;

CREATE TABLESPACE S_comp_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/S_comp' SIZE 2G REUSE BLOCKSIZE 4K
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_sc_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/S_sc' SIZE 2G REUSE BLOCKSIZE 4K
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_po_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/S_po' SIZE 1G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_pol_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/S_pol' SIZE 1G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_runcfg_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/S_runcfg' SIZE 1G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_supp_space
	DATAFILE '@VENDOR_SQL_DB_DIR@/S_supp' SIZE 1G REUSE AUTOEXTEND ON NEXT 250M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;


DROP TABLESPACE U_seqs INCLUDING CONTENTS;
DROP TABLESPACE U_dsegs INCLUDING CONTENTS;
DROP TABLESPACE U_ldr INCLUDING CONTENTS;
DROP TABLESPACE U_lmsg INCLUDING CONTENTS;
DROP TABLESPACE U_lsec INCLUDING CONTENTS;

CREATE TABLESPACE U_seqs
	DATAFILE '@VENDOR_SQL_DB_DIR@/U_seqs' SIZE 500M REUSE AUTOEXTEND ON NEXT 100M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE U_dsegs
	DATAFILE '@VENDOR_SQL_DB_DIR@/U_dsegs' SIZE 500M REUSE AUTOEXTEND ON NEXT 100M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE U_ldr
	DATAFILE '@VENDOR_SQL_DB_DIR@/U_ldr' SIZE 500M REUSE AUTOEXTEND ON NEXT 100M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE U_lmsg
	DATAFILE '@VENDOR_SQL_DB_DIR@/U_lmsg' SIZE 500M REUSE AUTOEXTEND ON NEXT 100M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
CREATE TABLESPACE U_lsec
	DATAFILE '@VENDOR_SQL_DB_DIR@/U_lsec' SIZE 500M REUSE AUTOEXTEND ON NEXT 100M
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M;
