#!/bin/sh
#
MAX_REDO=4
cnt=1
for F in `cat /proc/partitions | grep 877332480 | awk '{print $4}'`
do
    dev=$F
    PDEV_SIZE=`grep -c ${dev}1 /proc/partitions`
    if [ $PDEV_SIZE -gt 0 ]; then
      PDEV_SIZE=`grep ${dev}1 /proc/partitions |  awk '{print $3}'`
      if [ $PDEV_SIZE -lt 877332480 ]; then
        GUID=`/sbin/scsi_id -g -s /block/$dev`
        SLINK=`echo $GUID | cut -c27-33`
        rm -f log_$SLINK
        ln -s /dev/${dev}1 log_$SLINK
        chown -R oracle:dba /dev/${dev}1
        echo "device $cnt: $dev: $GUID: $SLINK"
        cnt=`expr $cnt + 1`
      fi
    fi
done

if [ $cnt -lt $MAX_REDO ]; then
        echo "FATAL: detected only $cnt redo log devices"
fi

# Create raw devices
cnt=1
for F in `ls -1 log*`
do
        raw /dev/raw/raw${cnt} $F
        cnt=`expr $cnt + 1`
done

