#! /bin/bash

DB=SPECDB
app_instances=1

for arg; do export "$arg"; done

if [ -z "$app_host" ]; then
	echo "You must specify the application server host name with the app_host= parameter."
	echo "Optionally specify the number of application server instances with the app_instances= parameter (default 1)."
	exit 1
fi

db2 -v "CONNECT TO $DB"
db2 -v "CREATE BUFFERPOOL JMS_BP PAGESIZE 32K"
db2 -v "CREATE TABLESPACE JMS_SPACE PAGESIZE 32K MANAGED BY AUTOMATIC STORAGE BUFFERPOOL JMS_BP INITIALSIZE 500M EXTENTSIZE 1024K PREFETCHSIZE 8K"
db2 -v "CREATE BUFFERPOOL JMS_IDX_BP PAGESIZE 32K"
db2 -v "CREATE TABLESPACE JMS_IDX_SPACE PAGESIZE 32K MANAGED BY AUTOMATIC STORAGE BUFFERPOOL JMS_IDX_BP INITIALSIZE 500M EXTENTSIZE 1024K PREFETCHSIZE 8K"
for i in `seq 1 $app_instances`; do
	schema="${app_host}Node$(printf "%02d" $i)"

        db2 -v "drop table $schema.sib000"
        db2 -v "drop table $schema.sib001"
        db2 -v "drop table $schema.sib002"
        db2 -v "drop table $schema.SIBCLASSMAP"
        db2 -v "drop table $schema.SIBKEYS"
        db2 -v "drop table $schema.SIBLISTING"
        db2 -v "drop table $schema.SIBOWNER"
        db2 -v "drop table $schema.SIBOWNERO"
        db2 -v "drop table $schema.SIBXACTS"
        db2 -v "DROP SCHEMA $schema RESTRICT"
        db2 -v "CREATE SCHEMA $schema AUTHORIZATION DB2INST1"
        db2 -v "CREATE TABLE $schema.SIBOWNERO (EMPTY_COLUMN INTEGER)"
        db2 -v "CREATE TABLE $schema.SIBOWNER (ME_UUID VARCHAR(16), INC_UUID VARCHAR(16), VERSION INTEGER, MIGRATION_VERSION INTEGER, ME_LUTS TIMESTAMP, ME_INFO VARCHAR(254), ME_STATUS VARCHAR(16))"
        db2 -v "CREATE TABLE $schema.SIBCLASSMAP (CLASSID INTEGER NOT NULL, URI VARCHAR(2048) NOT NULL)"
        db2 -v "ALTER TABLE $schema.SIBCLASSMAP ADD PRIMARY KEY (CLASSID)"
        db2 -v "CREATE TABLE $schema.SIBLISTING (ID INTEGER NOT NULL, SCHEMA_NAME VARCHAR(10), TABLE_NAME VARCHAR(10) NOT NULL, TABLE_TYPE CHAR(1) NOT NULL)"
        db2 -v "ALTER TABLE $schema.SIBLISTING ADD PRIMARY KEY (ID)"
        db2 -v "CREATE TABLE $schema.SIB000(ID BIGINT NOT NULL, STREAM_ID BIGINT NOT NULL, TYPE CHAR(2), EXPIRY_TIME BIGINT, STRATEGY INTEGER, REFERENCE BIGINT, CLASS_ID INTEGER NOT NULL, PRIORITY INTEGER, SEQUENCE BIGINT, PERMANENT_ID INTEGER, TEMPORARY_ID INTEGER, LOCK_ID BIGINT, DATA_SIZE INTEGER NOT NULL, DATA VARCHAR(28869) FOR BIT DATA, LONG_DATA BLOB(1073741824) LOGGED NOT COMPACT, XID VARCHAR(254), DELETED SMALLINT, REDELIVERED_COUNT INTEGER) IN JMS_SPACE INDEX IN JMS_IDX_SPACE"
        db2 -v "ALTER TABLE $schema.SIB000 VOLATILE CARDINALITY"
        db2 -v "CREATE UNIQUE INDEX $schema.SIB000PKIX ON $schema.SIB000(ID ASC) COMPRESS NO ALLOW REVERSE SCANS"
        db2 -v "ALTER TABLE $schema.SIB000 ADD CONSTRAINT SIB000PKIX PRIMARY KEY(ID)"
        db2 -v "CREATE INDEX $schema.SIB000STREAMIX ON $schema.SIB000 (STREAM_ID ASC, SEQUENCE ASC) COMPRESS NO ALLOW REVERSE SCANS"
        db2 -v "CREATE TABLE $schema.SIB001(ID BIGINT NOT NULL, STREAM_ID BIGINT NOT NULL, TYPE CHAR(2), EXPIRY_TIME BIGINT, STRATEGY INTEGER, REFERENCE BIGINT, CLASS_ID INTEGER NOT NULL, PRIORITY INTEGER, SEQUENCE BIGINT, PERMANENT_ID INTEGER, TEMPORARY_ID INTEGER, LOCK_ID BIGINT, DATA_SIZE INTEGER NOT NULL, DATA VARCHAR(28869) FOR BIT DATA, LONG_DATA BLOB(1073741824) LOGGED NOT COMPACT, XID VARCHAR(254), DELETED SMALLINT, REDELIVERED_COUNT INTEGER) IN JMS_SPACE INDEX IN JMS_IDX_SPACE"
        db2 -v "ALTER TABLE $schema.SIB001 VOLATILE CARDINALITY"
        db2 -v "CREATE UNIQUE INDEX $schema.SIB001PKIX ON $schema.SIB001(ID ASC) COMPRESS NO ALLOW REVERSE SCANS"
        db2 -v "ALTER TABLE $schema.SIB001 ADD CONSTRAINT SIB001PKIX PRIMARY KEY (ID)"
        db2 -v "CREATE INDEX $schema.SIB001STREAMIX ON $schema.SIB001(STREAM_ID ASC, SEQUENCE ASC) COMPRESS NO ALLOW REVERSE SCANS"
        db2 -v "CREATE TABLE $schema.SIB002(ID BIGINT NOT NULL, STREAM_ID BIGINT NOT NULL, TYPE CHAR(2), EXPIRY_TIME BIGINT, STRATEGY INTEGER, REFERENCE BIGINT, CLASS_ID INTEGER NOT NULL, PRIORITY INTEGER, SEQUENCE BIGINT, PERMANENT_ID INTEGER, TEMPORARY_ID INTEGER, LOCK_ID BIGINT, DATA_SIZE INTEGER NOT NULL, DATA VARCHAR(28869) FOR BIT DATA, LONG_DATA BLOB(1073741824) LOGGED NOT COMPACT, XID VARCHAR(254), DELETED SMALLINT, REDELIVERED_COUNT INTEGER) IN JMS_SPACE INDEX IN JMS_IDX_SPACE"
        db2 -v "ALTER TABLE $schema.SIB002 VOLATILE CARDINALITY"
        db2 -v "CREATE UNIQUE INDEX $schema.SIB002PKIX ON $schema.SIB002(ID ASC) COMPRESS NO ALLOW REVERSE SCANS"
        db2 -v "ALTER TABLE $schema.SIB002 ADD CONSTRAINT SIB002PKIX PRIMARY KEY (ID)"
        db2 -v "CREATE INDEX $schema.SIB002STREAMIX ON $schema.SIB002(STREAM_ID ASC, SEQUENCE ASC) COMPRESS NO ALLOW REVERSE SCANS"
        db2 -v "CREATE TABLE $schema.SIBKEYS (ID VARCHAR(50) NOT NULL, LAST_KEY BIGINT NOT NULL)"
        db2 -v "ALTER TABLE $schema.SIBKEYS ADD PRIMARY KEY (ID)"
        db2 -v "CREATE TABLE $schema.SIBXACTS (XID VARCHAR(254) NOT NULL, STATE CHAR(1) NOT NULL)"
        db2 -v "ALTER TABLE $schema.SIBXACTS ADD PRIMARY KEY(XID)"
done

