#!/bin/sh
#
SUDO=sudo
ZNAME=jent

# reset config
PSET=1
while [ $PSET -le 16 ]; 
do
	$SUDO psrset -d $PSET
	PSET=`expr $PSET + 1`
done
$SUDO psradm -an

# create 2x (58-strand) psets per chip
# leave 6 strands[0-5] per chip for NIC fanouts 
# leave 6 strands[64-69] per chip for NIC & MPT interrupts
PSET_START=6
PSET_END=63
PSET_OFF=64
PSET=1
while [ $PSET -le 16 ]; 
do
	echo $SUDO psrset -c ${PSET_START}-${PSET_END}
	$SUDO psrset -c ${PSET_START}-${PSET_END}
	PSET=`expr $PSET + 1`
	PSET_START=`expr $PSET_START + $PSET_OFF`
	PSET_END=`expr $PSET_END + $PSET_OFF`
done


# disable intrs in psets
PSET=1
while [ $PSET -le 16 ]; 
do
	echo $SUDO psrset -f $PSET
	$SUDO psrset -f $PSET
	PSET=`expr $PSET + 1`
done

#
# bind processes in the 16 zones to the psets
#
PSET=1
for Z in 31 32 33 34 35 36 37 38 41 42 43 44 45 46 47 48
do
        ZONENAME=$ZNAME$Z
        echo "Binding processes in $ZONENAME to processor set $PSET"
        PIDS=`pgrep -z $ZONENAME`
        for P in $PIDS
        do
                $SUDO /usr/sbin/psrset -b $PSET $P
        done
        PSET=`expr $PSET + 1`
        if [ $PSET -gt 17 ]; then
		echo "Error: pset overflow!"
                PSET=1
        fi
done

