#!/bin/sh
#
SUDO=sudo
PCITOOL=/usr/sbin/pcitool

# Use 16 strands from each SPARC T5 chip - 2 cores

CPU_START=0
CPU_OFF=128
PSET_OFF=128

set -A nexus_arr 300 300 380 380 500 500 580 580
z=0
for I in 6 7 4 5 14 15 16 17
do
	# Get the MSI list for this device 
	echo Configuring intrs for ixgbe#${I}
	NEXUS=/pci@${nexus_arr[$z]}
	ino_cnt=`$SUDO $PCITOOL $NEXUS -i | grep -c ixgbe#${I}`
	set -A ino_arr `$SUDO $PCITOOL $NEXUS -i | grep ixgbe#${I} | sort +0.10 | awk '{print $3}'`

	# Build the CPU array	                # cpu offset + (z X 64)
	CS0=$CPU_START				# 0
	CS1=`expr $CS0 + 1`			# 1
	CS2=`expr $CS1 + 1`			# 2
	CS3=`expr $CS2 + 1`			# 3
	CS4=`expr $CS3 + 1`			# 4
	CS5=`expr $CS4 + 1`			# 5
	CS6=`expr $CS5 + 1`			# 6
	CS7=`expr $CS6 + 1`			# 7
	CS8=`expr $CS7 + 1`			# 8
	CS9=`expr $CS8 + 1`			# 9
	CS10=`expr $CS9 + 1`			# 10
	CS11=`expr $CS10 + 1`			# 11
	CS12=`expr $CS11 + 1`			# 12
	CS13=`expr $CS12 + 1`			# 13
	CS14=`expr $CS13 + 1`			# 14
	CS15=`expr $CS14 + 1`			# 15

	#echo "$CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7 $CS8 $CS9 $CS10 $CS11 $CS12 $CS13 $CS14 $CS15"
	set -A cpu_arr `printf "%x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x" $CS0 $CS1 $CS2 $CS3 $CS4 $CS5 $CS6 $CS7 $CS8 $CS9 $CS10 $CS11 $CS12 $CS13 $CS14 $CS15`

	# Program the CPU binding for this MSI
	i=0
	while [ $i -lt $ino_cnt ] ; do
		#echo "$SUDO $PCITOOL $NEXUS -m ${ino_arr[$i]} -w ${cpu_arr[$i]}"
		$SUDO $PCITOOL $NEXUS -m ${ino_arr[$i]} -w ${cpu_arr[$i]}
		i=`expr $i + 1`
	done

	z=`expr $z + 1`
	CPU_START=`expr $CPU_START + $PSET_OFF`
	sleep 1
done

