#!/bin/sh
#
SUDO=sudo
PCITOOL=/usr/sbin/pcitool

#
# For each CPU chip, allocate cpu strands as follows
#    0 - 115: 116 threads for applications
#  116 - 122: 8 threads for ixgbe fanout
#  123 - 127: 4 strands for ixgbe interrupts
# 
#
CPU_START=640
CPU_START=`expr $CPU_START - 4`
CPU_OFF=128

set -A nexus_arr 500 580 600 6c0
z=0
for I in 14 16 22 18
do
	# Get the MSI list for this device for Driver txns
	echo Configuring intrs for ixgbe#${I}
	NEXUS=/pci@${nexus_arr[$z]}
	ino_cnt=`$SUDO $PCITOOL $NEXUS -i | grep -c ixgbe#${I}`
	set -A ino_arr `$SUDO $PCITOOL $NEXUS -i | grep ixgbe#${I} | sort +0.10 | awk '{print $3}'`

	# Build the CPU array	                # cpu offset + (chip number X 128)
	CS0=`expr $CPU_START`			# 636
	CS1=`expr $CS0 + 1`			# 637
	CS2=`expr $CS1 + 1`			# 638
	CS3=`expr $CS2 + 1`			# 639

	echo "Targeted cpus: $CS0 $CS1 $CS2 $CS3"
	set -A cpu_arr `printf "%x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x" $CS0 $CS1 $CS2 $CS3 $CS0 $CS1 $CS2 $CS3 $CS0 $CS1 $CS2 $CS3 $CS0 $CS1 $CS2 $CS3`

	# Program the CPU binding for this MSI
	i=0
	while [ $i -lt $ino_cnt ] ; do
		$SUDO $PCITOOL $NEXUS -m ${ino_arr[$i]} -w ${cpu_arr[$i]}
		i=`expr $i + 1`
	done
	
	# Get the MSI list for this device 
	I=`expr $I + 1`
	echo Configuring intrs for ixgbe#${I}
	ino_cnt=`$SUDO $PCITOOL $NEXUS -i | grep -c ixgbe#${I}`
	set -A ino_arr `$SUDO $PCITOOL $NEXUS -i | grep ixgbe#${I} | sort +0.10 | awk '{print $3}'`

	echo "Targeted cpus: $CS0 $CS1 $CS2 $CS3"
	set -A cpu_arr `printf "%x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x" $CS0 $CS1 $CS2 $CS3 $CS0 $CS1 $CS2 $CS3 $CS0 $CS1 $CS2 $CS3 $CS0 $CS1 $CS2 $CS3`

	# Program the CPU binding for this MSI
	# Program the CPU binding for this MSI
	i=0
	while [ $i -lt $ino_cnt ] ; do
		$SUDO $PCITOOL $NEXUS -m ${ino_arr[$i]} -w ${cpu_arr[$i]}
		i=`expr $i + 1`
	done

	z=`expr $z + 1`
	CPU_START=`expr $CPU_START + $CPU_OFF`
done

