#!/bin/sh
#
# Create virtual switches
for SW in 2 3 4 5
do
	echo "Creating vsw${SW}"
	dladm create-etherstub vsw${SW}
done

#
# Create 3x VNICS for each virtual switch
# - 2x vnics for DBA access for each zone
# - 1x vnic for DB listeners
#
INST=31
for SW in 2 3 4 5
do
	echo "Creating VNICS for vsw${SW}"
	dladm create-vnic -l vsw${SW} lsnr${SW}v1
	dladm create-vnic -l vsw${SW} jent${INST}v2
	INST=`expr $INST + 1`
	dladm create-vnic -l vsw${SW} jent${INST}v2
	INST=`expr $INST + 1`
done

#
# Create 1x VNIC for each zone for driver access
#
INST=31
NIC_INST="14 15 16 17 22 23 18 19"

for I in $NIC_INST
do
	echo "Creating VNICS for ixgbe${I}"
	dladm create-vnic -l ixgbe${I} ixgbe${I}v1
done
