#!/bin/sh
#
#
SUDO=sudo

#
# For each CPU chip, allocate cpu strands as follows
#    0 - 115: 116 threads for applications
#  116 - 123: 8 threads for ixgbe fanout
#  124 - 127: 4 strands for ixgbe interrupts
#

CPU_START=640
CPU_START=`expr $CPU_START - 12`
CPU_ADD=7
CPU_END=`expr $CPU_START + $CPU_ADD`
CPU_OFF=128

# configure fanout thread cpu bindings
# for the physical & vnic devices
for I in 14 16 22 18
do
	echo "Setup ixgbe fanouts on cpus ${CPU_START}-${CPU_END}"
	$SUDO dladm set-linkprop -p cpus=${CPU_START}-${CPU_END} ixgbe${I}
	$SUDO dladm set-linkprop -p cpus=${CPU_START}-${CPU_END} ixgbe${I}v1
	I=`expr $I + 1`
	$SUDO dladm set-linkprop -p cpus=${CPU_START}-${CPU_END} ixgbe${I}
	$SUDO dladm set-linkprop -p cpus=${CPU_START}-${CPU_END} ixgbe${I}v1
	CPU_START=`expr $CPU_START + $CPU_OFF`
	CPU_END=`expr $CPU_START + $CPU_ADD`
done

CPU_START=640
CPU_START=`expr $CPU_START - 12`
CPU_ADD=7
CPU_END=`expr $CPU_START + $CPU_ADD`
CPU_OFF=128
for I in 31 33 35 37
do
	echo "Setup jent${I} VNIC fanouts on cpus ${CPU_START}-${CPU_END}"
	$SUDO dladm set-linkprop -p cpus=${CPU_START}-${CPU_END} jent${I}v2
	I=`expr $I + 1`
	$SUDO dladm set-linkprop -p cpus=${CPU_START}-${CPU_END} jent${I}v2
	CPU_START=`expr $CPU_START + $CPU_OFF`
	CPU_END=`expr $CPU_START + $CPU_ADD`
done

CPU_START=512
CPU_START=`expr $CPU_START - 12`
CPU_ADD=7
CPU_END=`expr $CPU_START + $CPU_ADD`

# configure fanout thread cpu bindings for jdata/ixgbe6
for I in 6
do
	echo "Setup ixgbe fanouts on cpus ${CPU_START}-${CPU_END}"
	$SUDO dladm set-linkprop -p cpus=${CPU_START}-${CPU_END} ixgbe${I}
	$SUDO dladm set-linkprop -p cpus=${CPU_START}-${CPU_END} ixgbe${I}v1
done

#
# fanouts for lsnr VNICs in pool_jdata
CPU_START=120
CPU_ADD=7
CPU_END=`expr $CPU_START + $CPU_ADD`
CPU_OFF=128
for I in 2 3 4 5
do
	echo "Setup lsnr${I}v1 VNIC fanouts on cpus ${CPU_START}-${CPU_END}"
	$SUDO dladm set-linkprop -p cpus=${CPU_START}-${CPU_END} lsnr${I}v1
        CPU_START=`expr $CPU_START + $CPU_OFF`
        CPU_END=`expr $CPU_START + $CPU_ADD`
done

