/*++

     Copyright (c) 1998 Microsoft Corporation

     Spec Web 99 ISAPI and ASP components implementation      

     Module Name:
         specweb.cxx

     Main code

--*/

#include "define.h"
#include "frootad.hxx"
#include "isapireq.hxx"
#include "logfile.hxx"
#include "spinlock.hxx"





/*---------------------------------------------------------------------*
Functions Prototypes

*/

// The 3 ISAPI functions
BOOL	_stdcall	GetExtensionVersion(HSE_VERSION_INFO *);
BOOL	_stdcall	TerminateExtension(DWORD);
DWORD	_stdcall	HttpExtensionProc(EXTENSION_CONTROL_BLOCK *);

/*---------------------------------------------------------------------*
Globals
*/

//File names

char userFile[] = "User.Personality";  
char customFile[] = "Custom.Ads";
char logFile[] = "PostLog";
char rootDir[] = "d:\\spec99\\";

char userFileName[128];
char customFileName[128];
char logFileName[128];

	// for log thread
HANDLE  hLogThread;
int		dwThreadPara = 20;
DWORD   dwThreadId;
int		sleepTime = 60000;
extern  struct _logInfo logInfo;
bool	logInfoReady;
SpinLock slResetLock;

RootAd* pRootAd = NULL;

static DWORD InitializationError = 0;
extern Constant_Vars constantVars;



/*---------------------------------------------------------------------*
Initialize

*/

BOOL InitializeSpecWeb()
{
	// Initialize Constant Variables

	constantVars.init = UNINIT;

    return TRUE;
}

/*---------------------------------------------------------------------*
Uninitialize

*/

void UninitializeSpecWeb()
{
	// Clean up user file and custom file
	if ( pRootAd != NULL) {
		delete pRootAd;
        pRootAd = NULL;
    }

	// free data buffer stack
	ClearDataStack();

	// Free ISAPI stack 
	ClearISAPIStack();

	// Flush log buffer and close log file
    CleanupDefaultLog();

}

/*---------------------------------------------------------------------*
initFileAndConstant(EXTENSION_CONTROL_BLOCK *ecb)
*/

DWORD initFileAndConstant(EXTENSION_CONTROL_BLOCK *ecb)
{

	
	// initialize constants: one-time cost
	if( UNINIT == (long) InterlockedCompareExchangePrivate((long *) &(constantVars.init), 
                                INITING, UNINIT))
	{
		
		DWORD size = sizeof(constantVars.serverSoftware);
		if (!(ecb->GetServerVariable)(
					ecb->ConnID,
					"SERVER_SOFTWARE",
					constantVars.serverSoftware,
					&size
					)
			) {
			return HSE_STATUS_ERROR;
		}

        constantVars.serverSoftLen = strlen(constantVars.serverSoftware);

		size = sizeof(constantVars.scriptName);

		if (!(ecb->GetServerVariable)(
					ecb->ConnID,
					"SCRIPT_NAME",
					constantVars.scriptName,
					&size
					)
			) {
			return HSE_STATUS_ERROR;
		}

        constantVars.scriptNameLen = strlen(constantVars.scriptName);

		// get root dir
		
		
		size = sizeof(constantVars.dirRoot);

		if (!(ecb->GetServerVariable)(
				ecb->ConnID,
				"PATH_TRANSLATED",
				constantVars.dirRoot,
				&size
				)
		   ) {
			return HSE_STATUS_ERROR;
		}

		// get user personality file path
		size = strlen(constantVars.dirRoot);
		memcpy(constantVars.dirRoot + size, "\\", 2);
		size++;

		memcpy(userFileName, constantVars.dirRoot, size);
		int nameLen = strlen(userFile) +1;
		memcpy(userFileName+size, userFile, nameLen);
		 
		// get custom ad file path
		
		memcpy(customFileName, constantVars.dirRoot, size);
		nameLen = strlen(customFile) +1;
		memcpy(customFileName+size, customFile, nameLen);
		 
		// get log file path

		memcpy(logFileName, constantVars.dirRoot, size);
		nameLen = strlen(logFile) +1;
		memcpy(logFileName+size, logFile, nameLen);

			
		// clear rootad buffer

		if ( pRootAd != NULL) {
			delete pRootAd;
			pRootAd = NULL;
		}
		
		// open User personality file and Custom Ad file
		
		pRootAd = new RootAd();

		if (pRootAd == NULL) {
			InitializationError = ERROR_NOT_ENOUGH_MEMORY;
			return HSE_STATUS_ERROR;
		}

		if( ! (pRootAd->initialize(userFileName, customFileName)))
		{
			InitializationError = ERROR_NOT_ENOUGH_MEMORY;
			return HSE_STATUS_ERROR;
		}
		
		// try to get slResetLock

		AcquireSpinLock((SpinLock*)&(slResetLock));

		logInfoReady = FALSE;

		CleanupDefaultLog();

		InitDefaultLog(logFileName);

		//set logInfoReady to TRUE to tell the flushing thread  to do flushing

		logInfoReady = TRUE;

		ReleaseSpinLock((SpinLock*)&(slResetLock));
		

		// initialization has doneInter, set status to DONEINIT
		InterlockedCompareExchangePrivate((long *) &(constantVars.init), DONEINIT, INITING);
	
	}

	while( INITING == constantVars.init)
	{
		Sleep(100);
	}

	return HSE_STATUS_SUCCESS;
	
}

/*---------------------------------------------------------------------*
	DWORD WINAPI  flushLogProc(LPVOID lpvPara)  \\FlushCachedData
	This thread proc does flushing postlog file every one second.
  
*/

DWORD WINAPI  flushLogProc(LPVOID lpvPara)
{
	//Flush cached data to postlog every second
	while(1)
	{
		AcquireSpinLock((SpinLock*)&(slResetLock));
		if(logInfoReady)
		{
			if( STATUS_ERROR == FlushCachedData())
			{
				ReleaseSpinLock((SpinLock*)&(slResetLock));
				break;    // may not need to break
			}
		}
		ReleaseSpinLock((SpinLock*)&(slResetLock));
	
		Sleep(sleepTime);
	}
	return(HSE_STATUS_ERROR);  //HSE_STATUS_ERROR;
}

/*---------------------------------------------------------------------*
GetExtensionVersion

*/

BOOL __stdcall GetExtensionVersion(HSE_VERSION_INFO *extver) 
{
    if (InitializationError != 0) {
        SetLastError(InitializationError);
        return FALSE;
    }

	InitSpinLock((SpinLock*)&(slResetLock));

	logInfoReady = FALSE;

	extver->dwExtensionVersion = MAKELONG(HSE_VERSION_MAJOR, HSE_VERSION_MINOR);
	strcpy(extver->lpszExtensionDesc, "SPECWeb99 Dynamic API 1.0");

	hLogThread = CreateThread(NULL,0,flushLogProc,(LPVOID)&dwThreadPara,
					0,&dwThreadId);

	CloseHandle(hLogThread);

	return InitializeSpecWeb();

	

}

/*---------------------------------------------------------------------*
TerminateExtension

*/

BOOL __stdcall TerminateExtension(DWORD flag) 
{
	UninitializeSpecWeb();

	TerminateThread( hLogThread, dwThreadPara);

	return TRUE;
}

/*---------------------------------------------------------------------*
HttpExtensionProc

*/

DWORD __stdcall HttpExtensionProc(EXTENSION_CONTROL_BLOCK *ecb) 
{
    DWORD reqStatus;
	PISAPIRequest thisRequest;

	// Initiliaze constant variables such as
	// SERVER_SOFTWARE and SCRIPT_NAME
	
	if ( DONEINIT != constantVars.init) {
		
		if( HSE_STATUS_ERROR == initFileAndConstant(ecb))
		{
			// set init status back to NUINIT
			InterlockedCompareExchangePrivate((long *) &(constantVars.init), UNINIT, INITING);
			reqStatus = HSE_STATUS_ERROR;
		}

		reqStatus = HSE_STATUS_SUCCESS;
	}

    //
    // Pop a request structure off our stack
    //

    thisRequest = AllocISAPIRequest();

    // If we managed to get a request structure
    // then initialise it. If all succeeds, go
    // ahead and try to execute the request
    //

    if (reqStatus != HSE_STATUS_ERROR && 
		thisRequest && (InitRequest(thisRequest, ecb) == TRUE))
    {
        reqStatus = ExecuteRequest(thisRequest);
    }

    //
    // We failed. Let the client know this.
    //
 
    else {
        // request initialization error

        // send 414 header
	    (*ecb->ServerSupportFunction)(
		        ecb->ConnID,
		        HSE_REQ_SEND_RESPONSE_HEADER,
		        "414 ISAPI Initing Request Error",
		        NULL,
		        (LPDWORD)"Content-Type: text/html\r\n\r\n"
		        );

        // send error body
        static char InitializationError[] = 
                        "<html><body>\r\n"
                        "<h1>Server Error</h1>\r\n"
                        "<p>Failed to initialize Request object\r\n"
                        "</body></html>";

    	DWORD bytes = sizeof(InitializationError)-1;
    	(*ecb->WriteClient)(
	    	    ecb->ConnID,
		        (LPVOID)InitializationError,
		        (LPDWORD)&bytes,
		        0
		        );

	    reqStatus = HSE_STATUS_ERROR;
    }

    // cleanup
    if (reqStatus != HSE_STATUS_PENDING && thisRequest) {
        FreeISAPIRequest(thisRequest);
    }

    return reqStatus;
}
