#ifndef _NET_HTTP_U_H
#define _NET_HTTP_U_H

/*
 * TUX - Integrated HTTP layer and Object Cache
 *
 * Copyright (C) 2000, Ingo Molnar <mingo@redhat.com>
 *
 * tux_u.h: HTTP module API - HTTP interface to user-space
 */

/*
 * Different major versions are not compatible.
 * Different minor versions are only downward compatible.
 * Different patchlevel versions are downward and upward compatible.
 */
#define TUX_MAJOR_VERSION		1
#define TUX_MINOR_VERSION		0
#define TUX_PATCHLEVEL_VERSION		0

#define __KERNEL_SYSCALLS__

typedef enum http_versions {
        HTTP_1_0,
        HTTP_1_1
} http_version_t;

/*
 * Request methods known to HTTP:
 */
typedef enum http_methods {
        METHOD_NONE,
        METHOD_GET,
        METHOD_HEAD,
        METHOD_POST,
        METHOD_PUT
} http_method_t;

enum user_req {
	TUX_ACTION_STARTUP = 1,
	TUX_ACTION_SHUTDOWN = 2,
	TUX_ACTION_STARTTHREAD = 3,
	TUX_ACTION_STOPTHREAD = 4,
	TUX_ACTION_EVENTLOOP = 5,
	TUX_ACTION_GET_OBJECT = 6,
	TUX_ACTION_SEND_OBJECT = 7,
	TUX_ACTION_READ_OBJECT = 8,
	TUX_ACTION_FINISH_REQ = 9,
	TUX_ACTION_REGISTER_MODULE = 10,
	TUX_ACTION_UNREGISTER_MODULE = 11,
	TUX_ACTION_CURRENT_DATE = 12,
	TUX_ACTION_REGISTER_MIMETYPE = 13,
	MAX_TUX_ACTION
};

enum http_ret {
	TUX_RETURN_USERSPACE_REQUEST = 0,
	TUX_RETURN_EXIT = 1,
	TUX_RETURN_SIGNAL = 2,
};

#define MAX_MODULENAME_LEN 16
#define MAX_URI_LEN 256
#define MAX_POST_DATA 1024
#define MAX_COOKIE_LEN 128
#define DATE_LEN 30

typedef struct user_req_s {
	int version_major;
	int version_minor;
	int version_patch;

	int http_version;
	int http_method;
	int sock;
	int bytes_sent;
	int http_status;
	unsigned int client_host;
	unsigned int objectlen;
	char query[MAX_URI_LEN];
	char *object_addr;
	char objectname[MAX_URI_LEN];
	int module_index;
	char modulename[MAX_MODULENAME_LEN];
	char post_data[MAX_POST_DATA];
	char new_date[DATE_LEN];

	int cookies_len;
	char cookies[MAX_COOKIE_LEN];

	int event;
	int thread_nr;
	void *id;
	void *private;
} user_req_t;

#endif
