/*****************************************************************************
 *                                                                           *
 * COPYRIGHT (c) COMPAQ COMPUTER CORPORATION, 1998                           *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of Compaq Computer Corporation not be used in advertising   *
 * or publicity  pertaining to  distribution of  the document or  software   *
 * without specific, written prior permission.                               *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED "AS IS" AND COMPAQ COMPUTER CORP. DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  COMPAQ  COMPUTER *
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL *
 * DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR *
 * PROFITS, WHETHER  IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS *
 * ACTION, ARISING OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF *
 * THIS SOFTWARE.                                                            *
 *                                                                           *
 *****************************************************************************/


#define INCLUDE_FILES 1
#define CAD_SCAN 1
#define CACHE_USER 1 


#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/file.h>       /* CMC */
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
/* Zeus includes */
#include "wintypes.h"       /* CMC */
#include <unistd.h>
#include "httpext.h"	    /* CMC */	


#define BOILERPLATE_START  "<html>\n<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n<body>\n<p>SERVER_SOFTWARE = %s\n<p>REMOTE_ADDR = %s\n<p>SCRIPT_NAME = %s\n<p>QUERY_STRING = %s\n<pre>\n"

#define BOILERPLATE_END "\n</pre>\n</body></html>\n"

#define BUFLEN 128*1024*10
#define INBUF_INITIAL_LEN 256
#define ERROR_NO_DOC_TOP "Can't find top of document tree, please configure value CGI script manually.\n"


#define DEFAULT_TOP_DIR "/htdocs"	/* SMB */
#define DEFAULT_TOP_DIR_LEN strlen(DEFAULT_TOP_DIR)
#define POST_LOG_DIR "/htdocs"		/* SMB */
#define DEFAULT_URL_ROOT "/htdocs"	/* SMB */

#define TRUE 1
#define FALSE 0

#define SEND_SIZE 8192

#define CUSTOM_AD_FILE "Custom.Ads"
#define CUSTOM_AD_RECLEN 39
#define CUSTOM_AD_CREATE "cadgen99"
#define MAX_ADS 360
#define PATH_MAX 256

#define USER_PERS_FILE "User.Personality"
#define USER_PERS_RECLEN 15
#define USER_PERS_CREATE "upfgen99"


#define CUSTOM_AD 0
#define USER_PERS 1

#define GENDER_MASK	0x40000000
#define AGE_MASK	0x0f000000
#define REGION_MASK	0x00f00000
#define INTEREST1_MASK	0x000ffc00
#define INTEREST2_MASK	0x000004ff




enum ReqTypes { GET, POST, RESET, FETCH, TEST, ROOT };


/* Structure to keep parsed inputs from POST */
typedef struct _post_struct_t {
  int Dir;
  int Class;
  int Num;
  int Client;
  int Cookie;
} post_struct_t;

typedef  struct _ad_struct_t {
  int Dems;
  int GenWt;
  int AgeWt;
  int RegWt;
  int Int1Wt;
  int Int2Wt;
  int Expire;
  int MinimumMatchWeight;
} ad_struct_t;

/* Structure containing all the static variables (except for Inited and the
   few in DebugLog.  The use of this structure in this program is not 
   thread safe
   */
typedef struct _spec_data_t {
  char *Buffer;			/* Buffer for all return data */
  int BufCurLen;		/* Current length of characters in Buffer */
  char *Inbuf;			/* Buffer for taking POST input */
  int InbufLen;			/* Length of Inbuf */
  /* Filled in during Initialize -- the same for all requests */
  char ServerSoftware[128];	/* Name of server software */
  char ScriptName[128];		/* Name of script */
  char TopDir[PATH_MAX];	/* Top directory */
  char SpecUrlRoot[PATH_MAX];   /* SPEC URL Root directory (including TopDir) */
  char *URLFileNameStart;	/* Pointer to location in SpecUrlRoot where file
				   name begins */
  int LenTopDir;		/* strlen of TopDir */
  char FileName[PATH_MAX];	/* FileName for GET and POST to return */
  char LogFile[PATH_MAX];	/* Log file */
  int Pid;			/* Process ID */
  int LastAdReadTime;		/* Last timestamp of CustomAd file read in */
  ad_struct_t Ads[MAX_ADS];	/* Space for Custom Ads */
#ifdef CACHE_USER
  int *UDemog;			/* Place to malloc User Demographics */
#else
  FILE *UserDemFd;		/* File descriptor for User Demographics file */
#endif
  char RemoteAddr[128];		/* address of client making request */
  char *QueryString;		/* Query -- excluding GET/POST/... part */
  char *QueryMethod;		/* see enumerated type ReqTypes */
  char CookieStr[64];		/* Cookie string -- NULL if none sent */
#ifdef CAD_SCAN
  char CadStr[32];
#endif
  
  /* Filled in for every request */
} spec_data_t;
  


#ifdef INCLUDE_FILES
int IncludeFiles(char *Name, char *FileLocchar,char  *Text);
#endif




int CustomAdRotation(spec_data_t *pContext, char *Buf);
void DoOutput(char *Buf, int Len);
int DoPost( spec_data_t *pContext, char *Buf);
int DoReset(char *ResetString, spec_data_t *pContext, char *Buf);
int DoTest ( char *LogFile, char *Buf );
int ReadCustomData(char *Path, ad_struct_t *AdPtr, int *UserDems, int DataType);
int ReadFileIntoBuffer(char *FileName, char *Buf, int BufSize);
int RunProgram(char *Path, ...);
int WriteLog (spec_data_t *pContext, post_struct_t *pPost, char *File);
void DebugLog (char *Format, ...);



typedef void *WebInputs_t;


void GetPostData(WebInputs_t *WebInputs, spec_data_t *pContext);
int GetQuery(WebInputs_t *WebInputs, spec_data_t *pContext);
int Initialize (WebInputs_t *WebInputs, spec_data_t *pContext);
int ReturnPostLog(char *LogFile, char *HtmlStart,WebInputs_t *WebInputs);
int FinishHtmlAndSendBuffer(WebInputs_t *WebInputs,spec_data_t *pContext);
 
int REREAD=0;

/*+***************************************************************************
Examples of how to do GETs and POSTS


GET /specweb99/isapi/specweb99-zisapi.so?/specweb99/file_set/dir00000/class0_0 HTTP/1.1
Cookie: my_cookie=user_id=10001&last_ad=23

POST /specweb99/isapi/specweb99-newzisapi.so HTTP/1.1
Cookie: my_cookie=10001
Host: bbb116
Content-Length: 61

urlroot=/specweb99/file_set/&dir=00000&class=0&num=0&client=1


****************************************************************************/

/*+***************************************************************************

$Revision: 1.2 $

****************************************************************************/




/* 
 * FUNCTION:	DWORD WINAPI HttpExtensionProc(EXTENSION_CONTROL_BLOCK *pEcb)
 *
 * PURPOSE:	ISAPI call that gets executed for every client request to
 *		this library.  This is ISAPI's equivalent to main().
 *
 * ARGUMENTS:	EXTENSION_CONTROL_BLOCK  *pEcb  
 *					passed in structure with variables
 *					and function pointers
 *
 * RETURNS:	HSE_STATUS_SUCCESS, HSE_STATUS_ERROR
 *
 * COMMENTS:	For more info on ISAPI coding refer to
 *		http://www.microsoft.com/WIN32DEV/APIEXT/ISAPIMRG.HTM
 *
 */



DWORD WINAPI
HttpExtensionProc (EXTENSION_CONTROL_BLOCK *pEcb) {

  WebInputs_t *WebInputs = (WebInputs_t *) pEcb;

  static int Inited = FALSE;
  static spec_data_t Context, *pContext;

  char Header[128];
  int HeaderLen;
  const char HeaderFormat[] = "Content-Type: text/html\nContent-Length: %d\n\n";

  int Request;		/* Type of request (i.e. GET, POST, FETCH, etc. */

  char Content_Length[16];
  int BufLen;

  int RetVal;
  int EndLen;

  char TempBuf[128];

#ifdef INCLUDE_FILES
  char *FileStart;
#endif

  /* Assign some handy pointers*/
  pContext = &Context;

  pContext->BufCurLen = 0;


 
  /* If 1st time through, set up the "static" variables kept in the 
     Context structure */
  if (!Inited) {
    if (-1 == Initialize(WebInputs, pContext)) {
      return FinishHtmlAndSendBuffer(WebInputs, pContext);
    }
    else
      Inited = TRUE;
  }
 
  GetQuery(WebInputs, pContext);

   /* Make the start of the Html page */

  pContext->BufCurLen += sprintf(&pContext->Buffer[pContext->BufCurLen], 
BOILERPLATE_START, pContext->ServerSoftware, pContext->RemoteAddr, 
pContext->ScriptName, pContext->QueryString);

  /* Parse the command */
  if (!strncmp("GET", pContext->QueryMethod, 3)) {
    if ('\0' == pContext->QueryString[0]) {
      pContext->BufCurLen += sprintf(&pContext->Buffer[pContext->BufCurLen], 
				     "No query string was set\n");
      return FinishHtmlAndSendBuffer(WebInputs, pContext);
    }
    /* See if it's not a command */
    else if (strncmp("command/", pContext->QueryString, 8)) {
      Request = GET;

      strcpy(&pContext->FileName[pContext->LenTopDir], pContext->QueryString);

#ifdef INCLUDE_FILES
      FileStart = &pContext->Buffer[pContext->BufCurLen];
#endif


      pContext->BufCurLen += 
	ReadFileIntoBuffer(pContext->FileName, 
			   &pContext->Buffer[pContext->BufCurLen], 
				BUFLEN - pContext->BufCurLen);

      if ( '\0' != pContext->CookieStr[0] ) {
	pContext->BufCurLen += 
	  CustomAdRotation(pContext, &pContext->Buffer[pContext->BufCurLen]);
#ifdef INCLUDE_FILES
#ifdef CAD_SCAN
	if ( strcmp (pContext->FileName, "class1") != NULL || strcmp (pContext->FileName, "class2"  != NULL ) ) {

	if (-1 == IncludeFiles(pContext->CadStr, pContext->URLFileNameStart,
			       FileStart))
#else
	if (-1 == IncludeFiles(pContext->SpecUrlRoot, pContext->URLFileNameStart,
			       FileStart))
	  
#endif
	  pContext->BufCurLen+= sprintf(&pContext->Buffer[pContext->BufCurLen],
			      "Error in Include Files routine\n");
        }
#endif
      }

      return FinishHtmlAndSendBuffer(WebInputs, pContext);
	

    }

    /* We've already determined that it's "command/" */
    else if (!strncmp (&pContext->QueryString[8], "Reset", 5) ) {
      Request = RESET;
      pContext->BufCurLen += DoReset(&pContext->QueryString[14], pContext, 
		     &pContext->Buffer[pContext->BufCurLen]);
      return FinishHtmlAndSendBuffer(WebInputs, pContext);
    }
    else if (!strncmp (&pContext->QueryString[8], "Fetch", 5) ) {
      Request = FETCH;
      return (ReturnPostLog (pContext->LogFile, pContext->Buffer, WebInputs));

    }
  } /* End of it's a GET */


  else if (!strncmp("POST", pContext->QueryMethod, 4)) {
    Request = POST;
    
    GetPostData(WebInputs, pContext);


    if (0 == DoPost(pContext, &pContext->Buffer[pContext->BufCurLen])) {
      pContext->BufCurLen += 
	ReadFileIntoBuffer(pContext->FileName, 
			   &pContext->Buffer[pContext->BufCurLen], 
			   BUFLEN - pContext->BufCurLen);
      
    }
    return FinishHtmlAndSendBuffer(WebInputs, pContext);
  }
}


/* 
 * FUNCTION:	int CustomAdRotation(spec_data_t *pContext, char *Buf);
 *
 * PURPOSE:	Implements the custom ad rotation scheme.  In this scheme
 *		the cookie from the current request is matched against
 *		cookies in last 30 seconds of the post log, returning
 *		the number of matches found.
 *		
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		char       *Buf         Buffer for strings to return to client
 *		int	   Cookie       Cookie to search for
 *              int        *pFound      place to record # of found matches
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	If everthing works, nothing is ever written to Buf.  It
 *		is only there for returning error strings.
 */

int 
CustomAdRotation( spec_data_t *pContext, char *Buf) {

  int Desc;
  int Ts;
  int CurrTime;
  int BytesRead;
  int StartRead;
  int RecsPerSec;

  int RecsToRead;
  int StartRec;
  char *pRec;

  FILE *Fd;
  char FileName[PATH_MAX];
  struct stat FStats;
  int UserCt;
  int MyUserId;
  int LastAd;
  char *Ptr;
  int AdIndex;
  int ComboDemog;
  int Weight;
  int Expire;
#ifndef CACHE_USER
  int UDemog;
  char TempBuf[256];
#endif

  if (REREAD){
     system("/bin/touch /htdocs/User.Personality");
     REREAD=0;
     }

  /* Check to see if there's a new User.Personality file */
  sprintf(FileName, "%s/%s", pContext->TopDir, USER_PERS_FILE);
  if (-1 == stat( FileName, &FStats) ) {
    return sprintf(Buf, "Error stating %s: %s", FileName, strerror(errno));
  }

  if (FStats.st_mtime > pContext->LastAdReadTime) {

    pContext->LastAdReadTime = FStats.st_mtime;


    /* Get User Personality data - but first malloc a structure to hold it*/
#ifdef CACHE_USER
    UserCt = FStats.st_size / USER_PERS_RECLEN;
    if (0 == (pContext->UDemog = 
	      (int *)realloc(pContext->UDemog, UserCt * sizeof(int)))) {
      return sprintf(Buf, "Error re-allocing UDemog: %s", strerror(errno));
    }
    if (-1 == ReadCustomData(FileName, 0, pContext->UDemog, USER_PERS)) {
      return sprintf(Buf, "Error reading user pers. data: %s", strerror(errno));
    }

#ifdef DEBUG
    DebugLog("FLen = %d, UserCt = %d, StructSize = %d\n",
	     FStats.st_size, UserCt, sizeof(*pContext->UDemog));
#endif
#endif /* ifdef CACHE_USER */

    /* Get Custom Ad data */
    sprintf(FileName, "%s/%s", pContext->TopDir, CUSTOM_AD_FILE);
    if (-1 == ReadCustomData(FileName, pContext->Ads, 0, CUSTOM_AD)) {
      return sprintf(Buf, "Error in ReadCustomAds: %s", strerror(errno));
    }

  }

  
  /* Parse the incoming Cookie data */
  /* Format of input: user_id=<x>&last_ad=<y> */
  MyUserId = strtol(pContext->CookieStr + 8, &Ptr, 10) - 10000;
  LastAd = atol(Ptr + 9);

  /* Find the user profile */
#ifndef CACHE_USER
  if (-1 == fseek(pContext->UserDemFd, MyUserId * 15, SEEK_SET)) {
    return sprintf(Buf, "Couldn't fseek in User.Personality: %s",
		   strerror(errno));
  }
  if (-1 == fread(TempBuf, 15, 1, pContext->UserDemFd)) {
    return sprintf(Buf, "Couldnt fread UserId: %s",
		   strerror(errno));
  }
  /* The space after the id should stop the atoi at the right place */
  if (MyUserId != atoi(TempBuf)) {
    return sprintf(Buf, "Input Id %d != User Id %d from file",
		   MyUserId, atoi(TempBuf));
  }
  UDemog = strtoul(&TempBuf[6], (char **)NULL, 16);
#endif
  AdIndex = LastAd + 1;
  
  for (AdIndex = LastAd + 1; AdIndex != LastAd; AdIndex ++) {
    if (MAX_ADS <= AdIndex)
      AdIndex = 0;
    Weight = 0;
#ifdef CACHE_USER
    ComboDemog = pContext->UDemog[MyUserId] & pContext->Ads[AdIndex].Dems;
#else
    ComboDemog = UDemog & pContext->Ads[AdIndex].Dems;
#endif
    if (ComboDemog & GENDER_MASK) 
      Weight += pContext->Ads[AdIndex].GenWt;
    if (ComboDemog & AGE_MASK) 
      Weight += pContext->Ads[AdIndex].AgeWt;
    if (ComboDemog & REGION_MASK) 
      Weight += pContext->Ads[AdIndex].RegWt;
    if (ComboDemog & INTEREST1_MASK) 
      Weight += pContext->Ads[AdIndex].Int1Wt;
    if (ComboDemog & INTEREST2_MASK) 
      Weight += pContext->Ads[AdIndex].Int2Wt;
    if (Weight >= pContext->Ads[AdIndex].MinimumMatchWeight)
      break;
  }

  CurrTime = time(NULL);  
  if (CurrTime > pContext->Ads[AdIndex].Expire)
	Expire = 1;
  else
	Expire = 0;
    
#ifdef DEBUG
  DebugLog("CAD Cookie in = %s\n", pContext->CookieStr);
#endif

  sprintf(pContext->CookieStr, "found_cookie=Ad_id=%d&Ad_weight=%d&Expired=%d",
	  AdIndex,Weight,Expire);
#ifdef CAD_SCAN
  sprintf(pContext->CadStr, "/file_set/dir%05d/class%d_%d", 
	  AdIndex / 36, ((AdIndex % 36) / 9), AdIndex % 9);
#endif
#ifdef DEBUG
  DebugLog("Cookie out = %s\n", pContext->CookieStr);
#endif
  return 0;
}

#ifdef DEBUG
/* 
 * FUNCTION:	void DebugLog (char *Format, ...) 
 *
 * PURPOSE:	Writes debug records to a log file
 *
 * ARGUMENTS:	same as printf
 *
 * RETURNS:	None.
 *
 * COMMENTS:	Log file name is <top_dir>/weblog_<pid>
 *
 */

void
DebugLog (char *Format, ...) {

  static FILE *LogFd = 0 ;
  static char Buf[2048];
  va_list VarArgs;

  if (LogFd == 0 ) {
    char FileName[256];
    sprintf(FileName, "%s/weblog_%d", DEFAULT_TOP_DIR, getpid());
    LogFd = fopen(FileName, "w");
  }
  /* Expand the format string and arg uments */
  if( NULL != Format ) {
    va_start( VarArgs , Format);
    vfprintf( LogFd, Format, VarArgs );
    va_end( VarArgs );
    fflush(LogFd);
  }
  
}

#endif

/* 
 * FUNCTION:	int DoPost( spec_data_t *pContext, char *Buf)
int DoPost( spec_data_t *pContext, char *Buf);
 *
 * PURPOSE:	Implement dynamic POST.  Parses the input data, fetches
 *		the file requested, into the buffer then writes the logfile.
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		char       *Buf         Buffer for strings to return to client
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	None.
 *		
 */

int
DoPost( spec_data_t *pContext, char *Buf) {

  char UrlRoot[PATH_MAX];
  post_struct_t PostData;
  int Error = 0;
  char *pChar, *pCmd, *Ptr;
  int done;


  pChar = pCmd = pContext->Inbuf;
  Error = 5;
  done = 0;


  /* Parse the incoming Cookie data to get my_cookie   */
  /* value (user_id) to return with Set-cookie         */
  /* Format of input: user_id=<x>&last_ad=<y>          */
  PostData.Cookie = strtol(pContext->CookieStr + 8, &Ptr, 10);


  sprintf(pContext->CookieStr, "my_cookie=%d", PostData.Cookie);
#ifdef DEBUG
  DebugLog("Forming PostData.Cookie: CookieStr = %s, Cookie = %d\n",
	   pContext->CookieStr, PostData.Cookie);
#endif


  while( !done) {
    if ('&' == *pChar  || 0 == *pChar) {
      if (!strncmp(pCmd, "urlroot=", 8)) {      
	strncpy(UrlRoot, pCmd+8, pChar - (pCmd+8));
	UrlRoot[pChar - (pCmd+8)] = '\0';
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "dir=", 4)) {
	PostData.Dir = atoi(pCmd + 4);
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "class=", 6)) {
	PostData.Class = atoi(pCmd + 6);
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "num=", 4)) {
	PostData.Num = atoi(pCmd + 4);
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "client=", 7)) {
	PostData.Client = atoi(pCmd + 7);
	pCmd = pChar + 1;
	Error--;
      }
    }
    if (0 == *pChar) 
      done = 1;
    else
      pChar++;
  }
  if (Error) {
    pContext->BufCurLen += 
      sprintf (Buf, "Incorrect POST Input: '%s', UrlRoot = %s,dir='%d',"
	       " class='%d', num='%d', client='%d', #input=%d\n",
	       pContext->Inbuf, UrlRoot, PostData.Dir, PostData.Class, 
	       PostData.Num, 
	       PostData.Client, Error);
    return -1;
  }
  
  sprintf(pContext->FileName, "%s%sdir%05d/class%d_%d", pContext->TopDir, 
	  UrlRoot, PostData.Dir,
	  PostData.Class, PostData.Num);
  
  
  if (WriteLog(pContext, &PostData, pContext->FileName) == -1) {
    pContext->BufCurLen += 
      sprintf(Buf, "Error writing log file '%s': %s\n", 
	      pContext->LogFile, strerror(errno));
    return -1;
  }

  return 0;
}


/* 
 * FUNCTION:	int DoReset(spec_data_t *pContext, char *Buf)
 *
 * PURPOSE:	Resets the post log to 0 records.  If no post.log exists
 *		creates a new one.
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		char       *Buf         Buffer for strings to return to client
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	If everthing works, nothing is ever written to Buf.  It
 *		is only there for returning error strings.
 */

int
DoReset( char *ResetString, spec_data_t *pContext, char *Buf) {
  /* Reset will truncate the file, we unlink and then open a new file with a
     count of 0.  */
  FILE *Fd;
  char ProgramPath[PATH_MAX];
  char *pStr;
  char *MaxLoadStr = NULL;
  char *PtTimeStr = NULL;
  char *ThreadStr = NULL;
  char *ExpiredStr  = NULL;
  char *ExpiredStr2 = NULL;
  char *RootStr = NULL;
  int ChildPid;
  int Status;
  char *Arg[10];
  int ArgCnt;
  int i;
  char cmd1[50], cmd2[50];   /* CMC */


  /* Place each ampersand separated argument into the Arg list */
  Arg[0] = ResetString;
  for (ArgCnt = 0, pStr = ResetString; *pStr != '\0'; pStr++) {
    if ('&' == *pStr) {
      *pStr = '\0';
      ArgCnt++;
      Arg[ArgCnt] = pStr + 1;
    } 
    else if ( ',' == *pStr) {
      *pStr = '\0';
      ArgCnt++;
      Arg[ArgCnt] = pStr + 1;
    }
  }
    
  /* Now find all the strings we expect and make sure they're all present */
  for (i = 0; i <= ArgCnt; i++) {
    if ( 0 != strstr(Arg[i], "maxload=")) {
      MaxLoadStr = Arg[i] + strlen("maxload=");
    }
    else if ( 0 != strstr(Arg[i], "pttime="))
      PtTimeStr = Arg[i] + strlen("pttime=");
    else if ( 0 != strstr(Arg[i], "maxthread="))
      ThreadStr = Arg[i] + strlen("maxthread=");
    else if ( 0 != strstr(Arg[i], "exp=")) {
      ExpiredStr = Arg[i] + strlen("exp=");
      ExpiredStr2 = Arg[i+1];
    }
    else if ( 0 != strstr(Arg[i], "urlroot=")) {
      /* Skip the '//servername/' part */
      RootStr = strstr(Arg[i], "//") + 2;
      RootStr = strchr(RootStr, '/') + 1;
      pContext->URLFileNameStart = pContext->SpecUrlRoot +
	sprintf(pContext->SpecUrlRoot, "%s/%s/", pContext->TopDir, RootStr);
    }
  }
  
  if (!PtTimeStr || !MaxLoadStr || !ThreadStr || !ExpiredStr || !RootStr) 
    return sprintf(Buf,
		   "Missing an arg: Found maxload=%s pttime=%s maxthread=%s exp=%s,%s, urlroot=%s",
		   MaxLoadStr, PtTimeStr, ThreadStr, ExpiredStr, 
		   ExpiredStr2, RootStr);

  sprintf(cmd1, "/htdocs/upfgen99 -C /htdocs -n %s -t %s", MaxLoadStr, ThreadStr);
  sprintf(cmd2, "/htdocs/cadgen99 -C /htdocs -e %s -t %s %s %s", PtTimeStr, ThreadStr, ExpiredStr, ExpiredStr2);
  
  system(cmd1);
  system(cmd2);
  REREAD=1; 
  unlink(pContext->LogFile);

  if ((Fd = fopen(pContext->LogFile, "w"))) {
    fprintf(Fd, "%10d\n", 0);
    fclose(Fd);
    /*    return 0; */
  }
  else {
    return sprintf(Buf, "Error creating log file %s: %s\n", pContext->LogFile,
		   strerror(errno));
    
  }

  return(sprintf(Buf, "UrlRoot saved as %s\n", pContext->SpecUrlRoot));
    
}
#ifdef INCLUDE_FILES
#ifndef CAD_SCAN
/* 
 * FUNCTION:	int IncludeFiles(char *Name, char *FileLoc, char *Text)
 *
 * PURPOSE:	Scans the Text buffer for WEB99_INC tags, gets the filename
 *		then "includes" the file into the Text buffer
 * ARGUMENTS:	char       *Name	Pointer to storage to make the 
 *					full filename with path -- it should
 *					already contain the path info
 *		char       *FileLoc     Pointer to place where the filename 
 *					starts in Name
 *		char	   *Text        Pointer to text buffer to search/include
 * RETURNS:	0 on success, -1 on error
 *
 * COMMENTS:	Name should be preloaded with the path to the file_set.
 *              The filenames inside the tag specify file_set and further.
 *		Sample tag:
 *		<WEB99_INC file=file_set/dir00000/class0_3 l=0409></WEB99_INC>
 *              The included file should be placed after the new-line following
 *		the end tag
 *		
 */
int 
IncludeFiles(char *Name, char *FileLoc, char *Text) {



  char *pInc, *pName;
  char matchStr[] = "<WEB99_INC file=";
  char endStr[] = " l=1234></WEB99_INC>\n";
  /*  char Name[PATH_MAX];*/
  int IncFd;

  pInc = Text;
  /* Scan through for tag for including files */
  while (NULL != (pInc = strstr(pInc, matchStr))) {
    pName = FileLoc;
    pInc += strlen(matchStr);

    while ( ' ' != (*(pName++) = *(pInc++))) ;
    *(--pName) = '\0';


    if (-1 == (IncFd = open(Name,O_RDONLY, 0))) {
      sprintf(Text, "Error opening include file %s: %s\n", Name, 
	      strerror(errno));
      return -1;
    }

    /* Read the include file into the Text buffer, starting after the
       WEB99_INC tag  */

    if (-1 == read(IncFd, pInc + strlen(endStr) - 1, INT_MAX)) {
      sprintf(Text, "Error reading file include file %s: %s\n", Name, 
	      strerror(errno));
      return -1;
    }
    
    close(IncFd);
  }
  return 0;
}
#else /* ifndef CAD_SCAN */

/* IncludeFiles -- CAD_SCAN variant
 * The text is scanned looking for the the WEB99CAD tag.  When found
 * the filename after IMG SRC= is replaced with the CadString.  CadString
 * is formed in the CustomAdRotation routine with values based on the
 * Ad_Id
 */
int 
IncludeFiles(char *CadString, char *unused1, char *Text) {

  char *pInc;
  char matchStr[] = "<!WEB99CAD><IMG SRC=\"/file_set/dirNNNNN/classX_Y\"><!/WEB99CAD>";
  int replace_len = sizeof("<!WEB99CAD><IMG SRC=\"") - 1;
  int len = strlen(CadString);

  pInc = Text;
  /* Scan through for tag for including files */
  while (NULL != (pInc = strstr(pInc, matchStr))) {
    pInc += replace_len;      
    memcpy(pInc, CadString, len );
    pInc += len;
  }
  return 0;
}
#endif /* ifndef CAD_SCAN */
#endif /* ifdef INCLUDE_FILES */

int
ReadCustomData( char *Path, ad_struct_t *AdPtr, int *UserDems, int DataType) {

  FILE *Fd;
  char Record[64];
  
  int RecCt;

  int Id;
  int Dem;
  int AdWt;
  int AdMatch;
  int Expiration;

  if (NULL == (Fd = fopen(Path, "r"))) {
    return -1;
  }

#ifdef DEBUG
  DebugLog("Reading %s file into memory\n", Path);
#endif

  RecCt = 0;
  while (0 != fgets(Record, 64, Fd) ) {
    switch (DataType) {
    case CUSTOM_AD:
      sscanf(Record, "%d %x %x %d %d", &Id, &Dem, &AdWt, &AdMatch, 
	     &Expiration);
      if (Id != RecCt) 
	return -1;
      AdPtr[Id].Dems = Dem;
      AdPtr[Id].GenWt  = (0x000f0000 & AdWt) >> 16;
      AdPtr[Id].AgeWt  = (0x0000f000 & AdWt) >> 12;
      AdPtr[Id].RegWt  = (0x00000f00 & AdWt) >> 8;
      AdPtr[Id].Int1Wt = (0x000000f0 & AdWt) >> 4;
      AdPtr[Id].Int2Wt = 0x0000000f & AdWt;
      AdPtr[Id].Expire = Expiration;
      AdPtr[Id].MinimumMatchWeight = AdMatch;
      break;
    case USER_PERS:
      sscanf(Record, "%d %x", &Id, &Dem);
      if (Id != RecCt)
	return -1;
      UserDems[Id] = Dem;
      break;
    }
    RecCt++;
  }
  fclose(Fd);
return 0;
}
    

/* 
 * FUNCTION:	int ReadFileIntoBuffer(char *FileNMame, char *Buf, 
 *			               int BufSize)
 *
 * PURPOSE:	Reads a file into the provided buffer.
 *
 * ARGUMENTS:	char	   *FileName    Name of file to get
 *		char       *Buf         Buffer for strings to return to client
 *		int	   BufSize      Size of input buffer
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	If the file is too big for the buffer an error is returned.
 *		
 */
int 
ReadFileIntoBuffer(char *FileName, char *Buf, int BufSize) {

  int Desc;
  int Len;
  struct stat Stat;

  if ( (Desc = open(FileName, O_RDONLY, NULL)) == -1)
    return sprintf(Buf, "Error opening file '%s': %s", FileName, 
		   strerror(errno));


  fstat (Desc, &Stat);

  if (Stat.st_size > BufSize)
    Len = sprintf(Buf, "File %s is too long for buffer\n", FileName);
  else
    Len = read (Desc, (void *) Buf, BufSize);
  close(Desc);
  Buf[Len] = '\0';
  return Len;
  
}

/* 
 * FUNCTION:	int RunProgram(char *Path, ...)
 *
 * PURPOSE:     Runs the specified program in a forked process. 
 *		Returns to the caller only after the other program finishes.
 *
 * ARGUMENTS:	char       *Path        Path of the program to run
 *		...			The same arguments that execv expects
 *
 * RETURNS:	0 if all goes well, -1 if it doesn't
 *
 * COMMENTS:	Zeus processes ignore (SIG_IGN) the signal SIGCHLD,
 *		so we turn it on momentarily to wait for the child
 *		to finish .
 *		
 */


int
RunProgram(char *Path, ...){
  va_list ap;
  char *Args[100];
  int argno = 0;
  
  int ChildPid;
  int Status;
  char Buf[400];

  if ( -1 == (ChildPid = fork())) {
    return -1;
  }

  if (0 == ChildPid) {
    int Ret;
    va_start(ap, Path);
    while ((Args[argno++] = va_arg(ap, char *)) != (char *) 0)
      ;
    va_end(ap);
    Ret = execv(Path, Args);

    /* If the execv works this return shouldn't get executed */
    return Ret;
  }
  else {
    int Ret;
    
    struct sigaction NewSa;
    struct sigaction OldSa;

    NewSa.sa_handler = SIG_DFL;
    /* NewSa.sa_mask = 0;	   CMC */
    NewSa.sa_flags = SA_RESETHAND;

    /* Need to enable SIGCHLD for this to work */
    sigaction(SIGCHLD, &NewSa, &OldSa);
    Ret = waitpid( ChildPid, &Status, 0);
    sigaction(SIGCHLD, &OldSa, &NewSa);

    if (Ret == -1) 
      return Ret;
    else
      return 0;
  }
}

  

/* 
 * FUNCTION:	int WriteLog(spec_data_t *pContext, post_struct_t *pPost,
 *			     int *File)
 *
 * PURPOSE:	Assembles the post data into a string and writes it to the
 *		end of the post log.  Increments the record count at the
 *		top of the log.
 *		
 *		
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		post_struct_t *pPost    Sturcture with parsed POST input
 *              char       *File	File accessed
 *
 * RETURNS:	Number of bytes written to post log (not including record count)
 *		or -1 if the write had an error
 *     
 *
 * COMMENTS:	The post log is locked during the file operations in order
 *		to keep the log consistent.
 *		
 */

int
WriteLog (spec_data_t *pContext, post_struct_t *pPost, char *File) {
  int Len;
  int Time;
  int Desc;
  int Locked=-1;
  char Tmp[PATH_MAX];
  char Count[11];

  if ((Desc = open (pContext->LogFile, O_RDWR)) == -1) 
    return -1;

  Time = time(NULL); 

  while (Locked < 0 )
     Locked = flock(Desc, LOCK_EX);

  /* Read the current count and increment it */
  read( Desc, (void *) Tmp, 10);
  Tmp[10] = '\0';
  sprintf(Count, "%10d", atoi(Tmp) + 1);
  lseek( Desc, 0, SEEK_SET);
  write( Desc, Count, 10);

  /* Go to the end of file, and add a POST record */
  lseek (Desc, 0, SEEK_END);
  Len = sprintf(Tmp, "%10d %10d %10d %5d %2d %2d %10d %-60.60s %10d %10d\n",
	  atoi(Count),  Time, pContext->Pid, pPost->Dir, pPost->Class, 
	  pPost->Num, pPost->Client, File, pContext->Pid, pPost->Cookie);
  Len = write(Desc, Tmp, Len);
  flock(Desc, LOCK_UN);
  close(Desc);
  return Len;

}



/* 
 * FUNCTION:	BOOL WINAPI GetExtensionVersion(HSE_VERSION_INFO *pVer)
 *
 * PURPOSE:	ISAPI call that gets executed once when the calling 
 *		process loads this library
 *
 * ARGUMENTS:	HSE_VERSION_INFO  *pVer  passed in structure for setting
 *					 version and description
 *
 * RETURNS:	TRUE
 *
 * COMMENTS:	For more info on ISAPI coding refer to
 *		http://www.microsoft.com/WIN32DEV/APIEXT/ISAPIMRG.HTM
 *
 */
BOOL WINAPI
GetExtensionVersion (HSE_VERSION_INFO *pVer) {
  pVer->dwExtensionVersion = HSE_VERSION_MAJOR;
  strcpy (pVer->lpszExtensionDesc, "SPECweb99 Dynamic GET & POST Test");

  return TRUE;
}




void
GetPostData(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;
  int BytesRead;
  int BytesToRead;

  /* Check if data is available already (it usually isn't) */
  if (pEcb->cbTotalBytes == pEcb->cbAvailable) {
    strncpy(pContext->Inbuf, (char *)pEcb->lpbData, pEcb->cbTotalBytes);
  }

  else {
    BytesRead = 0;
    BytesToRead = pEcb->cbTotalBytes;
    
    if (pEcb->cbTotalBytes >= pContext->InbufLen) {
      /* pContext->Inbuf = realloc(pEcb->cbTotalBytes);   CMC */
      realloc(pContext->Inbuf, pEcb->cbTotalBytes);
      pContext->InbufLen = pEcb->cbTotalBytes;
    }
    
    while (BytesRead != pEcb->cbTotalBytes) {
      pEcb->ReadClient(pEcb->ConnID, &pContext->Inbuf[BytesRead], 
		       &BytesToRead);
      
      BytesRead += BytesToRead;
      BytesToRead = pEcb->cbTotalBytes - BytesRead;
    }
    pContext->Inbuf[BytesRead] = '\0';
#ifdef DEBUG
    DebugLog("Inbuf = %s\n", pContext->Inbuf);
#endif
  }
}

int 
GetQuery(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;
  char OtherVars[256];
  char *pStr, *cStr;
  
  int BufLen;

  BufLen = 128;


  pEcb->GetServerVariable( pEcb->ConnID, "REMOTE_ADDR", pContext->RemoteAddr,
			   &BufLen);


  pContext->QueryString = (char *)pEcb->lpszQueryString;
  pContext->QueryMethod = (char *)pEcb->lpszMethod;

    /* Determine if there's a Cookie involved */
  BufLen = 256;
  pEcb->GetServerVariable( pEcb->ConnID, "ALL_HTTP", OtherVars,
			   &BufLen);

  pStr = strstr(OtherVars, "HTTP_COOKIE: ");
  cStr = pContext->CookieStr;
  if (NULL != pStr) {
    for ( pStr = pStr + 23; *pStr != '\n' && *pStr != '\0'; pStr++, cStr++)
      *cStr = *pStr;
  }
  *cStr = '\0';

#ifdef DEBUG
  DebugLog("Leaving GetQuery Query=%s, Meth=%s\n\t Cookie=%s, Addr=%s\n",
	   pContext->QueryString, pContext->QueryMethod, pContext->CookieStr,
	   pContext->RemoteAddr);
#endif
  return 0;
}

/* 
 * FUNCTION:	int Initialize(EXTENSTION_CONTROL_BLOCK *pEcb, 
 *              spec_data_t *pContext)
 *
 * PURPOSE:	Initializes the web_data structure using the inputs
 *              provided by Zeus in the pEcb structure.
 *		
 * ARGUMENTS:	EXTENSION_CONTROL_BLCOK
 *			   *pEcb	ISAPI structure contain "environment"
 *                                      variables and "methods" for getting/
 *                                      returning data.
 *		spec_data_t *pContext	Context structure
 * RETURNS:	0 on success, -1 on error
 *
 * COMMENTS:	
 *              
 *		
 */
int 
Initialize(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;

  int BufLen;
  char TempBuf[256];

  /* If we have a problem in initialization, we need to format an error 
     string -- this HTML header is enought */
  const char HtmlHeader[] = "<html>\n<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n<body>\n<pre>\n";



  pContext->Buffer = (void *)malloc(BUFLEN);
  if (0 == pContext->Buffer) {
    pContext->BufCurLen += 
      sprintf(&pContext->Buffer[pContext->BufCurLen], 
	      "%sCan't malloc Buffer of size %d: %s", HtmlHeader, BUFLEN, 
	      strerror(errno));
				   
  }  
  /* pEcb->GetServerVariable() is how you get environment variables */
  BufLen = sizeof(pContext->ServerSoftware);
  pEcb->GetServerVariable( pEcb->ConnID, "SERVER_SOFTWARE", 
			   pContext->ServerSoftware,&BufLen);
  BufLen = sizeof(pContext->ScriptName);
  pEcb->GetServerVariable( pEcb->ConnID, "SCRIPT_NAME", pContext->ScriptName,
			   &BufLen);
  
  strncpy(pContext->TopDir, DEFAULT_TOP_DIR, DEFAULT_TOP_DIR_LEN + 1);

  pContext->URLFileNameStart = pContext->SpecUrlRoot +
    sprintf(pContext->SpecUrlRoot, DEFAULT_URL_ROOT);
  
  pContext->LenTopDir = strlen(pContext->TopDir);
  strncpy(pContext->FileName,pContext->TopDir, pContext->LenTopDir);
  
  sprintf(pContext->LogFile, "%s/post.log", POST_LOG_DIR);
  
  pContext->Inbuf = malloc(INBUF_INITIAL_LEN);
  pContext->InbufLen = INBUF_INITIAL_LEN;
  
  pContext->Pid = getpid();
  
  pContext->LastAdReadTime = 0;
  
#ifndef CACHE_USER
  sprintf(TempBuf, "%s/%s",pContext->TopDir, USER_PERS_FILE);
  if (0 == (pContext->UserDemFd = fopen(TempBuf, "r"))) {
    pContext->BufCurLen += 
      sprintf(&pContext->Buffer[pContext->BufCurLen], "%sCan't open %s: %s",
	      HtmlHeader,TempBuf, strerror(errno));
    return -1;
  }
#endif

  return 0;
}


/* 
 * FUNCTION:	int ReturnPostLog(char *LogFile, char *HtmlStart,
 *				  EXTENSION_CONTROL_BLOCK *pEcb)
 *
 * PURPOSE:	Returns the post log.  The post log can be huge, so
 *		it is read and returned in 8192 byte chuncks.
 *
 * ARGUMENTS:	char	   *LogFile     Path of Post Log
 *		char       *HtmlStart   Start of HTML page for returning log
 *		EXTENSION_CONTROL_BLOCK
 *			   *pEcb	Control block containing info on
 *					client connection
 *
 * RETURNS:	HSE_STATUS_SUCCESS, HSE_STATUS_ERROR
 *
 * COMMENTS:	None
 *
 */

int 
ReturnPostLog (char *LogFile, char *HtmlStart, WebInputs_t *Inputs) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;

  int Desc;
  struct stat Stat;
  int HtmlLength;
  const char HeaderFormat[] = "Content-Type: text/html\nContent-Length: %d\n\n";
  char Header[256];
  int HeaderLen;
  int StartLen;
  int EndLen;

  char Buf[SEND_SIZE];
  int BytesSent;
  int BytesRead;

  /* Open the logfile and read the record count */
  if ((Desc = open(LogFile, O_RDONLY)) == -1)
    sprintf(Buf, "Error opening log file '%s': %s\n",
	    LogFile, strerror(errno));
  else {
    fstat(Desc, &Stat);
    StartLen = strlen(HtmlStart);
    EndLen = strlen (BOILERPLATE_END);
    HtmlLength = Stat.st_size + StartLen + EndLen;

    HeaderLen = sprintf(Header, HeaderFormat, HtmlLength);
    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				       HSE_REQ_SEND_RESPONSE_HEADER, 0,
				       &HeaderLen, (DWORD *) Header) )
      return HSE_STATUS_ERROR;

    pEcb->WriteClient( pEcb->ConnID, HtmlStart, &StartLen, 0);

    for (BytesSent = 0; BytesSent < Stat.st_size; BytesSent += BytesRead) {
      BytesRead = read(Desc, (void *)Buf, SEND_SIZE);
      pEcb->WriteClient( pEcb->ConnID, Buf, &BytesRead, 0);
    }

    pEcb->WriteClient( pEcb->ConnID, BOILERPLATE_END, &EndLen, 0);
  }
  return HSE_STATUS_SUCCESS;
}
/* 
 * FUNCTION:	int RunProgram(char *Path, ...)
 *
 * PURPOSE:     Runs the specified program in a forked process. 
 *		Returns to the caller only after the other program finishes.
 *
 * ARGUMENTS:	char       *Path        Path of the program to run
 *		...			The same arguments that execv expects
 *
 * RETURNS:	0 if all goes well, -1 if it doesn't
 *
 * COMMENTS:	Zeus processes ignore (SIG_IGN) the signal SIGCHLD,
 *		so we turn it on momentarily to wait for the child
 *		to finish .
 *		
 */


int
FinishHtmlAndSendBuffer(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;
  int EndLen;
  char Header[128];
  int HeaderLen;
  const char HeaderFormat[] = "Content-Type: text/html\nContent-Length: %d\n\n";


  EndLen = sizeof(BOILERPLATE_END);
  strncpy(&pContext->Buffer[pContext->BufCurLen], BOILERPLATE_END, EndLen);
  pContext->BufCurLen += EndLen - 1;

  /* Return headers. */
  HeaderLen = sprintf(Header, HeaderFormat, pContext->BufCurLen);
  if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				     HSE_REQ_SEND_RESPONSE_HEADER, 0,
				     &HeaderLen, (DWORD *) Header) ) {
    return HSE_STATUS_ERROR;
  }

  /* If we were given a cookie, then we need to return one, too */
  if (pContext->CookieStr[0] != '\0') { 
    HeaderLen = sprintf(Header, "Set-Cookie: %s", pContext->CookieStr);
    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				       HSE_REQ_SEND_RESPONSE_HEADER, 0,
				       &HeaderLen, (DWORD *) Header) )
      return HSE_STATUS_ERROR;
  }

  /* Return complete page */
#ifdef DEBUG
  HeaderLen = pContext->BufCurLen;
#endif
  pEcb->WriteClient( pEcb->ConnID, pContext->Buffer, &pContext->BufCurLen, 0);
#ifdef DEBUG
  if (pContext->BufCurLen != HeaderLen) 
    DebugLog("Bytes in WriteClient: %d NE Bytes in buffer: %d\n", pContext->BufCurLen, HeaderLen);
#endif
  return HSE_STATUS_SUCCESS;
}


  

